/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.util.HashMap;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.xml.sax.Attributes;

public class IDResolver {
    private String mGlobalID = "";
    private HashMap mNodeTypeIds = new HashMap();

    public IDResolver() {
    }

    public IDResolver(String globalID) {
        this.setGlobalID(globalID);
    }

    public void setGlobalID(String id) {
        this.mGlobalID = id;
    }

    public void addNodeTypeId(String nodeName, String attrName) {
        this.mNodeTypeIds.put(nodeName, attrName);
    }

    public boolean isIdName(String nodeName, String attrName) {
        String idAttrName;
        boolean retVal = attrName.equals(this.mGlobalID);
        if (!retVal && nodeName.length() > 0 && (idAttrName = (String)this.mNodeTypeIds.get(attrName)) != null && idAttrName.equals(attrName)) {
            retVal = true;
        }
        return retVal;
    }

    public String getIdValue(Element element) {
        String retVal = null;
        if (element != null) {
            if (this.mGlobalID.length() > 0) {
                retVal = element.attributeValue(this.mGlobalID);
            } else {
                String idName = (String)this.mNodeTypeIds.get(element.getName());
                if (idName != null && idName.length() > 0) {
                    retVal = element.attributeValue(idName);
                } else {
                    idName = (String)this.mNodeTypeIds.get(element.getQualifiedName());
                    if (idName != null && idName.length() > 0) {
                        retVal = element.attributeValue(idName);
                    }
                }
            }
        }
        return retVal;
    }

    public String getIdValue(Element element, Attributes attrs) {
        String retVal = null;
        if (element != null) {
            if (this.mGlobalID.length() > 0) {
                int index = attrs.getIndex(this.mGlobalID);
                if (index >= 0) {
                    retVal = attrs.getValue(index);
                }
            } else {
                String idName = (String)this.mNodeTypeIds.get(element.getName());
                if (idName != null && idName.length() > 0) {
                    int index = attrs.getIndex(idName);
                    if (index >= 0) {
                        retVal = attrs.getValue(index);
                    }
                } else {
                    int index;
                    idName = (String)this.mNodeTypeIds.get(element.getQualifiedName());
                    if (idName != null && idName.length() > 0 && (index = attrs.getIndex(idName)) >= 0) {
                        retVal = attrs.getValue(index);
                    }
                }
            }
        }
        return retVal;
    }

    public boolean isAttributeAnID(Element element, String attrname) {
        boolean retVal = false;
        if (element != null) {
            if (this.mGlobalID.length() > 0) {
                retVal = this.mGlobalID.equals(attrname);
            } else {
                String idName = (String)this.mNodeTypeIds.get(element.getName());
                if (idName != null && idName.length() > 0) {
                    retVal = idName.equals(attrname);
                } else {
                    idName = (String)this.mNodeTypeIds.get(element.getQualifiedName());
                    if (idName != null && idName.length() > 0) {
                        retVal = idName.equals(attrname);
                    }
                }
            }
        }
        return retVal;
    }

    public boolean isAttributeAnID(Element element, Attribute attr) {
        return this.isAttributeAnID(element, attr.getName());
    }
}

