/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.section;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnit;
import org.netbeans.modules.cnd.dwarfdump.elf.SectionHeader;
import org.netbeans.modules.cnd.dwarfdump.reader.DwarfReader;
import org.netbeans.modules.cnd.dwarfdump.reader.ElfReader;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfDebugInfoSection
extends ElfSection {
    List<CompilationUnit> compilationUnits = new ArrayList<CompilationUnit>();

    public DwarfDebugInfoSection(DwarfReader dwarfReader, int n) {
        super(dwarfReader, n);
    }

    public DwarfDebugInfoSection(ElfReader elfReader, int n, SectionHeader sectionHeader, String string) {
        super(elfReader, n, sectionHeader, string);
    }

    public int getCompilationUnitsNumber() {
        List<CompilationUnit> list = null;
        try {
            list = this.getCompilationUnits();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return list == null ? 0 : list.size();
    }

    public CompilationUnit getCompilationUnit(long l) {
        for (CompilationUnit compilationUnit : this.compilationUnits) {
            if (compilationUnit.unit_offset != l) continue;
            return compilationUnit;
        }
        return null;
    }

    public List<CompilationUnit> getCompilationUnits() throws IOException {
        if (this.compilationUnits.size() == 0) {
            int n = 0;
            while ((long)n != this.header.sh_size) {
                ((DwarfReader)this.reader).seek(this.header.getSectionOffset() + (long)n);
                if (this.reader.readDWlen() == 0L) break;
                CompilationUnit compilationUnit = new CompilationUnit((DwarfReader)this.reader, this.header.getSectionOffset(), n);
                this.compilationUnits.add(compilationUnit);
                n = (int)((long)n + compilationUnit.getUnitTotalLength());
            }
        }
        return this.compilationUnits;
    }

    @Override
    public void dump(PrintStream printStream) {
        try {
            for (CompilationUnit compilationUnit : this.getCompilationUnits()) {
                compilationUnit.dump(printStream);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

