/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.reader;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ByteStreamReader
implements DataInput {
    private RandomAccessFile file = null;
    private String fileName;
    private int dataEncoding = 0;
    private int fileClass = 0;
    private byte address_size = (byte)-1;
    public static final int LSB = 1;
    public static final int MSB = 2;

    public ByteStreamReader(String string, RandomAccessFile randomAccessFile) {
        this.file = randomAccessFile;
        this.fileName = string;
    }

    public void dispose() {
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.file = null;
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setDataEncoding(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("Wrong Data Encoding specified (" + n + ").");
        }
        this.dataEncoding = n;
    }

    public int getDataEncoding() {
        return this.dataEncoding;
    }

    public void seek(long l) throws IOException {
        this.file.seek(l);
    }

    public long getFilePointer() throws IOException {
        return this.file.getFilePointer();
    }

    public long length() throws IOException {
        return this.file.length();
    }

    public void setAddressSize(byte by) {
        this.address_size = by;
    }

    public byte getAddressSize() {
        return this.address_size;
    }

    public long readNumber(int n) throws IOException {
        byte[] byArray = new byte[n];
        long l = 0L;
        this.file.readFully(byArray);
        for (int i = 0; i < n; ++i) {
            long l2 = 0L;
            l2 = this.dataEncoding == 1 ? (long)(0xFF & byArray[i]) : (long)(0xFF & byArray[n - i - 1]);
            l |= l2 << i * 8;
        }
        return l;
    }

    public short readShort() throws IOException {
        return (short)this.readNumber(2);
    }

    public int readInt() throws IOException {
        return (int)this.readNumber(4);
    }

    public int readInt(boolean bl) throws IOException {
        if (bl) {
            return this.readInt();
        }
        return this.file.readInt();
    }

    public long readDWlen() throws IOException {
        long l = this.readInt();
        if (l == -1L) {
            l = this.readLong();
        }
        return l;
    }

    public long readLong() throws IOException {
        return this.readNumber(8);
    }

    public byte[] read(byte[] byArray) throws IOException {
        this.readFully(byArray);
        return byArray;
    }

    public void readFully(byte[] byArray) throws IOException {
        this.file.readFully(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.file.readFully(byArray, n, n2);
    }

    public int skipBytes(int n) throws IOException {
        return this.file.skipBytes(n);
    }

    public boolean readBoolean() throws IOException {
        return this.file.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.file.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.file.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.file.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.file.readChar();
    }

    public float readFloat() throws IOException {
        return this.file.readFloat();
    }

    public double readDouble() throws IOException {
        return this.file.readDouble();
    }

    public String readLine() throws IOException {
        return this.file.readLine();
    }

    public String readUTF() throws IOException {
        return this.file.readUTF();
    }

    public String readUTF(int n) throws IOException {
        byte[] byArray = new byte[n + 2];
        byArray[1] = (byte)(0xFF & n);
        byArray[0] = (byte)(0xFF & n >> 8);
        this.readFully(byArray, 2, n);
        return new DataInputStream(new ByteArrayInputStream(byArray)).readUTF();
    }

    private int readLEB128(boolean bl) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 128;
        while ((0x80 & n3) != 0) {
            n3 = this.file.readByte();
            n |= (0x7F & n3) << n2;
            n2 += 7;
        }
        if (bl && n2 < 32 && (0x40 & n3) != 0) {
            n |= -(1 << n2);
        }
        return n;
    }

    public int readUnsignedLEB128() throws IOException {
        return this.readLEB128(false);
    }

    public int readSignedLEB128() throws IOException {
        return this.readLEB128(true);
    }

    public int getFileClass() {
        return this.fileClass;
    }

    public void setFileClass(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("Wrong File Class specified (" + n + ").");
        }
        this.fileClass = n;
    }

    public String readString() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = -1;
        while (n != 0) {
            n = this.readByte();
            if (n == 0) continue;
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    public boolean is32Bit() {
        return this.fileClass == 1;
    }

    public boolean is64Bit() {
        return this.fileClass == 2;
    }

    public long read3264() throws IOException {
        return this.fileClass == 1 ? (long)this.readInt() : this.readLong();
    }
}

