/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.dwarf;

import java.io.PrintStream;
import java.util.ArrayList;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfEntry;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.ATTR;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.TAG;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfAbbriviationTableEntry {
    private long index;
    private long tag;
    private boolean hasChildren;
    private ArrayList<DwarfAttribute> attributes = new ArrayList();

    public DwarfAbbriviationTableEntry(long l, long l2, boolean bl) {
        this.index = l;
        this.tag = l2;
        this.hasChildren = bl;
    }

    public void addAttribute(int n, int n2) {
        if (n != 0 && n2 != 0) {
            this.attributes.add(new DwarfAttribute(n, n2));
        }
    }

    public long getTableIndex() {
        return this.index;
    }

    public int getAttribute(ATTR aTTR) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            DwarfAttribute dwarfAttribute = this.attributes.get(i);
            if (!dwarfAttribute.attrName.equals((Object)aTTR)) continue;
            return i;
        }
        return -1;
    }

    public DwarfAttribute getAttribute(int n) {
        return this.attributes.get(n);
    }

    public int getAttributesCount() {
        return this.attributes.size();
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public void dump() {
        this.dump(System.out, null);
    }

    public void dump(PrintStream printStream) {
        this.dump(printStream, null);
    }

    public void dump(PrintStream printStream, DwarfEntry dwarfEntry) {
        String string;
        printStream.println("Abbrev Number: " + this.index + " (" + (Object)((Object)this.getKind()) + ") " + " : " + (this.hasChildren ? "[has children]" : "[no children]"));
        if (dwarfEntry != null && (string = dwarfEntry.getQualifiedName()) != null) {
            printStream.println("\tQualified Name: " + string);
        }
        this.dumpAttributes(printStream, dwarfEntry.getValues());
    }

    public TAG getKind() {
        return TAG.get((int)this.tag);
    }

    private void dumpAttributes(PrintStream printStream, ArrayList<Object> arrayList) {
        for (int i = 0; i < this.getAttributesCount(); ++i) {
            if (arrayList == null) {
                this.getAttribute(i).dump(printStream);
                continue;
            }
            this.getAttribute(i).dump(printStream, arrayList.get(i));
        }
    }
}

