/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.project.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import org.netbeans.modules.uml.project.ui.common.ReferencedJavaProjectPanel;
import org.netbeans.modules.uml.project.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.uml.project.ui.wizards.SettingsPanel;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;

public class PanelOptionsVisual
extends SettingsPanel {
    private static boolean lastMainClassCheck = true;
    private PanelConfigureProject panelConfigureProject;
    private boolean valid;
    private int wizardType = 0;
    private ReferencedJavaProjectPanel javaProjectPanel;
    public static final String MODE_CHANGED_PROP = "MODE_CHANGED";

    public PanelOptionsVisual(PanelConfigureProject panelConfigureProject, int n) {
        this.initComponents();
        this.panelConfigureProject = panelConfigureProject;
        this.wizardType = n;
        switch (n) {
            case 0: 
            case 1: {
                this.hideJavaProjectPanel();
                break;
            }
            case 2: {
                this.createJavaProjectPanel();
                this.showJavaProjectPanel();
            }
        }
    }

    private void createJavaProjectPanel() {
        if (this.javaProjectPanel == null) {
            this.javaProjectPanel = new ReferencedJavaProjectPanel(this.panelConfigureProject, this.wizardType);
            this.add((Component)this.javaProjectPanel, "Center");
        }
    }

    private void showJavaProjectPanel() {
        this.javaProjectPanel.setVisible(true);
        this.javaProjectPanel.addPropertyChangeListener("ReferencedProjectProperty", this.panelConfigureProject);
        this.javaProjectPanel.addPropertyChangeListener("SOURCE_GROUP_CHANGED", this.panelConfigureProject);
    }

    private void hideJavaProjectPanel() {
        if (this.javaProjectPanel == null) {
            return;
        }
        this.javaProjectPanel.setVisible(false);
        this.javaProjectPanel.removePropertyChangeListener("ReferencedProjectProperty", this.panelConfigureProject);
        this.javaProjectPanel.removePropertyChangeListener("SOURCE_GROUP_CHANGED", this.panelConfigureProject);
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        if (this.javaProjectPanel != null) {
            return this.javaProjectPanel.valid(wizardDescriptor);
        }
        return true;
    }

    void read(WizardDescriptor wizardDescriptor) {
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
        if (this.wizardType != 2 || this.javaProjectPanel.getSelectedProject() == null) {
            // empty if block
        }
    }

    void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("setAsMain", (Object)Boolean.FALSE);
        if (this.wizardType == 0) {
            wizardDescriptor.putProperty("modelingMode", (Object)"Analysis");
        } else if (this.wizardType == 1) {
            wizardDescriptor.putProperty("modelingMode", (Object)"Design");
        }
        if (this.wizardType == 2) {
            wizardDescriptor.putProperty("modelingMode", (Object)"Implementation");
            wizardDescriptor.putProperty("javaSrcProject", (Object)this.javaProjectPanel.getSelectedProject());
            wizardDescriptor.putProperty("javaSourceRootsModel", (Object)this.javaProjectPanel.getJavaSourceRootsModel());
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.getAccessibleContext().setAccessibleName("");
        this.getAccessibleContext().setAccessibleDescription("");
    }
}

