/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.project.ui.java;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.uml.core.metamodel.core.constructs.IClass;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPackage;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.core.typemanagement.ITypeManager;
import org.netbeans.modules.uml.project.AssociatedSourceProvider;
import org.netbeans.modules.uml.project.UMLProjectHelper;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLJavaAssociationUtil {
    public static Project getAssociatedUMLProject(DataObject dataObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
        return UMLJavaAssociationUtil.getAssociatedUMLProject(project);
    }

    public static Project getAssociatedUMLProject(Project project) {
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            AssociatedSourceProvider associatedSourceProvider = (AssociatedSourceProvider)projectArray[i].getLookup().lookup(AssociatedSourceProvider.class);
            if (associatedSourceProvider == null) continue;
            Project project2 = associatedSourceProvider.getCodeGenTargetProject();
            if (project == project2) {
                return projectArray[i];
            }
            Project project3 = associatedSourceProvider.getAssociatedSourceProject();
            if (project != project3) continue;
            return projectArray[i];
        }
        return null;
    }

    public static List<Project> getAllAssociatedUMLProjects(DataObject dataObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
        return UMLJavaAssociationUtil.getAllAssociatedUMLProjects(project);
    }

    public static List<Project> getAllAssociatedUMLProjects(Project project) {
        ArrayList<Project> arrayList = new ArrayList<Project>();
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            AssociatedSourceProvider associatedSourceProvider = (AssociatedSourceProvider)projectArray[i].getLookup().lookup(AssociatedSourceProvider.class);
            if (associatedSourceProvider == null) continue;
            Project project2 = associatedSourceProvider.getCodeGenTargetProject();
            if (project == project2) {
                arrayList.add(projectArray[i]);
                continue;
            }
            Project project3 = associatedSourceProvider.getAssociatedSourceProject();
            if (project != project3) continue;
            arrayList.add(projectArray[i]);
        }
        return arrayList;
    }

    public static INamedElement findElement(Project project, String string, Class clazz) {
        UMLProjectHelper uMLProjectHelper = null;
        uMLProjectHelper = (UMLProjectHelper)project.getLookup().lookup(UMLProjectHelper.class);
        if (uMLProjectHelper == null) {
            return null;
        }
        IProject iProject = uMLProjectHelper.getProject();
        if (iProject == null) {
            return null;
        }
        ITypeManager iTypeManager = iProject.getTypeManager();
        if (iTypeManager == null) {
            return null;
        }
        String string2 = UMLJavaAssociationUtil.convertJavaToUML(string);
        ETList eTList = iTypeManager.getLocalCachedTypesByName(string2);
        int n = eTList != null ? eTList.getCount() : 0;
        for (int i = 0; i < n; ++i) {
            String string3;
            INamedElement iNamedElement = (INamedElement)eTList.item(i);
            if (iNamedElement == null || clazz != null && !clazz.isAssignableFrom(iNamedElement.getClass()) || !(string3 = UMLJavaAssociationUtil.getFullyQualifiedName(iNamedElement)).equals(string) && !string3.replace('$', '.').equals(string)) continue;
            return iNamedElement;
        }
        return null;
    }

    public static String convertJavaToUML(String string) {
        String string2 = string.replace('$', '.');
        int n = string2.indexOf(".");
        while (n > 0) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            string2 = stringBuffer.replace(n, n + 1, "::").toString();
            n = string2.indexOf(".");
        }
        return string2;
    }

    public static String convertJavaToUML(String string, String string2) {
        String string3 = string.length() > 0 ? string + "." : "";
        String string4 = string3 + string2;
        return UMLJavaAssociationUtil.convertJavaToUML(string4);
    }

    public static String convertUMLtoJava(String string) {
        String string2 = string;
        int n = string2.indexOf("::");
        while (n > 0) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            string2 = stringBuffer.replace(n, n + 2, ".").toString();
            n = string2.indexOf("::");
        }
        return string2;
    }

    public static String getFullyQualifiedName(INamedElement iNamedElement) {
        StringBuffer stringBuffer = new StringBuffer(iNamedElement.getName());
        for (IElement iElement = iNamedElement.getOwner(); iElement != null; iElement = iElement.getOwner()) {
            IClass iClass;
            if (iElement instanceof IClass) {
                iClass = (IClass)iElement;
                stringBuffer.insert(0, '$');
                stringBuffer.insert(0, iClass.getName());
                continue;
            }
            if (!(iElement instanceof IPackage) || iElement instanceof IProject) break;
            iClass = (IPackage)iElement;
            stringBuffer.insert(0, '.');
            stringBuffer.insert(0, iClass.getName());
        }
        return stringBuffer.toString();
    }
}

