/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.project.ui.customizer;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;

public class UMLImportsSupport {
    private PropertyEvaluator evaluator;
    private ReferenceHelper referenceHelper;
    private AntProjectHelper antProjectHelper;
    private Set wellKnownPaths;
    private String libraryPrefix;
    private String librarySuffix;
    private String umlImportPrefix;

    public UMLImportsSupport(PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, AntProjectHelper antProjectHelper, String string) {
        this.evaluator = propertyEvaluator;
        this.referenceHelper = referenceHelper;
        this.antProjectHelper = antProjectHelper;
        this.umlImportPrefix = string;
    }

    public Iterator itemsIterator(String string) {
        return this.itemsList(string).iterator();
    }

    public List itemsList(String string) {
        String[] stringArray = PropertyUtils.tokenizePath((String)(string == null ? "" : string));
        ArrayList<Item> arrayList = new ArrayList<Item>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            Item item;
            Object[] objectArray = this.referenceHelper.findArtifactAndLocation(stringArray[i]);
            if (objectArray[0] == null || objectArray[1] == null) {
                item = Item.createBroken(stringArray[i]);
            } else {
                File file;
                AntArtifact antArtifact = (AntArtifact)objectArray[0];
                URI uRI = (URI)objectArray[1];
                File file2 = this.antProjectHelper.resolveFile(this.evaluator.evaluate(stringArray[i]));
                item = file2.equals(file = new File(antArtifact.getScriptLocation().toURI().resolve(uRI).normalize())) ? Item.create(antArtifact, uRI, stringArray[i]) : Item.createBroken(stringArray[i]);
            }
            arrayList.add(item);
        }
        return arrayList;
    }

    public String[] encodeToStrings(Iterator iterator) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            String string = null;
            string = stringArray.getReference();
            if (stringArray.isBroken()) break;
            AntArtifact antArtifact = stringArray.getArtifact();
            if (string == null) {
                if (antArtifact == null) break;
                string = this.referenceHelper.addReference(stringArray.getArtifact(), stringArray.getArtifactURI());
            }
            if (string == null) continue;
            arrayList.add(string);
        }
        stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = i < arrayList.size() - 1 ? arrayList.get(i) + ":" : (String)arrayList.get(i);
        }
        return stringArray;
    }

    private boolean isUMLImport(String string) {
        return this.umlImportPrefix == null ? false : string.startsWith(this.umlImportPrefix);
    }

    public static class Item {
        private static final String BROKEN = "BrokenReference";
        private Object object;
        private URI artifactURI;
        private String property;

        private Item(Object object, String string) {
            this.object = object;
            this.property = string;
        }

        private Item(Object object, URI uRI, String string) {
            this(object, string);
            this.artifactURI = uRI;
        }

        public static Item create(AntArtifact antArtifact, URI uRI, String string) {
            if (uRI == null) {
                throw new IllegalArgumentException("artifactURI must not be null");
            }
            if (antArtifact == null) {
                throw new IllegalArgumentException("artifact must not be null");
            }
            return new Item(antArtifact, uRI, string);
        }

        public static Item createBroken(String string) {
            if (string == null) {
                throw new IllegalArgumentException("property must not be null in broken items");
            }
            return new Item(BROKEN, string);
        }

        public AntArtifact getArtifact() {
            return (AntArtifact)this.object;
        }

        public URI getArtifactURI() {
            return this.artifactURI;
        }

        public String getReference() {
            return this.property;
        }

        public boolean isBroken() {
            return this.object == BROKEN;
        }

        public int hashCode() {
            int n = 0;
            if (this.object == BROKEN) {
                return BROKEN.hashCode();
            }
            n += this.getArtifact().getType().hashCode();
            n += this.getArtifact().getScriptLocation().hashCode();
            return n += this.getArtifactURI().hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Item)) {
                return false;
            }
            Item item = (Item)object;
            if (this.isBroken() != item.isBroken()) {
                return false;
            }
            if (this.isBroken()) {
                return this.getReference().equals(item.getReference());
            }
            if (this.getArtifact().getType() != item.getArtifact().getType()) {
                return false;
            }
            if (!this.getArtifact().getScriptLocation().equals(item.getArtifact().getScriptLocation())) {
                return false;
            }
            return this.getArtifactURI().equals(item.getArtifactURI());
        }

        public String toString() {
            return this.artifactURI.toString();
        }

        public String getDirectoryLocation() {
            String string = "";
            if (this.object instanceof AntArtifact) {
                AntArtifact antArtifact = (AntArtifact)this.object;
                Project project = antArtifact.getProject();
                FileObject fileObject = project.getProjectDirectory();
                string = fileObject.getPath();
            }
            return string;
        }
    }
}

