/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.project.ui;

import java.io.File;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class UMLProjectSettings {
    private static final String NEW_PROJECT_COUNT = "newProjectCount";
    private static final String LAST_USED_ARTIFACT_FOLDER = "lastUsedArtifactFolder";
    private static final String LAST_ROSE_FILE_LOCATION = "lastRoseFileLocation";

    public static UMLProjectSettings getDefault() {
        return new UMLProjectSettings();
    }

    private static Preferences prefs() {
        return NbPreferences.forModule(UMLProjectSettings.class);
    }

    public int getNewProjectCount() {
        return UMLProjectSettings.prefs().getInt(NEW_PROJECT_COUNT, 0);
    }

    public String getLastRoseFileLocation() {
        return UMLProjectSettings.prefs().get(LAST_ROSE_FILE_LOCATION, "");
    }

    public void setNewProjectCount(int n) {
        UMLProjectSettings.prefs().putInt(NEW_PROJECT_COUNT, n);
    }

    public void setLastRoseFileLocation(String string) {
        UMLProjectSettings.prefs().put(LAST_ROSE_FILE_LOCATION, string);
    }

    public File getLastUsedArtifactFolder() {
        return new File(UMLProjectSettings.prefs().get(LAST_USED_ARTIFACT_FOLDER, System.getProperty("user.home")));
    }

    public void setLastUsedArtifactFolder(File file) {
        assert (file != null) : "Folder can not be null";
        String string = file.getAbsolutePath();
        UMLProjectSettings.prefs().put(LAST_USED_ARTIFACT_FOLDER, string);
    }
}

