/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.project;

import java.io.File;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.uml.core.coreapplication.CoreProductManager;
import org.netbeans.modules.uml.core.coreapplication.ICoreProduct;
import org.netbeans.modules.uml.core.coreapplication.ICoreProductManager;
import org.netbeans.modules.uml.core.coreapplication.IProductDescriptor;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.support.IAssociatedProjectSourceRoots;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.project.AssociatedSourceProvider;
import org.netbeans.modules.uml.project.UMLProject;
import org.netbeans.modules.uml.project.UMLProjectModule;
import org.netbeans.modules.uml.project.ui.MDREventProcessor;
import org.netbeans.modules.uml.project.ui.customizer.UMLProjectProperties;
import org.netbeans.modules.uml.ui.products.ad.applicationcore.ADProduct;
import org.netbeans.modules.uml.ui.products.ad.applicationcore.IADApplication;
import org.netbeans.modules.uml.ui.products.ad.applicationcore.IADProduct;
import org.netbeans.spi.project.CacheDirectoryProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.w3c.dom.Element;

public class UMLProjectHelper {
    private AntProjectHelper antHelper = null;
    private IProject mProject = null;
    private UMLProject mNBProject = null;
    private IADProduct mADProduct = null;
    private IADApplication mApplication = null;

    public UMLProjectHelper(AntProjectHelper antProjectHelper, UMLProject uMLProject) {
        this.antHelper = antProjectHelper;
        this.mNBProject = uMLProject;
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.antHelper;
    }

    public EditableProperties getProperties(String string) {
        EditableProperties editableProperties = this.antHelper.getProperties(string);
        return editableProperties;
    }

    public int hashCode() {
        int n = this.antHelper.hashCode();
        return n;
    }

    public FileObject getProjectDirectory() {
        FileObject fileObject = this.antHelper.getProjectDirectory();
        return fileObject;
    }

    public Element getPrimaryConfigurationData(boolean bl) {
        Element element = this.antHelper.getPrimaryConfigurationData(bl);
        return element;
    }

    public String toString() {
        String string = this.antHelper.toString();
        return string;
    }

    public void addAntProjectListener(AntProjectListener antProjectListener) {
        this.antHelper.addAntProjectListener(antProjectListener);
    }

    public void putPrimaryConfigurationData(Element element, boolean bl) throws IllegalArgumentException {
        this.antHelper.putPrimaryConfigurationData(element, bl);
    }

    public void putProperties(String string, EditableProperties editableProperties) {
        this.antHelper.putProperties(string, editableProperties);
    }

    public void removeAntProjectListener(AntProjectListener antProjectListener) {
        this.antHelper.removeAntProjectListener(antProjectListener);
    }

    public PropertyEvaluator getStandardPropertyEvaluator() {
        return this.antHelper.getStandardPropertyEvaluator();
    }

    public CacheDirectoryProvider createCacheDirectoryProvider() {
        return this.antHelper.createCacheDirectoryProvider();
    }

    public String resolvePath(String string) {
        String string2 = this.antHelper.resolvePath(string);
        return string2;
    }

    public boolean equals(Object object) {
        boolean bl = this.antHelper.equals(object);
        return bl;
    }

    public FileObject resolveFileObject(String string) {
        FileObject fileObject = this.antHelper.resolveFileObject(string);
        return fileObject;
    }

    public File resolveFile(String string) {
        File file = this.antHelper.resolveFile(string);
        return file;
    }

    public void setProject(IProject iProject) {
        this.mProject = iProject;
    }

    public IProject getProject() {
        if (this.mProject == null) {
            this.initializeProject();
        }
        return this.mProject;
    }

    public File getProjectFile() {
        File file = null;
        FileObject fileObject = this.getProjectDirectory();
        if (fileObject != null) {
            file = FileUtil.toFile((FileObject)fileObject);
        }
        return file;
    }

    protected String getDisplayName() {
        return this.mNBProject.getName();
    }

    protected void initializeProject() {
        Object object;
        if (this.mProject != null) {
            return;
        }
        UMLProjectModule.checkInit();
        this.mADProduct = this.getProduct();
        if (this.mADProduct != null) {
            object = this.mADProduct.initialize2(false);
            this.mApplication = (IADApplication)object;
        }
        if (this.mApplication != null) {
            AssociatedSourceProvider associatedSourceProvider;
            object = this.getDisplayName();
            File file = new File(this.getProjectFile(), "build.xml");
            String string = (String)object + ".etd";
            File file2 = new File(file.getParentFile(), string);
            this.mProject = null;
            if (file2.exists()) {
                this.mProject = this.mApplication.openProject(file2.getAbsolutePath());
            }
            if (this.mProject == null) {
                this.mProject = this.mApplication.createProject();
                associatedSourceProvider = this.getProperties("nbproject/project.properties");
                String string2 = associatedSourceProvider.getProperty("uml.modeling.mode");
                this.mProject.setMode(string2);
                this.mProject.setName((String)object);
                this.mProject.setFileName(file2.getAbsolutePath());
            }
            associatedSourceProvider = (AssociatedSourceProvider)this.mNBProject.getLookup().lookup(AssociatedSourceProvider.class);
            this.mProject.setAssociatedProjectSourceRoots((IAssociatedProjectSourceRoots)associatedSourceProvider);
        }
    }

    protected IADProduct getProduct() {
        ADProduct aDProduct = null;
        ICoreProductManager iCoreProductManager = CoreProductManager.instance();
        ETList eTList = iCoreProductManager.getProducts();
        if (eTList == null || eTList.size() == 0) {
            aDProduct = new ADProduct();
            iCoreProductManager.setCoreProduct((ICoreProduct)aDProduct);
        } else {
            IProductDescriptor iProductDescriptor = (IProductDescriptor)eTList.get(0);
            if (iProductDescriptor.getCoreProduct() instanceof IADProduct) {
                aDProduct = (IADProduct)iProductDescriptor.getCoreProduct();
            }
        }
        return aDProduct;
    }

    public void closeProject(boolean bl) {
        if (this.mProject == null) {
            return;
        }
        this.mApplication.closeProject(this.mProject, bl);
        this.mNBProject.removeUMLProjectMetaListener();
        this.mProject = null;
    }

    public void saveProject() {
        if (this.mApplication != null) {
            this.mApplication.saveProject(this.mProject);
        }
    }

    public void scanSourceGroups() {
        UMLProjectHelper.scanSourceGroups(this.mNBProject);
    }

    public static void scanSourceGroups(UMLProject uMLProject) {
        if (uMLProject != null) {
            UMLProjectProperties uMLProjectProperties = uMLProject.getUMLProjectProperties();
            uMLProjectProperties.init();
            Lookup lookup = uMLProject.getLookup();
            AssociatedSourceProvider associatedSourceProvider = (AssociatedSourceProvider)lookup.lookup(AssociatedSourceProvider.class);
            if (associatedSourceProvider != null) {
                final SourceGroup[] sourceGroupArray = associatedSourceProvider.getSourceGroups();
                RequestProcessor requestProcessor = new RequestProcessor("Post Scan Request Processor");
                requestProcessor.post(new Runnable(){

                    public void run() {
                        MDREventProcessor.getInstance().fireChanged(null, sourceGroupArray);
                    }
                });
            }
        }
    }
}

