/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.project;

import java.awt.Component;
import java.beans.PropertyVetoException;
import java.io.File;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.uml.common.RelationshipCookie;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.diagrams.IDiagram;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.project.UMLProject;
import org.netbeans.modules.uml.project.UMLProjectHelper;
import org.netbeans.modules.uml.project.ui.UMLProjectSettings;
import org.netbeans.modules.uml.project.ui.nodes.ModelRootNodeCookie;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeItem;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectUtil {
    public static final Comparator PROJECT_BY_DISPLAYNAME = new ProjectByDisplayNameComparator();
    public static final String DEFAULT_PACKAGE_DISPLAY_NAME = "<default package>";
    private static final RequestProcessor RP = new RequestProcessor();

    public static Project findElementOwner(IElement iElement) {
        Project project = null;
        if (iElement != null) {
            IElement iElement2 = iElement.getOwner();
            if (iElement2 != null) {
                IProject iProject = iElement2.getProject();
                project = ProjectUtil.findNetBeansProjectForModel(iProject);
            } else {
                project = ProjectUtil.findNetBeansProjectForModel(iElement.getProject());
            }
        }
        return project;
    }

    public static Project findReferencingProject(IElement iElement) {
        Project project = null;
        if (iElement != null) {
            IProject iProject = iElement.getProject();
            project = ProjectUtil.findNetBeansProjectForModel(iProject);
        }
        return project;
    }

    public static Project findNetBeansProjectForModel(IProject iProject) {
        FileObject fileObject;
        String string;
        Project project = null;
        if (iProject != null && (string = iProject.getFileName()) != null && string.length() > 0 && (fileObject = FileUtil.toFileObject((File)new File(string))) != null) {
            project = FileOwnerQuery.getOwner((FileObject)fileObject);
        }
        return project;
    }

    public static boolean findElementInProjectTree(IElement iElement) {
        Node node = ProjectUtil.findNodeInProjectTree(iElement);
        if (node != null) {
            ProjectUtil.selectNodeAsync(node);
            return true;
        }
        return false;
    }

    public static Node findNodeInProjectTree(IElement iElement) {
        Project project = ProjectUtil.findReferencingProject(iElement);
        return ProjectUtil.findNodeInProjectTree(project, iElement);
    }

    public static Node findNodeInProjectTree(Project project, IElement iElement) {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent("projectTabLogical_tc");
        if (topComponent == null) {
            return null;
        }
        ExplorerManager explorerManager = ((ExplorerManager.Provider)topComponent).getExplorerManager();
        Node node = explorerManager.getRootContext();
        Children children = node.getChildren();
        Node[] nodeArray = children.getNodes(true);
        for (int i = 0; i < nodeArray.length; ++i) {
            Project project2 = (Project)nodeArray[i].getLookup().lookup(Project.class);
            if (project2 != project) continue;
            Node node2 = ProjectUtil.findNodeQuick(nodeArray[i], iElement);
            if (node2 == null) {
                node2 = ProjectUtil.findNode(nodeArray[i], iElement);
            }
            return node2;
        }
        return null;
    }

    public static AntProjectHelper getAntProjectHelper(UMLProject uMLProject) {
        return ((UMLProjectHelper)uMLProject.getLookup().lookup(UMLProjectHelper.class)).getAntProjectHelper();
    }

    public static String getTargetJavaProjectName(UMLProject uMLProject) {
        AntProjectHelper antProjectHelper = ProjectUtil.getAntProjectHelper(uMLProject);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        return editableProperties.getProperty("uml.javaproject");
    }

    private static String getTargetJavaProjectName(IProject iProject) {
        return ProjectUtil.getTargetJavaProjectName((UMLProject)ProjectUtil.findNetBeansProjectForModel(iProject));
    }

    public static String getTargetJavaProjectName(IElement iElement) {
        UMLProject uMLProject = (UMLProject)ProjectUtil.findReferencingProject(iElement);
        return ProjectUtil.getTargetJavaProjectName(uMLProject);
    }

    public static String getTargetJavaProjectName(Node node) {
        IElement iElement = (IElement)node.getCookie(IElement.class);
        if (iElement == null) {
            return null;
        }
        return ProjectUtil.getTargetJavaProjectName(iElement);
    }

    public static boolean hasTargetJavaProject(Node node) {
        String string = ProjectUtil.getTargetJavaProjectName(node);
        return string != null && string.length() != 0;
    }

    public static boolean hasTargetJavaProject(IProject iProject) {
        String string = ProjectUtil.getTargetJavaProjectName(iProject);
        return string != null && string.length() != 0;
    }

    public static Node findNode(Node node, IElement iElement) {
        IProjectTreeItem iProjectTreeItem;
        int n;
        if (node.isLeaf()) {
            return null;
        }
        Children children = node.getChildren();
        Node[] nodeArray = children.getNodes(true);
        for (n = 0; n < nodeArray.length; ++n) {
            iProjectTreeItem = (IProjectTreeItem)nodeArray[n].getCookie(IProjectTreeItem.class);
            if (iProjectTreeItem == null) continue;
            IElement iElement2 = iProjectTreeItem.getModelElement();
            if (iElement2 == null && iElement instanceof IDiagram && iProjectTreeItem.getDiagram() != null && iProjectTreeItem.getDescription().equals(((IDiagram)iElement).getFilename())) {
                return nodeArray[n];
            }
            if (iElement2 == null || !iElement.getXMIID().equals(iElement2.getXMIID()) || nodeArray[n].getCookie(RelationshipCookie.class) != null) continue;
            return nodeArray[n];
        }
        for (n = 0; n < nodeArray.length; ++n) {
            if (nodeArray[n].isLeaf() || (iProjectTreeItem = ProjectUtil.findNode(nodeArray[n], iElement)) == null) continue;
            return iProjectTreeItem;
        }
        return null;
    }

    private static Node findNodeQuick(Node node, IElement iElement) {
        if (node.isLeaf()) {
            return null;
        }
        if (iElement == null) {
            return null;
        }
        IElement iElement2 = iElement.getOwner();
        if (iElement2 == null) {
            return ProjectUtil.findNode(node, iElement);
        }
        Node node2 = ProjectUtil.findNodeQuick(node, iElement2);
        if (node2 != null) {
            return ProjectUtil.findNode(node2, iElement);
        }
        return null;
    }

    public static Project[] getSelectedProjects(Class clazz) {
        Object object2;
        HashSet<Project> hashSet = new HashSet<Project>();
        Lookup lookup = Utilities.actionsGlobalContext();
        Collection collection = lookup.lookup(new Lookup.Template(clazz)).allInstances();
        for (Object object2 : collection) {
            hashSet.add((Project)object2);
        }
        Collection collection2 = lookup.lookup(new Lookup.Template(DataObject.class)).allInstances();
        object2 = collection2.iterator();
        while (object2.hasNext()) {
            Project project;
            DataObject dataObject = (DataObject)object2.next();
            FileObject fileObject = dataObject.getPrimaryFile();
            if (fileObject == null || (project = FileOwnerQuery.getOwner((FileObject)fileObject)) == null) continue;
            hashSet.add(project);
        }
        object2 = new Project[hashSet.size()];
        hashSet.toArray((T[])object2);
        Arrays.sort(object2, PROJECT_BY_DISPLAYNAME);
        return object2;
    }

    public static Project[] getOpenUMLProjects() {
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        HashSet<Project> hashSet = new HashSet<Project>();
        for (Project project : projectArray) {
            if (project.getLookup().lookup(UMLProjectHelper.class) == null) continue;
            hashSet.add(project);
        }
        Project[] projectArray2 = new Project[hashSet.size()];
        hashSet.toArray(projectArray2);
        Arrays.sort(projectArray2, PROJECT_BY_DISPLAYNAME);
        return projectArray2;
    }

    public static Project[] getOpenJavaProjects() {
        Project[] projectArray;
        ArrayList<Project> arrayList = new ArrayList<Project>();
        for (Project project : projectArray = OpenProjects.getDefault().getOpenProjects()) {
            ClassPathProvider classPathProvider;
            SourceGroup[] sourceGroupArray;
            Sources sources = (Sources)project.getLookup().lookup(Sources.class);
            if (sources == null || (sourceGroupArray = sources.getSourceGroups("java")).length <= 0 || (classPathProvider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class)) == null) continue;
            arrayList.add(project);
        }
        Project[] projectArray2 = arrayList.toArray(new Project[arrayList.size()]);
        Arrays.sort(projectArray2, PROJECT_BY_DISPLAYNAME);
        return projectArray2;
    }

    public static void selectInModel(List<Project> list, DataObject dataObject) {
        String string = "";
        String string2 = "";
        String string3 = DEFAULT_PACKAGE_DISPLAY_NAME;
        boolean bl = dataObject instanceof DataFolder;
        if (dataObject == null) {
            return;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath != null) {
            string = classPath.getResourceName(fileObject);
        }
        if (string.indexOf(".") != -1) {
            string = string.substring(0, string.indexOf("."));
            string2 = string.substring(string.lastIndexOf("/") + 1);
            int n = string.lastIndexOf("/");
            if (n > -1) {
                string3 = string.substring(0, n);
            }
        } else {
            string3 = string;
        }
        TopComponent topComponent = WindowManager.getDefault().findTopComponent("projectTabLogical_tc");
        if (topComponent == null) {
            return;
        }
        ExplorerManager explorerManager = ((ExplorerManager.Provider)topComponent).getExplorerManager();
        Node node = explorerManager.getRootContext();
        Children children = node.getChildren();
        Node[] nodeArray = children.getNodes(true);
        for (int i = 0; i < nodeArray.length; ++i) {
            String string4;
            Project project = (Project)nodeArray[i].getLookup().lookup(Project.class);
            Object var15_16 = null;
            if (!list.contains(project)) continue;
            Node node2 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "/");
            if (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
                node2 = ProjectUtil.findNodeByName(nodeArray[i], string4, true);
                while (node2 != null && stringTokenizer.hasMoreTokens()) {
                    node2 = ProjectUtil.findNodeByName(node2, stringTokenizer.nextToken(), true);
                }
            }
            if (!bl && node2 != null) {
                node2 = ProjectUtil.findNodeByName(node2, string2, false);
            }
            if ((string4 = node2) == null) continue;
            ProjectUtil.selectNodeAsync((Node)string4);
            return;
        }
    }

    public static Node findNodeByName(Node node, String string, boolean bl) {
        if (node == null || node.isLeaf()) {
            return null;
        }
        Children children = node.getChildren();
        Node[] nodeArray = children.getNodes(true);
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node2 = nodeArray[i];
            if (node2.getCookie(ModelRootNodeCookie.class) != null) {
                if (string.equals(DEFAULT_PACKAGE_DISPLAY_NAME)) {
                    return node2;
                }
                return ProjectUtil.findNodeByName(node2, string, bl);
            }
            IElement iElement = (IElement)node2.getCookie(IElement.class);
            if (iElement == null) continue;
            String string2 = iElement.getElementType();
            if (bl) {
                if (!node2.getName().equals(string) || !string2.equals("Package")) continue;
                return node2;
            }
            if ((!node2.getName().equals(string) || !string2.equals("Class")) && !string2.equals("Interface")) continue;
            return nodeArray[i];
        }
        return null;
    }

    public static void selectNodeAsync(final Node node) {
        final TopComponent topComponent = WindowManager.getDefault().findTopComponent("projectTabLogical_tc");
        if (topComponent == null) {
            return;
        }
        final ExplorerManager explorerManager = ((ExplorerManager.Provider)topComponent).getExplorerManager();
        topComponent.setCursor(Utilities.createProgressCursor((Component)topComponent));
        topComponent.open();
        topComponent.requestActive();
        RP.post(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (node != null) {
                            try {
                                explorerManager.setSelectedNodes(new Node[]{node});
                                StatusDisplayer.getDefault().setStatusText("");
                            }
                            catch (PropertyVetoException propertyVetoException) {}
                        } else {
                            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ProjectUtil.class, (String)"MSG_NodeNotFound"));
                        }
                        topComponent.setCursor(null);
                    }
                });
            }
        });
    }

    public static String createUniqueProjectName(File file, String string, boolean bl) {
        String string2 = null;
        if (string == null || string.length() == 0) {
            string = NbBundle.getMessage(ProjectUtil.class, (String)"TXT_UMLProject");
        }
        int n = UMLProjectSettings.getDefault().getNewProjectCount() + 1;
        if (bl) {
            string2 = ProjectUtil.validFreeProjectName(file, string, -1);
        }
        while (string2 == null) {
            string2 = ProjectUtil.validFreeProjectName(file, string + "{0}", n);
            ++n;
        }
        return string2;
    }

    private static String validFreeProjectName(File file, String string, int n) {
        String string2 = "";
        string2 = n == -1 ? string : MessageFormat.format(string, new Integer(n));
        File file2 = new File(file, string2);
        return file2.exists() ? null : string2;
    }

    public static IProject getOwningProjectOfImportedElement(IElement iElement) {
        IElement iElement2 = iElement.getOwner();
        if (!(iElement2 instanceof IProject)) {
            return ProjectUtil.getOwningProjectOfImportedElement(iElement2);
        }
        return (IProject)iElement2;
    }

    public static class ProjectByDisplayNameComparator
    implements Comparator {
        private static Comparator COLLATOR = Collator.getInstance();

        public int compare(Object object, Object object2) {
            if (!(object instanceof Project)) {
                return 1;
            }
            if (!(object2 instanceof Project)) {
                return -1;
            }
            Project project = (Project)object;
            Project project2 = (Project)object2;
            return COLLATOR.compare(ProjectUtils.getInformation((Project)project).getDisplayName(), ProjectUtils.getInformation((Project)project2).getDisplayName());
        }
    }
}

