/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.swing.text.Document;
import org.netbeans.modules.xml.lib.Convertors;
import org.netbeans.modules.xml.sync.SyncRepresentation;
import org.netbeans.modules.xml.sync.Synchronizator;
import org.netbeans.modules.xml.text.TextEditorSupport;
import org.netbeans.modules.xml.text.Util;
import org.xml.sax.InputSource;

public abstract class TextRepresentation
extends SyncRepresentation {
    protected final TextEditorSupport editor;

    public TextRepresentation(TextEditorSupport textEditorSupport, Synchronizator synchronizator) {
        super(synchronizator);
        this.editor = textEditorSupport;
    }

    public boolean represents(Class clazz) {
        return Document.class.isAssignableFrom(clazz);
    }

    public int level() {
        return 1;
    }

    public Object getChange(Class clazz) {
        if (clazz == null || clazz.isAssignableFrom(Document.class)) {
            return this.editor.getDocument();
        }
        if (clazz.isAssignableFrom(String.class)) {
            try {
                return Convertors.documentToString(this.editor.openDocument());
            }
            catch (IOException iOException) {
                Util.THIS.debug(iOException);
                return null;
            }
        }
        if (clazz.isAssignableFrom(InputSource.class)) {
            InputSource inputSource;
            block12: {
                inputSource = null;
                try {
                    inputSource = Convertors.documentToInputSource(this.editor.openDocument());
                }
                catch (IOException iOException) {
                    Util.THIS.debug(iOException);
                    return null;
                }
                try {
                    URL uRL = this.editor.getDataObject().getPrimaryFile().getURL();
                    String string = uRL.toExternalForm();
                    inputSource.setSystemId(string);
                }
                catch (IOException iOException) {
                    if (!Util.THIS.isLoggable()) break block12;
                    Util.THIS.debug("Warning: missing file object, external entities cannot be parsed.");
                }
            }
            return inputSource;
        }
        if (clazz.isAssignableFrom(Reader.class)) {
            try {
                return new StringReader(Convertors.documentToString(this.editor.openDocument()));
            }
            catch (IOException iOException) {
                Util.THIS.debug(iOException);
                return null;
            }
        }
        throw new RuntimeException("Unsupported type: " + clazz);
    }

    public String getDisplayName() {
        return Util.THIS.getString("PROP_Text_representation");
    }

    public Class getUpdateClass() {
        return String.class;
    }
}

