/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.lib;

import java.awt.Color;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public abstract class AbstractUtil {
    private ErrorManager packageErrorManager;
    private static final int DEBUG_SEVERITY = 1;

    public final String getString(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return NbBundle.getMessage(this.getClass(), (String)string);
    }

    public final String getString(String string, Object object) {
        if (string == null) {
            throw new NullPointerException();
        }
        return NbBundle.getMessage(this.getClass(), (String)string, (Object)object);
    }

    public final String getString(String string, Object object, Object object2) {
        if (string == null) {
            throw new NullPointerException();
        }
        return NbBundle.getMessage(this.getClass(), (String)string, (Object)object, (Object)object2);
    }

    public final char getChar(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return NbBundle.getMessage(this.getClass(), (String)string).charAt(0);
    }

    public final Color getColor(String string) {
        String string2 = null;
        try {
            string2 = this.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ", \t");
        if (stringTokenizer.countTokens() < 3) {
            if (stringTokenizer.countTokens() == 1 && "null".equals(stringTokenizer.nextToken())) {
                return null;
            }
            throw new MissingResourceException("Invalid color format: " + string2, this.getClass().getName(), string);
        }
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        int n = Integer.parseInt(string3);
        if (n < 0 || n > 255) {
            throw new MissingResourceException("Invalid color format: " + string2, this.getClass().getName(), string);
        }
        int n2 = Integer.parseInt(string4);
        if (n2 < 0 || n2 > 255) {
            throw new MissingResourceException("Invalid color format: " + string2, this.getClass().getName(), string);
        }
        int n3 = Integer.parseInt(string5);
        if (n3 < 0 || n3 > 255) {
            throw new MissingResourceException("Invalid color format: " + string2, this.getClass().getName(), string);
        }
        return new Color(n, n2, n3);
    }

    public final boolean isLoggable() {
        return this.getErrorManager().isLoggable(1);
    }

    public final void debug(String string) {
        if (string == null) {
            return;
        }
        this.getErrorManager().log(1, string);
    }

    public final void debug(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        this.getErrorManager().notify(1, throwable);
    }

    public final void debug(String string, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        if (string != null) {
            throwable = this.getErrorManager().annotate(throwable, 1, string, null, null, null);
        }
        this.debug(throwable);
    }

    public final synchronized ErrorManager getErrorManager() {
        if (this.packageErrorManager == null) {
            String string = "org.netbeans.modules.xml.core.lib";
            this.packageErrorManager = ErrorManager.getDefault().getInstance(string);
        }
        return this.packageErrorManager;
    }
}

