/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.api.xml.cookies.CookieMessage;
import org.netbeans.api.xml.cookies.CookieObserver;
import org.netbeans.api.xml.cookies.XMLProcessorDetail;
import org.netbeans.modules.xml.actions.Util;
import org.openide.ErrorManager;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.WeakSet;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public final class InputOutputReporter
implements CookieObserver {
    private final String FORMAT = "{0} [{1}] {2}";
    private String ioName;
    private DataObject dataObject;
    private static final Set hyperlinks = Collections.synchronizedSet(new WeakSet());

    public InputOutputReporter() {
        this(Util.THIS.getString("TITLE_XML_check_window"));
    }

    public InputOutputReporter(String string) {
        this.initInputOutput(string);
    }

    public void setNode(Node node) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("InputOutputReporter.setNode: " + node, new RuntimeException("Who calls InputOutputReporter.setNode"));
        }
        this.dataObject = (DataObject)node.getCookie(DataObject.class);
    }

    private DataObject dataObject() {
        return this.dataObject;
    }

    public void receive(CookieMessage cookieMessage) {
        Object object = cookieMessage.getDetail(XMLProcessorDetail.class);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("InputOutputReporter.receive:");
            Util.THIS.debug("    dataObject = " + this.dataObject);
            Util.THIS.debug("    Message = " + cookieMessage);
            Util.THIS.debug("    detail  = " + object);
            if (object == null) {
                Util.THIS.debug(new RuntimeException("Message's Detail is _null_!!!"));
            }
        }
        if (object instanceof XMLProcessorDetail) {
            this.display(this.dataObject(), cookieMessage.getMessage(), (XMLProcessorDetail)object);
        } else {
            this.message(cookieMessage.getMessage());
        }
    }

    public void message(String string) {
        this.out().println(string);
    }

    public final void moveToFront() {
        this.moveToFront(false);
    }

    public final void moveToFront(boolean bl) {
        boolean bl2 = this.tab().isFocusTaken();
        this.tab().select();
        this.tab().setFocusTaken(true);
        this.out().write("\r");
        this.tab().setFocusTaken(bl2);
        if (bl) {
            this.out().close();
        }
    }

    private void display(DataObject dataObject, String string, XMLProcessorDetail xMLProcessorDetail) {
        String string2;
        DataObject dataObject2;
        block7: {
            dataObject2 = null;
            try {
                string2 = xMLProcessorDetail.getSystemId();
                URL uRL = new URL(string2);
                FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                if (fileObject != null) {
                    dataObject2 = DataObject.find((FileObject)fileObject);
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("InputOutputReporter.display: " + string);
                    Util.THIS.debug("    systemId = " + xMLProcessorDetail.getSystemId());
                    Util.THIS.debug("    url = " + uRL);
                    Util.THIS.debug("    fos = " + fileObject);
                }
            }
            catch (MalformedURLException malformedURLException) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug(malformedURLException);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                if (!Util.THIS.isLoggable()) break block7;
                Util.THIS.debug(dataObjectNotFoundException);
            }
        }
        string2 = "";
        if (dataObject2 == null) {
            string2 = xMLProcessorDetail.getSystemId();
        }
        this.display(dataObject2, string, string2, xMLProcessorDetail.getLineNumber(), xMLProcessorDetail.getColumnNumber());
    }

    private void display(DataObject dataObject, String string, String string2, int n, int n2) {
        Object object;
        String string3 = null;
        if (n >= 0) {
            object = new Object[]{string, new Integer(n), string2};
            string3 = MessageFormat.format("{0} [{1}] {2}", object);
        } else {
            string3 = string;
        }
        if (dataObject == null) {
            this.out().println(string3);
        } else {
            try {
                object = new Hyperlink(string3, dataObject, Math.max(n - 1, 0), Math.max(n2 - 1, 0));
                this.out().println(string3, (OutputListener)object);
            }
            catch (IOException iOException) {
                this.out().println(string3);
            }
        }
    }

    private void initInputOutput(String string) {
        this.ioName = string;
        this.tab().setFocusTaken(false);
        try {
            this.out().reset();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private OutputWriter out() {
        return this.tab().getOut();
    }

    private InputOutput tab() {
        return IOProvider.getDefault().getIO(this.ioName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseAllAnnotations() {
        Set set = hyperlinks;
        synchronized (set) {
            Iterator iterator = hyperlinks.iterator();
            while (iterator.hasNext()) {
                ((Hyperlink)iterator.next()).detach();
            }
            hyperlinks.clear();
        }
    }

    private static class Hyperlink
    extends Annotation
    implements OutputListener,
    PropertyChangeListener {
        private Line xline;
        private int column;
        private final String message;

        public Hyperlink(String string, DataObject dataObject, int n, int n2) throws IOException {
            this.column = n2;
            this.message = string;
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (lineCookie == null) {
                throw new FileNotFoundException();
            }
            this.xline = lineCookie.getLineSet().getCurrent(n);
        }

        public void outputLineSelected(OutputEvent outputEvent) {
            try {
                this.markError();
                this.show(0);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        public void outputLineAction(OutputEvent outputEvent) {
            try {
                this.markError();
                this.show(2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        public void outputLineCleared(OutputEvent outputEvent) {
            hyperlinks.remove(this);
            this.detach();
        }

        protected void notifyDetached(Annotatable annotatable) {
            annotatable.removePropertyChangeListener((PropertyChangeListener)this);
        }

        protected void notifyAttached(Annotatable annotatable) {
            annotatable.addPropertyChangeListener((PropertyChangeListener)this);
        }

        private Annotatable createAnnotatable() {
            return this.xline;
        }

        private void show(int n) {
            if (this.column == -1) {
                this.xline.show(n);
            } else {
                this.xline.show(n, this.column);
            }
        }

        private void markError() {
            InputOutputReporter.releaseAllAnnotations();
            hyperlinks.add(this);
            this.attach(this.createAnnotatable());
        }

        public String getAnnotationType() {
            return "org-netbeans-modules-xml-error";
        }

        public String getShortDescription() {
            return this.message;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null || string.equals("text") || string.equals("deleted")) {
                this.column = -1;
                hyperlinks.remove(this);
                this.detach();
            }
        }
    }
}

