/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml;

import java.io.IOException;
import org.netbeans.modules.xml.DTDDataObject;
import org.netbeans.modules.xml.Util;
import org.netbeans.modules.xml.XMLDataLoader;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;

public final class DTDDataLoader
extends UniFileLoader {
    private static final long serialVersionUID = 1954391380343387000L;
    private static final String DTD_EXT = "dtd";
    private static final String MOD_EXT = "mod";

    public DTDDataLoader() {
        super("org.netbeans.modules.xml.DTDDataObject");
    }

    protected void initialize() {
        super.initialize();
        ExtensionList extensionList = this.getExtensions();
        extensionList.addExtension(DTD_EXT);
        extensionList.addExtension(MOD_EXT);
        extensionList.addMimeType("application/xml-dtd");
        extensionList.addMimeType("text/x-dtd");
        this.setExtensions(extensionList);
    }

    protected String actionsContext() {
        return "Loaders/text/x-dtd/Actions/";
    }

    protected String defaultDisplayName() {
        return Util.THIS.getString("PROP_DtdLoader_Name");
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        return new XMLDataLoader.XMLFileEntry(multiDataObject, fileObject);
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        return new DTDDataObject(fileObject, this);
    }
}

