/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.reporting.wizard;

import java.awt.Dimension;
import java.text.MessageFormat;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.uml.reporting.StateChangeSupport;
import org.netbeans.modules.uml.reporting.wizard.ReportLocationPanel;
import org.netbeans.modules.uml.reporting.wizard.ReportWizardSettings;
import org.netbeans.modules.uml.reporting.wizard.WizardPanelBase;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class WebReportWizardIterator
implements WizardDescriptor.Iterator {
    private WizardPanelBase[] panels;
    Dimension preferredSize;
    private StateChangeSupport changeSupport = new StateChangeSupport(this);
    private int index;

    public WebReportWizardIterator(ReportWizardSettings reportWizardSettings) {
        this.panels = new WizardPanelBase[]{new ReportLocationPanel()};
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(WebReportWizardIterator.class, (String)"TITLE_WebReportWizardIterator_wizardTitle"), new Integer(this.index + 1), new Integer(this.panels.length));
    }

    public WizardDescriptor.Panel current() {
        this.updateCurrentPanel();
        return this.panels[this.index];
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
        this.changeSupport.fireStateChanged();
    }

    protected void updateCurrentPanel() {
        this.panels[this.index].putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.index));
        this.panels[this.index].putClientProperty("WizardPanel_contentData", this.getSteps());
    }

    public String[] getSteps() {
        String[] stringArray = new String[this.panels.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.panels[i].getName();
        }
        return stringArray;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (this.hasNext()) {
            ++this.index;
            this.changeSupport.fireStateChanged();
        }
    }

    public void previousPanel() {
        if (this.hasPrevious()) {
            --this.index;
            this.changeSupport.fireStateChanged();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeListener(changeListener);
    }
}

