/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.reporting.dataobjects;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.uml.core.metamodel.core.constructs.IEnumeration;
import org.netbeans.modules.uml.core.metamodel.core.constructs.IEnumerationLiteral;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IClassifier;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.reporting.dataobjects.DataTypeData;
import org.netbeans.modules.uml.reporting.dataobjects.ElementDataObject;
import org.openide.util.NbBundle;

public class EnumerationData
extends DataTypeData {
    private IEnumeration element;

    public EnumerationData() {
    }

    public EnumerationData(IClassifier iClassifier) {
        super(iClassifier);
    }

    public void setElement(IElement iElement) {
        if (iElement instanceof IEnumeration) {
            this.element = (IEnumeration)iElement;
        }
    }

    public IEnumeration getElement() {
        return this.element;
    }

    public boolean toReport(File file) {
        if (this.getElement() == null) {
            return false;
        }
        boolean bl = false;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, ENCODING);
            String string = "";
            outputStreamWriter.write(this.getHTMLHeader());
            outputStreamWriter.write("<BODY BGCOLOR=\"white\">\r\n");
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("<HR>\r\n");
            outputStreamWriter.write("<H2>\r\n");
            outputStreamWriter.write("<FONT SIZE=\"-1\">" + this.getOwningPackageName() + "</FONT>\r\n");
            outputStreamWriter.write("<BR>\r\n");
            outputStreamWriter.write(this.getElementType() + " " + this.getElement().getName() + "</H2>\r\n");
            outputStreamWriter.write(this.getDependencies());
            outputStreamWriter.write(this.getAssociations());
            outputStreamWriter.write(this.getGeneralizations());
            outputStreamWriter.write(this.getSpecifications());
            outputStreamWriter.write(this.getEnclosingClassSection());
            outputStreamWriter.write(this.getEnclosingDiagrams());
            outputStreamWriter.write(this.getDocumentation());
            outputStreamWriter.write(this.getProperties());
            outputStreamWriter.write(this.getStereoTypesSummary());
            outputStreamWriter.write(this.getTaggedValueSummary());
            outputStreamWriter.write(this.getConstraintsSummary());
            ETList eTList = this.getElement().getLiterals();
            if (eTList.size() > 0) {
                outputStreamWriter.write("<!-- =========== LITERAL SUMMARY =========== -->\r\n\r\n");
                outputStreamWriter.write(this.getSummaryHeader("literal_summary", NbBundle.getMessage(EnumerationData.class, (String)"Literal_Summary")));
                for (int i = 0; i < eTList.size(); ++i) {
                    IEnumerationLiteral iEnumerationLiteral = (IEnumerationLiteral)eTList.get(i);
                    string = iEnumerationLiteral.getDocumentation();
                    string = string.equals("") ? "&nbsp;" : string;
                    outputStreamWriter.write("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\r\n");
                    outputStreamWriter.write("<TD ALIGN=\"left\" VALIGN=\"top\" WIDTH=\"15%\">\r\n");
                    outputStreamWriter.write(iEnumerationLiteral.getName() + "</TD>\r\n");
                    outputStreamWriter.write("<TD>" + string + "\r\n");
                    outputStreamWriter.write("</TD>\r\n</TR>\r\n");
                }
                outputStreamWriter.write("</TABLE>\r\n&nbsp;\r\n");
            }
            outputStreamWriter.write("<HR>\r\n");
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("</BODY>\r\n</HTML>");
            outputStreamWriter.close();
            bl = true;
        }
        catch (Exception exception) {
            Logger.getLogger(ElementDataObject.class.getName()).log(Level.SEVERE, this.getElement().getElementType() + " - " + this.getElement().getNameWithAlias(), exception);
            bl = false;
        }
        return bl;
    }
}

