/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.reporting.dataobjects;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.structure.IArtifact;
import org.netbeans.modules.uml.core.metamodel.structure.IDeploymentSpecification;
import org.netbeans.modules.uml.core.metamodel.structure.INode;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.reporting.dataobjects.ElementDataObject;
import org.openide.util.NbBundle;

public class DeploymentSpecificationData
extends ElementDataObject {
    private IDeploymentSpecification element;

    public void setElement(IElement iElement) {
        if (iElement instanceof IDeploymentSpecification) {
            this.element = (IDeploymentSpecification)iElement;
        }
    }

    public IDeploymentSpecification getElement() {
        return this.element;
    }

    protected String[] getPropertyNames() {
        return new String[]{Property_Alias, Property_Visibility, Property_Deployment_Location, Property_Execution_Location, Property_Container};
    }

    protected Object[] getPropertyValues() {
        return new Object[]{this.getElement().getAlias(), this.getVisibility((INamedElement)this.getElement()), this.getElement().getDeploymentLocation(), this.getElement().getExecutionLocation(), this.getElement().getContainer()};
    }

    public boolean toReport(File file) {
        if (this.getElement() == null) {
            return false;
        }
        boolean bl = false;
        INode iNode = this.getElement().getContainer();
        ETList eTList = this.getElement().getDeploymentDescriptors();
        String string = this.getElement().getDeploymentLocation();
        String string2 = this.getElement().getExecutionLocation();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, ENCODING);
            outputStreamWriter.write(this.getHTMLHeader());
            outputStreamWriter.write("<BODY BGCOLOR=\"white\">\r\n");
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("<HR>\r\n");
            outputStreamWriter.write("<H2>\r\n");
            outputStreamWriter.write("<FONT SIZE=\"-1\">" + this.getOwningPackageName() + "</FONT>\r\n");
            outputStreamWriter.write("<BR>\r\n");
            outputStreamWriter.write(this.getElementType() + " " + this.getElement().getName() + "</H2>\r\n");
            outputStreamWriter.append(this.getDependencies());
            outputStreamWriter.append(this.getEnclosingDiagrams());
            outputStreamWriter.write(this.getDocumentation());
            outputStreamWriter.write(this.getProperties());
            outputStreamWriter.write(this.getDependencies());
            outputStreamWriter.write(this.getStereoTypesSummary());
            outputStreamWriter.write(this.getTaggedValueSummary());
            outputStreamWriter.write(this.getConstraintsSummary());
            if (eTList.size() > 0) {
                outputStreamWriter.write("<!-- =========== DESCRIPTOR SUMMARY =========== -->\r\n");
                outputStreamWriter.write(this.getSummaryHeader("descriptor_summary", NbBundle.getMessage(DeploymentSpecificationData.class, (String)"Descriptor_Summary")));
                for (int i = 0; i < eTList.size(); ++i) {
                    IArtifact iArtifact = (IArtifact)eTList.get(i);
                    String string3 = iArtifact.getFileName();
                    if (string3 == null || string3.trim().equals("")) {
                        string3 = "&nbsp;";
                    }
                    outputStreamWriter.write("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\r\n");
                    outputStreamWriter.write("<TD WIDTH=\"15%\"><B>" + iArtifact.getName() + "</B></TD>\r\n");
                    outputStreamWriter.write("<TD>" + string3 + "</TD>\r\n");
                    outputStreamWriter.write("</TR>\r\n");
                }
                outputStreamWriter.write("</TABLE>\r\n&nbsp;\r\n<P>\r\n");
            }
            outputStreamWriter.write("<HR>\r\n");
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("</BODY>\r\n</HTML>");
            outputStreamWriter.close();
            bl = true;
        }
        catch (Exception exception) {
            Logger.getLogger(ElementDataObject.class.getName()).log(Level.SEVERE, this.getElement().getElementType() + " - " + this.getElement().getNameWithAlias(), exception);
            bl = false;
        }
        return bl;
    }
}

