/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.reporting.dataobjects;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.structure.IComment;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.reporting.dataobjects.ElementDataObject;
import org.netbeans.modules.uml.reporting.dataobjects.EnumerationData;
import org.openide.util.NbBundle;

public class CommentData
extends ElementDataObject {
    IComment element;

    public CommentData() {
    }

    public CommentData(IElement iElement) {
        this.setElement(iElement);
    }

    public void setElement(IElement iElement) {
        if (iElement instanceof IComment) {
            this.element = (IComment)iElement;
        }
    }

    public IComment getElement() {
        return this.element;
    }

    public boolean toReport(File file) {
        if (this.getElement() == null) {
            return false;
        }
        boolean bl = false;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, ENCODING);
            outputStreamWriter.write(this.getHTMLHeader());
            outputStreamWriter.write("<BODY BGCOLOR=\"white\">\r\n");
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("<HR>\r\n");
            outputStreamWriter.write("<H2>\r\n");
            outputStreamWriter.write("<FONT SIZE=\"-1\">" + this.getOwningPackageName() + "</FONT>\r\n");
            outputStreamWriter.write("<BR>\r\n");
            outputStreamWriter.write(this.getElementType() + " " + this.getElement().getName() + "</H2>\r\n");
            outputStreamWriter.write(this.getEnclosingDiagrams());
            outputStreamWriter.write("<P><B>" + NbBundle.getMessage(CommentData.class, (String)"Documentation") + ":</B><BR>\r\n");
            outputStreamWriter.write(this.getElement().getDocumentation());
            outputStreamWriter.write("</P>");
            outputStreamWriter.write("<P><B>" + NbBundle.getMessage(CommentData.class, (String)"Body") + ":</B><BR>\r\n");
            outputStreamWriter.write(this.getElement().getBody());
            outputStreamWriter.write("</P>");
            outputStreamWriter.write("<HR>\r\n");
            ETList eTList = this.getElement().getAnnotatedElements();
            if (eTList.size() > 0) {
                outputStreamWriter.write("<!-- =========== ANNOTATED ELEMENT SUMMARY =========== -->\r\n\r\n");
                outputStreamWriter.write(this.getSummaryHeader("annotated_element_summary", NbBundle.getMessage(EnumerationData.class, (String)"Annotated_Element_Summary")));
                String string = "";
                for (int i = 0; i < eTList.size(); ++i) {
                    INamedElement iNamedElement = (INamedElement)eTList.get(i);
                    string = this.getBriefDocumentation(iNamedElement.getDocumentation());
                    string = string.equals("") ? "&nbsp;" : string;
                    outputStreamWriter.write("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\r\n");
                    outputStreamWriter.write("<TD ALIGN=\"left\" VALIGN=\"top\" WIDTH=\"15%\">\r\n");
                    outputStreamWriter.write("<B><A HREF=\"" + this.getLinkTo((IElement)iNamedElement) + "\">" + iNamedElement.getName() + "</A></B></TD>\r\n");
                    outputStreamWriter.write("<TD>" + string + "\r\n");
                    outputStreamWriter.write("</TD>\r\n</TR>\r\n");
                }
                outputStreamWriter.write("</TABLE>\r\n&nbsp;\r\n");
            }
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("</BODY>\r\n</HTML>");
            outputStreamWriter.close();
            bl = true;
        }
        catch (Exception exception) {
            Logger.getLogger(ElementDataObject.class.getName()).log(Level.SEVERE, this.getElement().getElementType() + " - " + this.getElement().getNameWithAlias(), exception);
            bl = false;
        }
        return bl;
    }
}

