/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.reporting.dataobjects;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.dynamics.ICombinedFragment;
import org.netbeans.modules.uml.core.metamodel.dynamics.IInteractionOperand;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.reporting.dataobjects.ClassData;
import org.netbeans.modules.uml.reporting.dataobjects.ElementDataObject;
import org.openide.util.NbBundle;

public class CombinedFragmentData
extends ElementDataObject {
    private ICombinedFragment element;

    public void setElement(IElement iElement) {
        if (iElement instanceof ICombinedFragment) {
            this.element = (ICombinedFragment)iElement;
        }
    }

    public ICombinedFragment getElement() {
        return this.element;
    }

    protected String[] getPropertyNames() {
        return new String[]{Property_Alias, Property_Visibility, Property_Operator};
    }

    protected Object[] getPropertyValues() {
        return new Object[]{this.getElement().getAlias(), this.getVisibility((INamedElement)this.getElement()), NbBundle.getMessage(CombinedFragmentData.class, (String)("CombinedFragment_Operator" + this.getElement().getOperator()))};
    }

    public boolean toReport(File file) {
        if (this.getElement() == null) {
            return false;
        }
        boolean bl = false;
        try {
            String string;
            Object object;
            int n;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, ENCODING);
            outputStreamWriter.write(this.getHTMLHeader());
            outputStreamWriter.write("<BODY BGCOLOR=\"white\">\r\n");
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("<HR>\r\n");
            outputStreamWriter.write("<H2>\r\n");
            outputStreamWriter.write("<FONT SIZE=\"-1\">" + this.getOwningPackageName() + "</FONT>\r\n");
            outputStreamWriter.write("<BR>\r\n");
            outputStreamWriter.write(this.getElementType() + " " + this.getElement().getName() + "</H2>\r\n");
            outputStreamWriter.write(this.getDependencies());
            outputStreamWriter.write(this.getEnclosingDiagrams());
            outputStreamWriter.write(this.getDocumentation());
            outputStreamWriter.write(this.getProperties());
            outputStreamWriter.write(this.getStereoTypesSummary());
            outputStreamWriter.write(this.getTaggedValueSummary());
            outputStreamWriter.write(this.getConstraintsSummary());
            ETList eTList = this.getElement().getOperands();
            if (eTList.size() > 0) {
                outputStreamWriter.write("<!-- =========== OPERAND SUMMARY =========== -->\r\n\r\n");
                outputStreamWriter.write(this.getSummaryHeader("operand_summary", NbBundle.getMessage(ClassData.class, (String)"Operand_Summary")));
                for (n = 0; n < eTList.size(); ++n) {
                    outputStreamWriter.write("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\r\n");
                    object = ((IInteractionOperand)eTList.get(n)).getName();
                    if (((String)object).equals("")) {
                        object = NbBundle.getMessage(CombinedFragmentData.class, (String)"unnamed");
                    }
                    string = (IInteractionOperand)eTList.get(n);
                    outputStreamWriter.write("<TD WIDTH=\"15%\"><B><A HREF=\"#" + (String)object + "\">" + (String)object + "</A></B></TD>");
                    outputStreamWriter.write("<TD>" + this.getBriefDocumentation(string.getDocumentation()) + "</TD>\r\n");
                    outputStreamWriter.write("</TR>\r\n");
                }
                outputStreamWriter.write("</TABLE>\r\n&nbsp;\r\n");
            }
            if (eTList.size() > 0) {
                outputStreamWriter.write("<!-- =========== OPERAND DETAIL =========== -->\r\n\r\n");
                outputStreamWriter.write(this.getDetailHeader("operand_detail", NbBundle.getMessage(CombinedFragmentData.class, (String)"Operand_Detail")));
                for (n = 0; n < eTList.size(); ++n) {
                    object = (IInteractionOperand)eTList.get(n);
                    string = object.getName();
                    string = string.equals("") ? NbBundle.getMessage(CombinedFragmentData.class, (String)"unnamed") : string;
                    outputStreamWriter.write("<A NAME=\"" + string + "\"></A><H3>" + string + "</H3>\r\n");
                    outputStreamWriter.write("<DL>\r\n");
                    outputStreamWriter.write("<DD>" + object.getDocumentation() + "\r\n<P>\r\n</DD>\r\n</DL>\r\n");
                    if (object.getGuard() != null) {
                        outputStreamWriter.write("<DL>\r\n");
                        outputStreamWriter.write("<DD>" + object.getGuard().getExpression() + "\r\n<P>\r\n</DD>\r\n</DL>\r\n");
                    }
                    if (n < eTList.size() - 1) {
                        outputStreamWriter.write("<HR>\r\n\r\n");
                        continue;
                    }
                    outputStreamWriter.write("\r\n");
                }
            }
            outputStreamWriter.write("<HR>\r\n");
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("</BODY>\r\n</HTML>");
            outputStreamWriter.close();
            bl = true;
        }
        catch (Exception exception) {
            Logger.getLogger(ElementDataObject.class.getName()).log(Level.SEVERE, this.getElement().getElementType() + " - " + this.getElement().getNameWithAlias(), exception);
            bl = false;
        }
        return bl;
    }
}

