/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.reporting;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IConfigManager;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPackage;
import org.netbeans.modules.uml.core.metamodel.core.foundation.UMLXMLManip;
import org.netbeans.modules.uml.core.metamodel.diagrams.IDiagram;
import org.netbeans.modules.uml.core.metamodel.diagrams.IProxyDiagram;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAssociationEnd;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.project.UMLProjectHelper;
import org.netbeans.modules.uml.reporting.GenerateModelReportAction;
import org.netbeans.modules.uml.reporting.dataobjects.DataObjectFactory;
import org.netbeans.modules.uml.reporting.dataobjects.DiagramData;
import org.netbeans.modules.uml.reporting.dataobjects.ElementDataObject;
import org.netbeans.modules.uml.reporting.wizard.ReportWizardSettings;
import org.netbeans.modules.uml.resources.images.ImageUtil;
import org.netbeans.modules.uml.ui.controls.projecttree.DefaultNodeFactory;
import org.netbeans.modules.uml.ui.controls.projecttree.ProjectTreeNodeFactory;
import org.netbeans.modules.uml.ui.support.ProductHelper;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProxyUserInterface;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ITreeDiagram;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ITreeFolder;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ITreeItem;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ProjectTreeBuilderImpl;
import org.openide.ErrorManager;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ReportTask
extends Thread
implements Cancellable {
    private DisplayNameComparator comparator = new DisplayNameComparator();
    private boolean cancelled = false;
    private long start;
    private IProject m_CurrentProject;
    private IElement startingPoint;
    private ProjectTreeBuilderImpl m_Builder;
    private boolean success = true;
    public static String ENCODING = "UTF-8";
    private static InputOutput inputOutput = IOProvider.getDefault().getIO(NbBundle.getMessage(ReportTask.class, (String)"TITLE_ReportOutput"), false);
    private File reportDir;
    private ArrayList diagrams = new ArrayList();
    private ArrayList packages = new ArrayList();
    private HashMap<String, ITreeItem> elements = new HashMap(500);
    private HashMap<String, String> elementFileMap = new HashMap(500);
    private HashMap<String, String> diagramFileMap = new HashMap();
    public static String FRAME = "-frame";
    public static String HTML_EXT = ".html";
    public static String OVERVIEW_FILE = "overview.html";
    public static String ELEMENT_INDEX_FILE = "element-index.html";
    public static String HELP_FILE = "help.html";
    public static String JPG_EXT = ".jpg";
    public static String IMAGE_EXT = ".png";
    private static ArrayList<String> opened = new ArrayList();
    private static String[] files = new String[]{"org/netbeans/modules/uml/reporting/templates/zoom.js", "org/netbeans/modules/uml/reporting/templates/behaviour.js", "org/netbeans/modules/uml/reporting/templates/stylesheet.css", "org/netbeans/modules/uml/reporting/templates/index.html", "org/netbeans/modules/uml/reporting/templates/help.html"};
    private static List<String> imageFilenames = new ArrayList<String>();

    public ReportTask(ReportWizardSettings reportWizardSettings) {
        Project project = reportWizardSettings.getProject();
        this.startingPoint = reportWizardSettings.getElement();
        UMLProjectHelper uMLProjectHelper = (UMLProjectHelper)project.getLookup().lookup(UMLProjectHelper.class);
        this.m_CurrentProject = uMLProjectHelper.getProject();
        this.m_Builder = new ProjectTreeBuilderImpl((ProjectTreeNodeFactory)new DefaultNodeFactory());
        this.reportDir = reportWizardSettings.getReportFolder();
        this.initialize();
    }

    public String getReportDir() {
        return this.reportDir.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String string = NbBundle.getMessage(GenerateModelReportAction.class, (String)"MSG_GenerateModelReportAction_Generate", (Object)this.m_CurrentProject.getName());
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string, (Cancellable)this);
        try {
            progressHandle.start();
            this.start = System.currentTimeMillis();
            this.generateReport();
        }
        catch (Exception exception) {
            Logger.getLogger(ElementDataObject.class.getName()).log(Level.SEVERE, string, exception);
        }
        finally {
            this.finish();
            progressHandle.finish();
        }
    }

    public void generateReport() {
        ITreeItem iTreeItem = this.m_Builder.createChild(null, (Object)this.startingPoint);
        this.loadDataElement(iTreeItem);
        for (int i = 0; i < this.diagrams.size(); ++i) {
            DiagramData diagramData;
            ITreeDiagram iTreeDiagram = (ITreeDiagram)this.diagrams.get(i);
            if (iTreeDiagram == null) continue;
            IDiagram iDiagram = iTreeDiagram.getData().getDiagram().getDiagram();
            if (iDiagram == null) {
                iDiagram = ReportTask.loadDiagram(iTreeDiagram.getData().getDiagram().getFilename());
            }
            if ((diagramData = new DiagramData(iTreeDiagram)).toReport(new File(this.getDirectoryPath((ITreeItem)iTreeDiagram)))) {
                this.diagramFileMap.put(iTreeDiagram.getDiagram().getDiagram().getXMIID(), ReportTask.getLinkPathToDiagram(iTreeDiagram.getData().getDiagram()));
                continue;
            }
            this.success = false;
            ReportTask.log(NbBundle.getMessage(ReportTask.class, (String)"Log_error_generating", (Object)iTreeDiagram.getDiagram().getDiagram().getName()));
        }
        if (!this.cancelled) {
            this.processSummaryPages();
            this.launchReport();
        }
    }

    private void finish() {
        for (int i = 0; i < opened.size(); ++i) {
            ProductHelper.getProductDiagramManager().closeDiagram(opened.get(i));
        }
        long l = (System.currentTimeMillis() - this.start) / 1000L;
        int n = (int)l / 60;
        int n2 = (int)(l - (long)(n * 60));
        ReportTask.log(NbBundle.getMessage(ReportTask.class, (String)"Log_processed", (Object)this.elements.size(), (Object)this.diagrams.size()));
        String string = n == 0 ? n2 + " " + NbBundle.getMessage(ReportTask.class, (String)"Log_seconds") : n + " " + NbBundle.getMessage(ReportTask.class, (String)"Log_minutes") + " " + n2 + " " + NbBundle.getMessage(ReportTask.class, (String)"Log_seconds");
        string = NbBundle.getMessage(ReportTask.class, (String)"Log_totaltime", (Object)string);
        if (this.cancelled) {
            ReportTask.log(NbBundle.getMessage(ReportTask.class, (String)"Log_Report_Cancelled") + " " + string);
        } else if (this.success) {
            ReportTask.log(NbBundle.getMessage(ReportTask.class, (String)"Log_Report_Successful") + " " + string);
        } else {
            ReportTask.log(NbBundle.getMessage(ReportTask.class, (String)"Log_Report_Failed") + " " + string);
        }
        inputOutput.getOut().flush();
        inputOutput.getOut().close();
    }

    public boolean cancel() {
        this.cancelled = true;
        return true;
    }

    private void initialize() {
        opened.clear();
        File file = new File(this.getReportDir() + File.separator + "images");
        file.mkdirs();
        file = null;
        for (int i = 0; i < files.length; ++i) {
            this.copyFiles(files[i]);
        }
        this.initLog();
        ReportTask.log(NbBundle.getMessage(ReportTask.class, (String)"Log_generating_report_for", (Object)this.m_CurrentProject.getName(), (Object)this.getReportDir()));
    }

    public void loadDataElement(ITreeItem iTreeItem) {
        if (this.cancelled) {
            return;
        }
        if (iTreeItem instanceof ITreeDiagram) {
            IProxyDiagram iProxyDiagram;
            ITreeDiagram iTreeDiagram = (ITreeDiagram)iTreeItem;
            if (iTreeDiagram != null && (iProxyDiagram = iTreeDiagram.getDiagram()) != null) {
                this.diagrams.add(iTreeDiagram);
            }
        } else {
            this.createFileForElement(iTreeItem);
            this.processChildren(iTreeItem);
        }
    }

    public void processChildren(ITreeItem iTreeItem) {
        if (iTreeItem != null && iTreeItem.getData() != null) {
            ITreeItem[] iTreeItemArray;
            if (iTreeItem.getData().getModelElement() != null && (iTreeItemArray = iTreeItem.getData().getModelElement().getXMIID()) != null && !this.elements.containsKey(iTreeItemArray)) {
                this.elements.put((String)iTreeItemArray, iTreeItem);
            }
            if ((iTreeItemArray = this.m_Builder.retrieveChildItemsSorted((Object)iTreeItem)) != null && iTreeItemArray.length > 0) {
                for (ITreeItem iTreeItem2 : iTreeItemArray) {
                    if (iTreeItem2 == null) continue;
                    if (iTreeItem.getData().getModelElement() instanceof IPackage && !this.containsPackage(iTreeItem)) {
                        this.packages.add(iTreeItem);
                    }
                    this.loadDataElement(iTreeItem2);
                }
            } else if (iTreeItem.getData().getModelElement() instanceof IPackage && !this.containsPackage(iTreeItem)) {
                this.packages.add(iTreeItem);
            }
        }
    }

    private boolean containsPackage(ITreeItem iTreeItem) {
        for (int i = 0; i < this.packages.size(); ++i) {
            if (!((ITreeItem)this.packages.get(i)).getData().getModelElementXMIID().equals(iTreeItem.getData().getModelElementXMIID())) continue;
            return true;
        }
        return false;
    }

    public void createFileForElement(ITreeItem iTreeItem) {
        if (iTreeItem.getData() == null || iTreeItem.getData().getModelElement() == null) {
            Logger.getLogger(ReportTask.class.getName()).log(Level.WARNING, NbBundle.getMessage(ReportTask.class, (String)"MSG_InvalidItem", (Object)iTreeItem.getPathAsString(), (Object)iTreeItem.getName()));
            return;
        }
        IElement iElement = iTreeItem.getData().getModelElement();
        if (this.elementFileMap.get(iElement.getXMIID()) != null) {
            return;
        }
        if (iElement.getOwningPackage() == null && !(iElement instanceof IProject)) {
            if (!iElement.isClone()) {
                Logger.getLogger(ReportTask.class.getName()).log(Level.WARNING, NbBundle.getMessage(ReportTask.class, (String)"MSG_InvalidPackage", (Object)iElement.getElementType(), (Object)iElement.toString()));
            }
            return;
        }
        ElementDataObject elementDataObject = DataObjectFactory.getDataObject(iElement);
        if (elementDataObject == null) {
            return;
        }
        String string = this.getDirectoryPath(iTreeItem);
        String string2 = ReportTask.convertID(iElement.getXMIID()) + HTML_EXT;
        String string3 = string + File.separator + string2;
        if (elementDataObject.toReport(new File(string3))) {
            this.elementFileMap.put(iElement.getXMIID(), ReportTask.getLinkTo(iElement));
        } else {
            this.success = false;
            ReportTask.log(NbBundle.getMessage(ReportTask.class, (String)"Log_error_creating_file", (Object)iElement.getElementType(), (Object)iElement.toString()));
        }
    }

    public void makePage(String string, String string2) {
        File file = new File(string);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, ENCODING);
            outputStreamWriter.write(string2);
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            this.success = false;
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public static IDiagram loadDiagram(String string) {
        IDiagram iDiagram = ProductHelper.getProductDiagramManager().openDiagram(string, false, null);
        opened.add(iDiagram.getFilename());
        return iDiagram;
    }

    private void copyFiles(String string) {
        int n = 2048;
        String string2 = string;
        InputStream inputStream = null;
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (classLoader != null) {
            if (string.indexOf(".html") > -1 && (inputStream = classLoader.getResourceAsStream(string2 = string.substring(0, string.indexOf(".html")) + "_" + Locale.getDefault() + ".html")) == null) {
                string2 = string.substring(0, string.indexOf(".html")) + "_" + Locale.getDefault().getLanguage() + ".html";
                inputStream = classLoader.getResourceAsStream(string2);
            }
            if (inputStream == null) {
                inputStream = classLoader.getResourceAsStream(string);
            }
            String string3 = string.substring(string.lastIndexOf("/") + 1);
            byte[] byArray = new byte[n];
            int n2 = 0;
            try {
                String string4 = this.getReportDir();
                File file = new File(string4, string3);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                while ((n2 = inputStream.read(byArray, 0, n)) != -1) {
                    fileOutputStream.write(byArray, 0, n2);
                }
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                this.success = false;
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    private void copyImages() {
        File file = new File(this.getReportDir() + File.separator + "images");
        String string = file.getAbsolutePath() + File.separatorChar;
        file = null;
        IConfigManager iConfigManager = ProductHelper.getConfigManager();
        if (iConfigManager != null) {
            String string2 = iConfigManager.getDefaultConfigLocation();
            string2 = string2 + File.separator + "WebReportSupport" + File.separator + "images" + File.separatorChar;
            for (String string3 : imageFilenames) {
                File file2 = new File(string2 + File.separatorChar + string3);
                if (file2 == null) continue;
                UMLXMLManip.copyFile((String)file2.getAbsolutePath(), (String)(string + file2.getName()));
            }
        }
    }

    public static void addToImageList(String string) {
        if (!imageFilenames.contains(string)) {
            imageFilenames.add(string);
        }
    }

    public String getDirectoryPath(ITreeItem iTreeItem) {
        File file;
        Object object;
        String string = "";
        IPackage iPackage = null;
        if (iTreeItem.getData().isDiagram()) {
            IDiagram iDiagram = iTreeItem.getData().getDiagram().getDiagram();
            if (iDiagram == null) {
                iDiagram = ReportTask.loadDiagram(iTreeItem.getData().getDiagram().getFilename());
            }
            iPackage = iDiagram.getOwningPackage();
        } else {
            object = iTreeItem.getData().getModelElement();
            if (object != null) {
                iPackage = object.getOwningPackage();
            }
        }
        if (iPackage != null) {
            string = iPackage.getFullyQualifiedName(true);
        }
        object = this.getReportDir();
        if (string.indexOf("::") > 0) {
            string = string.replace("::", File.separator);
        }
        if (!(file = new File(string = string.trim().length() > 0 ? (String)object + File.separator + string : object)).exists()) {
            file.mkdirs();
        }
        return string;
    }

    public static String getLinkPathToDiagram(IProxyDiagram iProxyDiagram) {
        String string = "";
        IPackage iPackage = null;
        IDiagram iDiagram = iProxyDiagram.getDiagram();
        if (iDiagram == null) {
            iDiagram = ReportTask.loadDiagram(iProxyDiagram.getFilename());
        }
        if (iDiagram != null) {
            iPackage = iDiagram.getOwningPackage();
        }
        if (iPackage != null) {
            string = iPackage.getFullyQualifiedName(true);
        }
        if (string.indexOf("::") > 0) {
            string = string.replace("::", "/");
        }
        return string + "/" + StringUtilities.getFileName((String)iProxyDiagram.getFilename()) + HTML_EXT;
    }

    public static String getLinkTo(IElement iElement) {
        String string = "";
        IPackage iPackage = null;
        if (iElement == null) {
            return "";
        }
        iPackage = iElement.getOwningPackage();
        if (iPackage == null) {
            return ReportTask.convertID(iElement.getXMIID()) + HTML_EXT;
        }
        if (iPackage != null) {
            string = iPackage.getFullyQualifiedName(true);
        }
        if (string.indexOf("::") > 0) {
            string = string.replace("::", "/");
        }
        return string + "/" + ReportTask.convertID(iElement.getXMIID()) + HTML_EXT;
    }

    public static String convertID(String string) {
        if (string != null && string.length() > 0) {
            String string2 = StringUtilities.replaceAllSubstrings((String)string, (String)".", (String)"");
            return StringUtilities.replaceAllSubstrings((String)string2, (String)"-", (String)"");
        }
        return "";
    }

    public String getJavaScriptPath(IDiagram iDiagram) {
        String string = "..";
        IPackage iPackage = iDiagram.getOwningPackage();
        while (!iPackage.equals(iPackage.getProject())) {
            string = string + "/..";
            iPackage = iPackage.getOwningPackage();
        }
        return string;
    }

    public static String getPathToReportRoot(IElement iElement) {
        if (iElement instanceof IAssociationEnd) {
            return ReportTask.getPathToReportRoot((IElement)((IAssociationEnd)iElement).getAssociation());
        }
        String string = "..";
        IPackage iPackage = iElement.getOwningPackage();
        if (iPackage == null) {
            return "";
        }
        while (!iPackage.equals(iPackage.getProject())) {
            string = string + "/..";
            iPackage = iPackage.getOwningPackage();
        }
        return string + "/";
    }

    public void processSummaryPages() {
        int n;
        String string;
        String string2;
        ITreeItem[] iTreeItemArray;
        String string3 = this.m_CurrentProject.getName();
        String string4 = this.m_CurrentProject.getDocumentation();
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = "";
        ReportTask.log(NbBundle.getMessage(ReportTask.class, (String)"Log_generating_summary_files"));
        stringBuilder = ReportTask.readTemplate("org/netbeans/modules/uml/reporting/templates/alldiagrams.html");
        String string6 = stringBuilder.toString();
        string6 = string6.replaceAll("%ALL_DIAGRAMS%", NbBundle.getMessage(ElementDataObject.class, (String)"Category_AllDiagrams"));
        stringBuilder = new StringBuilder();
        ITreeDiagram[] iTreeDiagramArray = new ITreeDiagram[this.diagrams.size()];
        this.diagrams.toArray(iTreeDiagramArray);
        Arrays.sort(iTreeDiagramArray, this.comparator);
        for (int i = 0; i < iTreeDiagramArray.length; ++i) {
            iTreeItemArray = iTreeDiagramArray[i];
            string2 = iTreeItemArray.getDiagram().getDiagram().getName();
            string = this.diagramFileMap.get(iTreeItemArray.getDiagram().getXMIID());
            String string7 = ImageUtil.instance().getDiagramTypeImageName(iTreeItemArray.getDiagram().getDiagram().getDiagramKind());
            ReportTask.addToImageList(string7);
            stringBuilder.append("<img src=\"images/" + string7 + "\" border=n>&nbsp;<A HREF=\"" + string + "\" target=\"elementframe\">" + string2 + "</A>\n<BR>\n");
        }
        String string8 = stringBuilder.toString();
        string6 = string6.replace("%DIAGRAM_CONTENT%", string8);
        string6 = string6.replaceAll("%CHARSET%", ENCODING);
        string5 = this.getReportDir() + File.separator + "alldiagrams.html";
        this.makePage(string5, string6.toString());
        stringBuilder = ReportTask.readTemplate("org/netbeans/modules/uml/reporting/templates/allelements.html");
        string6 = stringBuilder.toString();
        string6 = string6.replaceAll("%ALL_ELEMENTS%", NbBundle.getMessage(ElementDataObject.class, (String)"Category_AllElements"));
        string6 = string6.replaceAll("%CHARSET%", ENCODING);
        stringBuilder = new StringBuilder();
        iTreeItemArray = new ITreeItem[this.elements.size()];
        this.elements.values().toArray(iTreeItemArray);
        Arrays.sort(iTreeItemArray, this.comparator);
        for (int i = 0; i < iTreeItemArray.length; ++i) {
            if (iTreeItemArray[i] instanceof ITreeFolder) continue;
            IElement iElement = iTreeItemArray[i].getData().getModelElement();
            string2 = iTreeItemArray[i].getName();
            if (!this.elementFileMap.containsKey(iElement.getXMIID())) continue;
            string = this.elementFileMap.get(iElement.getXMIID());
            stringBuilder.append("<A HREF=\"" + string + "\" target=\"elementframe\">" + string2 + "</A>\n<BR>\n");
        }
        string6 = string6.replace("%ELEMENT_CONTENT%", stringBuilder.toString());
        string5 = this.getReportDir() + File.separator + "allelements.html";
        this.makePage(string5, string6);
        stringBuilder = ReportTask.readTemplate("org/netbeans/modules/uml/reporting/templates/overview.html");
        string6 = stringBuilder.toString();
        string6 = string6.replace("%PROJECT_NAME%", this.m_CurrentProject.getName());
        string6 = string6.replaceAll("%OVERVIEW%", NbBundle.getMessage(ElementDataObject.class, (String)"Header_Overview"));
        string6 = string6.replaceAll("%ALL_ELEMENTS%", NbBundle.getMessage(ElementDataObject.class, (String)"Category_AllElements"));
        string6 = string6.replaceAll("%ALL_DIAGRAMS%", NbBundle.getMessage(ElementDataObject.class, (String)"Category_AllDiagrams"));
        string6 = string6.replaceAll("%PACKAGES%", NbBundle.getMessage(ElementDataObject.class, (String)"Category_Package"));
        string6 = string6.replaceAll("%CHARSET%", ENCODING);
        StringBuilder stringBuilder2 = new StringBuilder();
        iTreeItemArray = new ITreeItem[this.packages.size()];
        this.packages.toArray(iTreeItemArray);
        Arrays.sort(iTreeItemArray, this.comparator);
        for (n = 0; n < iTreeItemArray.length; ++n) {
            string = this.elementFileMap.get(iTreeItemArray[n].getData().getModelElement().getXMIID());
            if (string == null) continue;
            string2 = ((IPackage)iTreeItemArray[n].getData().getModelElement()).getFullyQualifiedName(false);
            if (iTreeItemArray[n].getData().getModelElement() instanceof IProject) {
                string2 = "&lt;" + NbBundle.getMessage(ReportTask.class, (String)"default_package") + ">";
            }
            string = string.substring(0, string.indexOf(HTML_EXT)) + FRAME + HTML_EXT;
            stringBuilder2.append("<FONT CLASS=\"FrameItemFont\"><A HREF=\"" + string + "\"target=\"packageFrame\">" + string2 + "</A></FONT><BR>\n");
        }
        string6 = string6.replace("%PACKAGE_CONTENT%", stringBuilder2.toString());
        string5 = this.getReportDir() + File.separator + OVERVIEW_FILE;
        this.makePage(string5, string6);
        stringBuilder = ReportTask.readTemplate("org/netbeans/modules/uml/reporting/templates/overview-summary.html");
        string6 = stringBuilder.toString();
        string6 = string6.replace("%PROJECT_NAME%", string3);
        string6 = string6.replace("%PROJECT_DESCRIPTION%", string4);
        string6 = string6.replaceAll("%OVERVIEW%", NbBundle.getMessage(ElementDataObject.class, (String)"Header_Overview"));
        string6 = string6.replaceAll("%PACKAGE%", NbBundle.getMessage(ElementDataObject.class, (String)"Header_Package"));
        string6 = string6.replaceAll("%ELEMENT%", NbBundle.getMessage(ElementDataObject.class, (String)"Header_Element"));
        string6 = string6.replaceAll("%DIAGRAM%", NbBundle.getMessage(ElementDataObject.class, (String)"Header_Diagram"));
        string6 = string6.replaceAll("%HELP%", NbBundle.getMessage(ElementDataObject.class, (String)"Header_Help"));
        string6 = string6.replaceAll("%CHARSET%", ENCODING);
        stringBuilder2 = new StringBuilder();
        if (this.packages.size() > 0) {
            stringBuilder2.append("<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\" SUMMARY=\"\">\n");
            stringBuilder2.append("<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n");
            stringBuilder2.append("<TH ALIGN=\"left\" COLSPAN=\"2\"><FONT SIZE=\"+2\">\n");
            stringBuilder2.append("<B>" + string3 + " " + NbBundle.getMessage(ReportTask.class, (String)"packages") + "</B></FONT></TH>\n");
            stringBuilder2.append("</TR>\n");
            for (n = 0; n < iTreeItemArray.length; ++n) {
                string = this.elementFileMap.get(iTreeItemArray[n].getData().getModelElement().getXMIID());
                if (string == null) continue;
                IPackage iPackage = (IPackage)iTreeItemArray[n].getData().getModelElement();
                string2 = iPackage.getFullyQualifiedName(false);
                if (iPackage instanceof IProject) {
                    string2 = "&lt;" + NbBundle.getMessage(ReportTask.class, (String)"default_package") + ">";
                }
                string = this.elementFileMap.get(iPackage.getXMIID());
                String string9 = iPackage.getDocumentation();
                if (string9 == null || string9.trim().equals("")) {
                    string9 = "&nbsp;";
                }
                stringBuilder2.append("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\n");
                stringBuilder2.append("<TD WIDTH=\"20%\"><B><A HREF=\"" + string + "\">" + string2 + "</A></B></TD>\n");
                stringBuilder2.append("<TD>" + string9 + "</TD>\n");
                stringBuilder2.append("</TR>\n");
            }
            stringBuilder2.append("</TABLE>\n");
        }
        string6 = string6.replace("%PACKAGE_TABLE%", stringBuilder2.toString());
        string5 = this.getReportDir() + File.separator + "overview-summary.html";
        this.makePage(string5, string6);
    }

    public static StringBuilder readTemplate(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = string;
        ClassLoader classLoader = ReportTask.class.getClassLoader();
        InputStream inputStream = null;
        if (classLoader != null) {
            if (string.indexOf(".html") > -1 && (inputStream = classLoader.getResourceAsStream(string2 = string.substring(0, string.indexOf(".html")) + "_" + Locale.getDefault() + ".html")) == null) {
                string2 = string.substring(0, string.indexOf(".html")) + "_" + Locale.getDefault().getLanguage() + ".html";
                inputStream = classLoader.getResourceAsStream(string2);
            }
            if (inputStream == null) {
                inputStream = classLoader.getResourceAsStream(string);
            }
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                int n = 1000;
                char[] cArray = new char[n];
                Object var8_9 = null;
                while (bufferedReader.read(cArray, 0, n) != -1) {
                    stringBuilder.append(cArray);
                    cArray = new char[n];
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        return stringBuilder;
    }

    public static void log(String string) {
        OutputWriter outputWriter = inputOutput.getOut();
        outputWriter.println(string);
        outputWriter.flush();
    }

    private void initLog() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent("output");
        topComponent.open();
        topComponent.requestActive();
        topComponent.toFront();
        try {
            inputOutput.getOut().reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        inputOutput.select();
        inputOutput.setOutputVisible(true);
    }

    public void launchReport() {
        this.copyImages();
        String string = this.getReportDir();
        String string2 = string + File.separator + "index.html";
        File file = new File(string2);
        try {
            IProxyUserInterface iProxyUserInterface = ProductHelper.getProxyUserInterface();
            if (iProxyUserInterface != null && file.exists()) {
                iProxyUserInterface.displayInBrowser(file.toURI().toURL());
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().log(iOException.getMessage());
        }
    }

    static {
        imageFilenames.add("zoom-in.png");
        imageFilenames.add("zoom-out.png");
        imageFilenames.add("fit-to-window.png");
        imageFilenames.add("diagrams-root-node.png");
        imageFilenames.add("package.png");
        imageFilenames.add("checked.png");
        imageFilenames.add("unchecked.png");
        imageFilenames.add("inherit.gif");
    }

    private static class DisplayNameComparator
    implements Comparator {
        private Comparator COLLATOR = Collator.getInstance();

        private DisplayNameComparator() {
        }

        public int compare(Object object, Object object2) {
            if (!(object instanceof ITreeItem)) {
                return 1;
            }
            if (!(object2 instanceof ITreeItem)) {
                return -1;
            }
            ITreeItem iTreeItem = (ITreeItem)object;
            ITreeItem iTreeItem2 = (ITreeItem)object2;
            if (iTreeItem.getData().getModelElement() instanceof IProject) {
                return -1;
            }
            if (iTreeItem.getData().getModelElement() instanceof IPackage && iTreeItem2.getData().getModelElement() instanceof IPackage) {
                return this.COLLATOR.compare(((IPackage)iTreeItem.getData().getModelElement()).getFullyQualifiedName(false), ((IPackage)iTreeItem2.getData().getModelElement()).getFullyQualifiedName(false));
            }
            return this.COLLATOR.compare(iTreeItem.getName(), iTreeItem2.getName());
        }
    }
}

