/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.Parser;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.Severity;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.netbeans.modules.gsf.api.annotations.NonNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParserResult {
    protected final ParserFile file;
    private List<Error> errors;
    private Parser parser;
    protected TranslatedSource translatedSource;
    private String mimeType;
    private CompilationInfo info;

    public ParserResult(Parser parser, ParserFile parserFile, String string) {
        this.parser = parser;
        this.file = parserFile;
        this.mimeType = string;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Parser getParser() {
        return this.parser;
    }

    public void setTranslatedSource(TranslatedSource translatedSource) {
        this.translatedSource = translatedSource;
    }

    public TranslatedSource getTranslatedSource() {
        return this.translatedSource;
    }

    public List<Error> getDiagnostics() {
        if (this.errors == null) {
            return Collections.emptyList();
        }
        ArrayList<Error> arrayList = new ArrayList<Error>(this.errors.size());
        for (Error error : this.errors) {
            assert (this.file.getFileObject() == error.getFile());
            arrayList.add(error);
        }
        return arrayList;
    }

    public boolean hasErrors() {
        if (this.errors == null) {
            return false;
        }
        for (Error error : this.errors) {
            if (error.getSeverity() != Severity.ERROR) continue;
            return true;
        }
        return false;
    }

    public void addError(@NonNull Error error) {
        if (this.errors == null) {
            this.errors = new ArrayList<Error>();
        }
        this.errors.add(error);
    }

    public abstract AstTreeNode getAst();

    public ParserFile getFile() {
        return this.file;
    }

    public CompilationInfo getInfo() {
        return this.info;
    }

    public void setInfo(CompilationInfo compilationInfo) {
        this.info = compilationInfo;
    }

    public static interface AstTreeNode
    extends TreeNode {
        public Object getAstNode();

        public int getStartOffset();

        public int getEndOffset();
    }
}

