/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.uri.rules;

import com.sun.ws.rest.api.core.HttpRequestContext;
import com.sun.ws.rest.api.core.HttpResponseContext;
import com.sun.ws.rest.spi.uri.rules.UriRule;
import com.sun.ws.rest.spi.uri.rules.UriRuleContext;
import java.net.URI;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RightHandPathRule
implements UriRule {
    private final boolean redirect;
    private final boolean patternEndsInSlash;
    private final UriRule rule;

    public RightHandPathRule(boolean redirect, boolean patternEndsInSlash, UriRule rule) {
        assert (rule != null);
        this.redirect = redirect;
        this.patternEndsInSlash = patternEndsInSlash;
        this.rule = rule;
    }

    @Override
    public final boolean accept(CharSequence path, Object resource, UriRuleContext context) {
        path = this.getRightHandPath(context.getGroupValues());
        if (path.length() == 0) {
            if (this.patternEndsInSlash) {
                return this.redirect ? this.redirect(context) : false;
            }
        } else if (path.length() == 1) {
            if (!this.patternEndsInSlash) {
                return false;
            }
            path = "";
        }
        return this.rule.accept(path, resource, context);
    }

    private String getRightHandPath(List<String> groupValues) {
        String rhp = !groupValues.isEmpty() ? groupValues.get(groupValues.size() - 1) : "";
        return rhp != null ? rhp : "";
    }

    private boolean redirect(UriRuleContext context) {
        HttpRequestContext request = context.getHttpContext().getHttpRequestContext();
        HttpResponseContext response = context.getHttpContext().getHttpResponseContext();
        response.setResponse(Response.temporaryRedirect((URI)UriBuilder.fromUri((URI)request.getAbsolutePath()).path(new String[]{"/"}).build()).build());
        return true;
    }
}

