/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.template;

import com.sun.ws.rest.api.core.HttpContextAccess;
import com.sun.ws.rest.api.core.ResourceConfig;
import com.sun.ws.rest.api.view.Viewable;
import com.sun.ws.rest.impl.template.ResolvedViewable;
import com.sun.ws.rest.spi.template.TemplateContext;
import com.sun.ws.rest.spi.template.TemplateProcessor;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ViewableMessageBodyWriter
implements MessageBodyWriter<Viewable> {
    @Context
    HttpContextAccess hca;
    @Context
    TemplateContext tc;
    @Context
    ResourceConfig rc;

    public boolean isWriteable(Class<?> type) {
        return Viewable.class.isAssignableFrom(type);
    }

    public void writeTo(Viewable v, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        if (v instanceof ResolvedViewable) {
            ResolvedViewable rv = (ResolvedViewable)v;
            rv.getTemplate().writeTo(v.getTemplateName(), v.getModel(), entityStream);
        } else {
            String absolutePath = this.getAbsolutePath(this.hca.getCurrentResource().getClass(), v.getTemplateName());
            boolean resolved = false;
            for (TemplateProcessor t : this.tc.getTemplateProcessors()) {
                String resolvedPath = t.resolve(absolutePath);
                if (resolvedPath == null) continue;
                resolved = true;
                t.writeTo(resolvedPath, v.getModel(), entityStream);
            }
            if (!resolved) {
                throw new IOException("The template name, " + v.getTemplateName() + ", could not be resolved to the path of a template");
            }
        }
    }

    public long getSize(Viewable t) {
        return -1L;
    }

    private String getAbsolutePath(Class<?> resourceClass, String path) {
        if (path == null || path.length() == 0) {
            path = "index";
        } else if (path.startsWith("/")) {
            return path;
        }
        return this.getAbsolutePath(resourceClass) + '/' + path;
    }

    private String getAbsolutePath(Class<?> resourceClass) {
        return "/" + resourceClass.getName().replace('.', '/').replace('$', '/');
    }
}

