/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.provider.header;

import com.sun.ws.rest.spi.HeaderDelegateProvider;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.CacheControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CacheControlProvider
implements HeaderDelegateProvider<CacheControl> {
    private static Pattern WHITESPACE = Pattern.compile("\\s");

    @Override
    public boolean supports(Class<?> type) {
        return type == CacheControl.class;
    }

    public String toString(CacheControl header) {
        StringBuffer b = new StringBuffer();
        if (header.isPublic()) {
            this.appendWithSeparator(b, "public");
        }
        if (header.isPrivate()) {
            this.appendQuotedWithSeparator(b, "private", this.buildListValue(header.getPrivateFields()));
        }
        if (header.isNoCache()) {
            this.appendQuotedWithSeparator(b, "no-cache", this.buildListValue(header.getNoCacheFields()));
        }
        if (header.isNoStore()) {
            this.appendWithSeparator(b, "no-store");
        }
        if (header.isNoTransform()) {
            this.appendWithSeparator(b, "no-transform");
        }
        if (header.isMustRevalidate()) {
            this.appendWithSeparator(b, "must-revalidate");
        }
        if (header.isProxyRevalidate()) {
            this.appendWithSeparator(b, "proxy-revalidate");
        }
        if (header.getMaxAge() != -1) {
            this.appendWithSeparator(b, "max-age", header.getMaxAge());
        }
        if (header.getSMaxAge() != -1) {
            this.appendWithSeparator(b, "s-maxage", header.getSMaxAge());
        }
        for (Map.Entry e : header.getCacheExtension().entrySet()) {
            this.appendWithSeparator(b, (String)e.getKey(), this.quoteIfWhitespace((String)e.getValue()));
        }
        return b.toString();
    }

    public CacheControl fromString(String header) {
        throw new UnsupportedOperationException();
    }

    private void appendWithSeparator(StringBuffer b, String field) {
        if (b.length() > 0) {
            b.append(", ");
        }
        b.append(field);
    }

    private void appendQuotedWithSeparator(StringBuffer b, String field, String value) {
        this.appendWithSeparator(b, field);
        if (value != null && value.length() > 0) {
            b.append("=\"");
            b.append(value);
            b.append("\"");
        }
    }

    private void appendWithSeparator(StringBuffer b, String field, String value) {
        this.appendWithSeparator(b, field);
        if (value != null && value.length() > 0) {
            b.append("=");
            b.append(value);
        }
    }

    private void appendWithSeparator(StringBuffer b, String field, int value) {
        this.appendWithSeparator(b, field);
        b.append("=");
        b.append(value);
    }

    private String buildListValue(List<String> values) {
        StringBuffer b = new StringBuffer();
        for (String value : values) {
            this.appendWithSeparator(b, value);
        }
        return b.toString();
    }

    private String quoteIfWhitespace(String value) {
        if (value == null) {
            return null;
        }
        Matcher m = WHITESPACE.matcher(value);
        if (m.find()) {
            return "\"" + value + "\"";
        }
        return value;
    }
}

