/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.provider.entity;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.atom.Feed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.WireFeedInput;
import com.sun.syndication.io.WireFeedOutput;
import com.sun.ws.rest.impl.ImplMessages;
import com.sun.ws.rest.impl.provider.entity.AbstractTypeEntityProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AtomFeedProvider
extends AbstractTypeEntityProvider<Feed> {
    private static final String FEED_TYPE = "atom_1.0";

    @Override
    public boolean supports(Class type) {
        return type == Feed.class;
    }

    public Feed readFrom(Class<Feed> type, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream entityStream) throws IOException {
        try {
            WireFeedInput input = new WireFeedInput();
            WireFeed wireFeed = input.build((Reader)new InputStreamReader(entityStream));
            if (!(wireFeed instanceof Feed)) {
                throw new IOException(ImplMessages.ERROR_NOT_ATOM_FEED(type));
            }
            return (Feed)wireFeed;
        }
        catch (FeedException cause) {
            IOException effect = new IOException(ImplMessages.ERROR_MARSHALLING_ATOM(type));
            effect.initCause(cause);
            throw effect;
        }
    }

    public void writeTo(Feed t, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream entityStream) throws IOException {
        try {
            t.setFeedType(FEED_TYPE);
            WireFeedOutput wireFeedOutput = new WireFeedOutput();
            Document feedDoc = wireFeedOutput.outputJDom((WireFeed)t);
            XMLOutputter outputter = new XMLOutputter();
            outputter.setFormat(Format.getPrettyFormat());
            outputter.output(feedDoc, entityStream);
        }
        catch (FeedException cause) {
            IOException effect = new IOException(ImplMessages.ERROR_MARSHALLING_ATOM(t.getClass()));
            effect.initCause(cause);
            throw effect;
        }
    }
}

