/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.provider;

import com.sun.ws.rest.impl.ResponseBuilderImpl;
import com.sun.ws.rest.impl.VariantListBuilderImpl;
import com.sun.ws.rest.impl.uri.UriBuilderImpl;
import com.sun.ws.rest.spi.HeaderDelegateProvider;
import com.sun.ws.rest.spi.service.ServiceFinder;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeDelegateImpl
extends RuntimeDelegate {
    private AtomicReference<Set<HeaderDelegateProvider>> atomicHeaderDelegates = new AtomicReference();

    public UriBuilder createUriBuilder() {
        return new UriBuilderImpl();
    }

    public Response.ResponseBuilder createResponseBuilder() {
        return new ResponseBuilderImpl();
    }

    public Variant.VariantListBuilder createVariantListBuilder() {
        return new VariantListBuilderImpl();
    }

    public <T> RuntimeDelegate.HeaderDelegate<T> createHeaderDelegate(Class<T> type) {
        Set<HeaderDelegateProvider> headerDelegates = this.atomicHeaderDelegates.get();
        if (headerDelegates == null) {
            headerDelegates = this.cacheProviderList(this.atomicHeaderDelegates, HeaderDelegateProvider.class);
        }
        for (HeaderDelegateProvider p : headerDelegates) {
            if (!p.supports(type)) continue;
            return p;
        }
        throw new IllegalArgumentException("A header delegate provider for type, " + type + ", is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Set<T> cacheProviderList(AtomicReference<Set<T>> atomicSet, Class<T> c) {
        AtomicReference<Set<T>> atomicReference = atomicSet;
        synchronized (atomicReference) {
            Set<T> s = atomicSet.get();
            if (s == null) {
                s = new HashSet<T>();
                for (T p : ServiceFinder.find(c, true)) {
                    s.add(p);
                }
                atomicSet.set(s);
            }
            return s;
        }
    }
}

