/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.model.parameter;

import com.sun.ws.rest.api.container.ContainerException;
import com.sun.ws.rest.impl.ImplMessages;
import com.sun.ws.rest.impl.model.ReflectionHelper;
import com.sun.ws.rest.impl.model.parameter.MultivaluedDefaultPrimitiveValueOfExtractor;
import com.sun.ws.rest.impl.model.parameter.MultivaluedDefaultStringConstructorExtractor;
import com.sun.ws.rest.impl.model.parameter.MultivaluedDefaultStringConstructorListExtractor;
import com.sun.ws.rest.impl.model.parameter.MultivaluedDefaultStringExtractor;
import com.sun.ws.rest.impl.model.parameter.MultivaluedDefaultStringListExtractor;
import com.sun.ws.rest.impl.model.parameter.MultivaluedDefaultValueOfExtractor;
import com.sun.ws.rest.impl.model.parameter.MultivaluedDefaultValueOfListExtractor;
import com.sun.ws.rest.impl.model.parameter.MultivaluedParameterExtractor;
import com.sun.ws.rest.impl.model.parameter.PrimitiveMapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultivaluedDefaultListParameterProcessor {
    public static MultivaluedParameterExtractor process(Class<?> parameter, Type parameterType, String parameterName) {
        return MultivaluedDefaultListParameterProcessor.process(null, parameter, parameterType, parameterName);
    }

    public static MultivaluedParameterExtractor process(String defaultValue, Class<?> parameter, Type parameterType, String parameterName) {
        if (parameter == List.class) {
            Class c = ReflectionHelper.getGenericClass(parameterType);
            if (c == null || c == String.class) {
                return new MultivaluedDefaultStringListExtractor(parameterName, defaultValue);
            }
            Method valueOf = ReflectionHelper.getValueOfStringMethod(c);
            if (valueOf != null) {
                try {
                    return new MultivaluedDefaultValueOfListExtractor(valueOf, parameterName, defaultValue);
                }
                catch (Exception e) {
                    throw new ContainerException(ImplMessages.DEFAULT_COULD_NOT_PROCESS_METHOD(defaultValue, valueOf));
                }
            }
            Constructor constructor = ReflectionHelper.getStringConstructor(c);
            if (constructor != null) {
                try {
                    return new MultivaluedDefaultStringConstructorListExtractor(constructor, parameterName, defaultValue);
                }
                catch (Exception e) {
                    throw new ContainerException(ImplMessages.DEFAULT_COULD_NOT_PROCESS_CONSTRUCTOR(defaultValue, constructor));
                }
            }
        } else {
            if (parameter == String.class) {
                return new MultivaluedDefaultStringExtractor(parameterName, defaultValue);
            }
            if (parameter.isPrimitive()) {
                if ((parameter = PrimitiveMapper.primitiveToClassMap.get(parameter)) == null) {
                    return null;
                }
                Method valueOf = ReflectionHelper.getValueOfStringMethod(parameter);
                if (valueOf != null) {
                    try {
                        Object defaultDefaultValue = PrimitiveMapper.primitiveToDefaultValueMap.get(parameter);
                        return new MultivaluedDefaultPrimitiveValueOfExtractor(valueOf, parameterName, defaultValue, defaultDefaultValue);
                    }
                    catch (Exception e) {
                        throw new ContainerException(ImplMessages.DEFAULT_COULD_NOT_PROCESS_METHOD(defaultValue, valueOf));
                    }
                }
            } else {
                Method valueOf = ReflectionHelper.getValueOfStringMethod(parameter);
                if (valueOf != null) {
                    try {
                        return new MultivaluedDefaultValueOfExtractor(valueOf, parameterName, defaultValue);
                    }
                    catch (Exception e) {
                        throw new ContainerException(ImplMessages.DEFAULT_COULD_NOT_PROCESS_METHOD(defaultValue, valueOf));
                    }
                }
                Constructor constructor = ReflectionHelper.getStringConstructor(parameter);
                if (constructor != null) {
                    try {
                        return new MultivaluedDefaultStringConstructorExtractor(constructor, parameterName, defaultValue);
                    }
                    catch (Exception e) {
                        throw new ContainerException(ImplMessages.DEFAULT_COULD_NOT_PROCESS_CONSTRUCTOR(defaultValue, constructor));
                    }
                }
            }
        }
        return null;
    }
}

