/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.model.method;

import com.sun.ws.rest.impl.http.header.AcceptableMediaType;
import com.sun.ws.rest.impl.model.MediaTypeHelper;
import com.sun.ws.rest.spi.dispatch.RequestDispatcher;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.core.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceMethod {
    private static final List<String> EMPTY_LIST = Collections.emptyList();
    public static final Comparator<ResourceMethod> COMPARATOR = new Comparator<ResourceMethod>(){

        @Override
        public int compare(ResourceMethod o1, ResourceMethod o2) {
            int i = MediaTypeHelper.MEDIA_TYPE_LIST_COMPARATOR.compare(o1.consumeMime, o2.consumeMime);
            if (i == 0) {
                i = MediaTypeHelper.MEDIA_TYPE_LIST_COMPARATOR.compare(o1.produceMime, o2.produceMime);
            }
            return i;
        }
    };
    private final String httpMethod;
    private final List<String> templateVariables;
    private final List<MediaType> consumeMime;
    private final List<MediaType> produceMime;
    private final RequestDispatcher dispatcher;

    public ResourceMethod(String httpMethod, List<String> templateVariables, List<MediaType> consumeMime, List<MediaType> produceMime, RequestDispatcher dispatcher) {
        this.httpMethod = httpMethod;
        this.templateVariables = templateVariables != null ? templateVariables : EMPTY_LIST;
        this.consumeMime = consumeMime;
        this.produceMime = produceMime;
        this.dispatcher = dispatcher;
    }

    public final String getHttpMethod() {
        return this.httpMethod;
    }

    public final List<String> getTemplateVariables() {
        return this.templateVariables;
    }

    public final List<MediaType> getConsumeMime() {
        return this.produceMime;
    }

    public final List<MediaType> getProduceMime() {
        return this.produceMime;
    }

    public final RequestDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public final boolean consumes(MediaType contentType) {
        for (MediaType c : this.consumeMime) {
            if (c.getType().equals("*")) {
                return true;
            }
            if (!contentType.isCompatible(c)) continue;
            return true;
        }
        return false;
    }

    public final boolean produces(MediaType contentType) {
        for (MediaType c : this.produceMime) {
            if (c.getType().equals("*")) {
                return true;
            }
            if (!c.isCompatible(contentType)) continue;
            return true;
        }
        return false;
    }

    public final int produces(List accept) {
        for (AcceptableMediaType a : accept) {
            if (a.getType().equals("*")) {
                return a.getQuality();
            }
            for (MediaType c : this.produceMime) {
                if (c.getType().equals("*")) {
                    return a.getQuality();
                }
                if (!c.isCompatible((MediaType)a)) continue;
                return a.getQuality();
            }
        }
        return -1;
    }

    public final boolean mediaEquals(ResourceMethod that) {
        boolean v = ((Object)this.consumeMime).equals(that.consumeMime);
        if (!v) {
            return false;
        }
        return ((Object)this.produceMime).equals(that.produceMime);
    }
}

