/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.json;

import com.sun.ws.rest.impl.json.JSONJAXBContext;
import com.sun.ws.rest.impl.json.writer.JsonXmlStreamWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.validation.Schema;
import org.codehaus.jettison.badgerfish.BadgerFishXMLStreamWriter;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.codehaus.jettison.mapped.MappedXMLStreamWriter;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONMarshaller
implements Marshaller {
    private JAXBContext jaxbContext;
    private Marshaller jaxbMarshaller;
    private JSONJAXBContext.JSONNotation jsonNotation;
    private boolean jsonEnabled;
    private boolean jsonRootUnwrapping;
    private Collection<String> arrays;
    private Collection<String> nonStrings;

    public JSONMarshaller(JAXBContext jaxbContext, Map<String, Object> properties) throws JAXBException {
        try {
            this.jaxbContext = jaxbContext;
            this.jaxbMarshaller = jaxbContext.createMarshaller();
            this.setProperties(properties);
        }
        catch (PropertyException ex) {
            Logger.getLogger(JSONMarshaller.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void marshal(Object jaxbObject, Result result) throws JAXBException {
        this.jaxbMarshaller.marshal(jaxbObject, result);
    }

    public void marshal(Object jaxbObject, OutputStream os) throws JAXBException {
        if (this.jsonEnabled) {
            this.jaxbMarshaller.marshal(jaxbObject, this.createXmlStreamWriter(new OutputStreamWriter(os)));
        } else {
            this.jaxbMarshaller.marshal(jaxbObject, os);
        }
    }

    public void marshal(Object jaxbObject, File file) throws JAXBException {
        if (this.jsonEnabled) {
            try {
                this.jaxbMarshaller.marshal(jaxbObject, this.createXmlStreamWriter(new FileWriter(file)));
            }
            catch (IOException ex) {
                Logger.getLogger(JSONMarshaller.class.getName()).log(Level.SEVERE, "IOException caught when marshalling into a file.", ex);
                throw new JAXBException(ex.getMessage(), (Throwable)ex);
            }
        } else {
            this.jaxbMarshaller.marshal(jaxbObject, file);
        }
    }

    public void marshal(Object jaxbObject, Writer writer) throws JAXBException {
        if (this.jsonEnabled) {
            this.jaxbMarshaller.marshal(jaxbObject, this.createXmlStreamWriter(writer));
        } else {
            this.jaxbMarshaller.marshal(jaxbObject, writer);
        }
    }

    public void marshal(Object jaxbObject, ContentHandler handler) throws JAXBException {
        this.jaxbMarshaller.marshal(jaxbObject, handler);
    }

    public void marshal(Object jaxbObject, Node node) throws JAXBException {
        this.jaxbMarshaller.marshal(jaxbObject, node);
    }

    public void marshal(Object jaxbObject, XMLStreamWriter writer) throws JAXBException {
        this.jaxbMarshaller.marshal(jaxbObject, writer);
    }

    public void marshal(Object jaxbObject, XMLEventWriter writer) throws JAXBException {
        this.jaxbMarshaller.marshal(jaxbObject, writer);
    }

    public Node getNode(Object jaxbObject) throws JAXBException {
        return this.jaxbMarshaller.getNode(jaxbObject);
    }

    private void setArrayProperty(Collection<String> arrayProperty, String jsonArrayVal) throws JSONException {
        if (null == jsonArrayVal) {
            return;
        }
        JSONArray arrayVal = new JSONArray(jsonArrayVal);
        for (int i = 0; i < arrayVal.length(); ++i) {
            arrayProperty.add(arrayVal.getString(i));
        }
    }

    public void setProperty(String key, Object value) throws PropertyException {
        if ("com.sun.ws.rest.impl.json.enabled".equals(key)) {
            this.jsonEnabled = (Boolean)value;
        } else if ("com.sun.ws.rest.impl.json.notation".equals(key)) {
            this.jsonNotation = JSONJAXBContext.JSONNotation.valueOf((String)value);
        } else if ("com.sun.ws.rest.impl.json.root.unwrapping".equals(key)) {
            this.jsonRootUnwrapping = (Boolean)value;
        } else if ("com.sun.ws.rest.impl.json.arrays".equals(key)) {
            if (null == this.arrays) {
                this.arrays = new LinkedList<String>();
            }
            try {
                this.setArrayProperty(this.arrays, (String)value);
            }
            catch (JSONException e) {
                throw new PropertyException("JSON exception when trying to set com.sun.ws.rest.impl.json.arrays property.", (Throwable)e);
            }
        } else if ("com.sun.ws.rest.impl.json.non.strings".equals(key)) {
            if (null == this.nonStrings) {
                this.nonStrings = new LinkedList<String>();
            }
            try {
                this.setArrayProperty(this.nonStrings, (String)value);
            }
            catch (JSONException e) {
                throw new PropertyException("JSON exception when trying to set com.sun.ws.rest.impl.json.non.strings property.", (Throwable)e);
            }
        } else {
            this.jaxbMarshaller.setProperty(key, value);
        }
    }

    private String asJsonArray(Collection<String> collection) {
        return null == collection ? "[]" : new JSONArray(collection).toString();
    }

    public Object getProperty(String key) throws PropertyException {
        if ("com.sun.ws.rest.impl.json.enabled".equals(key)) {
            return this.jsonEnabled;
        }
        if ("com.sun.ws.rest.impl.json.notation".equals(key)) {
            return this.jsonNotation.name();
        }
        if ("com.sun.ws.rest.impl.json.root.unwrapping".equals(key)) {
            return this.jsonRootUnwrapping;
        }
        if ("com.sun.ws.rest.impl.json.arrays".equals(key)) {
            return this.asJsonArray(this.arrays);
        }
        if ("com.sun.ws.rest.impl.json.non.strings".equals(key)) {
            return this.asJsonArray(this.nonStrings);
        }
        return this.jaxbMarshaller.getProperty(key);
    }

    public void setEventHandler(ValidationEventHandler handler) throws JAXBException {
        this.jaxbMarshaller.setEventHandler(handler);
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.jaxbMarshaller.getEventHandler();
    }

    public void setAdapter(XmlAdapter adapter) {
        this.jaxbMarshaller.setAdapter(adapter);
    }

    public <A extends XmlAdapter> void setAdapter(Class<A> type, A adapter) {
        this.jaxbMarshaller.setAdapter(type, adapter);
    }

    public <A extends XmlAdapter> A getAdapter(Class<A> type) {
        return (A)this.jaxbMarshaller.getAdapter(type);
    }

    public void setAttachmentMarshaller(AttachmentMarshaller marshaller) {
        this.jaxbMarshaller.setAttachmentMarshaller(marshaller);
    }

    public AttachmentMarshaller getAttachmentMarshaller() {
        return this.jaxbMarshaller.getAttachmentMarshaller();
    }

    public void setSchema(Schema schema) {
        this.jaxbMarshaller.setSchema(schema);
    }

    public Schema getSchema() {
        return this.jaxbMarshaller.getSchema();
    }

    public void setListener(Marshaller.Listener listener) {
        this.jaxbMarshaller.setListener(listener);
    }

    public Marshaller.Listener getListener() {
        return this.jaxbMarshaller.getListener();
    }

    private void setProperties(Map<String, Object> properties) throws PropertyException {
        if (null != properties) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                this.setProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    XMLStreamWriter createXmlStreamWriter(Writer writer) {
        Object xmlStreamWriter = JSONJAXBContext.JSONNotation.MAPPED == this.jsonNotation ? new JsonXmlStreamWriter(writer, this.jsonRootUnwrapping, this.arrays, this.nonStrings) : (JSONJAXBContext.JSONNotation.MAPPED_JETTISON == this.jsonNotation ? new MappedXMLStreamWriter(new MappedNamespaceConvention(new Configuration()), writer) : new BadgerFishXMLStreamWriter(writer));
        return xmlStreamWriter;
    }
}

