/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.http.header;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Cookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CookiesParser {
    CookiesParser() {
    }

    public static Map<String, Cookie> createCookies(String header) {
        String[] bites = header.split("[;,]");
        HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();
        int version = 0;
        MutableCookie cookie = null;
        for (String bite : bites) {
            String value;
            String[] crumbs = bite.split("=", 2);
            String name = crumbs.length > 0 ? crumbs[0].trim() : "";
            String string = value = crumbs.length > 1 ? crumbs[1].trim() : "";
            if (value.startsWith("\"") && value.endsWith("\"") && value.length() > 1) {
                value = value.substring(1, value.length() - 1);
            }
            if (!name.startsWith("$")) {
                if (cookie != null) {
                    cookies.put(cookie.getName(), cookie.getImmutableCookie());
                }
                cookie = new MutableCookie(name, value);
                cookie.setVersion(version);
                continue;
            }
            if (name.startsWith("$Version")) {
                version = Integer.parseInt(value);
                continue;
            }
            if (name.startsWith("$Path") && cookie != null) {
                cookie.setPath(value);
                continue;
            }
            if (!name.startsWith("$Domain") || cookie == null) continue;
            cookie.setDomain(value);
        }
        if (cookie != null) {
            cookies.put(cookie.getName(), cookie.getImmutableCookie());
        }
        return cookies;
    }

    private static class MutableCookie {
        private String name;
        private String value;
        private int version = -1;
        private String path = null;
        private String domain = null;

        public MutableCookie(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public Cookie getImmutableCookie() {
            return new Cookie(this.name, this.value, this.path, this.domain, this.version);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }
    }
}

