/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.container.servlet;

import com.sun.ws.rest.api.container.ContainerException;
import com.sun.ws.rest.api.core.ResourceConfig;
import com.sun.ws.rest.impl.container.servlet.ThreadLocalNamedInvoker;
import com.sun.ws.rest.spi.container.WebApplication;
import com.sun.ws.rest.spi.container.servlet.ServletContainer;
import com.sun.ws.rest.spi.resource.Injectable;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import javax.servlet.ServletConfig;

public class ServletAdaptor
extends ServletContainer {
    private Map<String, String> persistenceUnits = new HashMap<String, String>();

    protected void configure(ServletConfig servletConfig, ResourceConfig rc, WebApplication wa) {
        super.configure(servletConfig, rc, wa);
        Enumeration e = servletConfig.getInitParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = servletConfig.getInitParameter(key);
            if (!key.startsWith("unit:")) continue;
            this.persistenceUnits.put(key.substring(5), "java:comp/env/" + value);
        }
        wa.addInjectable((Type)((Object)EntityManagerFactory.class), new Injectable<PersistenceUnit, EntityManagerFactory>(){

            @Override
            public Class<PersistenceUnit> getAnnotationClass() {
                return PersistenceUnit.class;
            }

            @Override
            public EntityManagerFactory getInjectableValue(PersistenceUnit pu) {
                if (!ServletAdaptor.this.persistenceUnits.containsKey(pu.unitName())) {
                    throw new ContainerException("Persistence unit '" + pu.unitName() + "' is not configured as a servlet parameter in web.xml");
                }
                String jndiName = (String)ServletAdaptor.this.persistenceUnits.get(pu.unitName());
                ThreadLocalNamedInvoker emfHandler = new ThreadLocalNamedInvoker(jndiName);
                EntityManagerFactory emf = (EntityManagerFactory)Proxy.newProxyInstance(EntityManagerFactory.class.getClassLoader(), new Class[]{EntityManagerFactory.class}, emfHandler);
                return emf;
            }
        });
    }
}

