/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.container.servlet;

import com.sun.ws.rest.api.container.ContainerException;
import com.sun.ws.rest.impl.container.servlet.HttpRequestAdaptor;
import com.sun.ws.rest.impl.container.servlet.RequestDispatcherWrapper;
import com.sun.ws.rest.spi.container.AbstractContainerResponse;
import com.sun.ws.rest.spi.container.MessageBodyContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MultivaluedMap;

public final class HttpResponseAdaptor
extends AbstractContainerResponse {
    private final ServletContext context;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private RequestDispatcher d;
    private OutputStream out;

    public HttpResponseAdaptor(ServletContext context, HttpServletResponse response, HttpServletRequest request, MessageBodyContext bodyContext, HttpRequestAdaptor requestContext) {
        super(bodyContext, requestContext);
        this.context = context;
        this.response = response;
        this.request = request;
    }

    protected OutputStream getUnderlyingOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new OutputStreamAdapter();
        }
        return this.out;
    }

    protected void commitStatusAndHeaders() throws IOException {
        this.response.setStatus(this.getStatus());
        MultivaluedMap<String, Object> headers = this.getHttpHeaders();
        for (Map.Entry e : headers.entrySet()) {
            for (Object v : (List)e.getValue()) {
                this.response.addHeader((String)e.getKey(), this.getHeaderValue(v));
            }
        }
    }

    public void commitAll() throws IOException {
        if (this.isCommitted()) {
            return;
        }
        if (this.response.isCommitted()) {
            return;
        }
        this.commitStatusAndHeaders();
        this.writeEntity(this.getUnderlyingOutputStream());
    }

    public RequestDispatcher getRequestDispatcher() {
        return this.d;
    }

    void forwardTo(String path, Object it) {
        this.d = this.context.getRequestDispatcher(path);
        if (this.d == null) {
            throw new ContainerException("No request dispatcher for: " + path);
        }
        this.d = new RequestDispatcherWrapper(this.d, it);
    }

    final class OutputStreamAdapter
    extends OutputStream {
        OutputStream out;

        OutputStreamAdapter() {
        }

        public void write(int b) throws IOException {
            this.initiate();
            this.out.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.initiate();
            this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.initiate();
            this.out.write(b, off, len);
        }

        public void flush() throws IOException {
            this.initiate();
            this.out.flush();
        }

        public void close() throws IOException {
            this.initiate();
            this.out.close();
        }

        void initiate() throws IOException {
            if (this.out == null) {
                this.out = HttpResponseAdaptor.this.response.getOutputStream();
            }
        }
    }
}

