/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.container.jaxws;

import com.sun.ws.rest.impl.container.jaxws.MessageContextRequestAdaptor;
import com.sun.ws.rest.spi.container.AbstractContainerResponse;
import com.sun.ws.rest.spi.container.MessageBodyContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.ws.handler.MessageContext;

public final class MessageContextResponseAdaptor
extends AbstractContainerResponse {
    private final HttpServletResponse response;
    private final MessageContext context;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();

    MessageContextResponseAdaptor(MessageContext context, MessageBodyContext bodyContext, MessageContextRequestAdaptor requestContext) {
        super(bodyContext, requestContext);
        this.context = context;
        this.response = (HttpServletResponse)context.get((Object)"javax.xml.ws.servlet.response");
    }

    DataSource getResultDataSource() throws IOException {
        if (!this.isCommitted()) {
            this.commitStatusAndHeaders();
        }
        return new HttpResponseDataSource();
    }

    protected OutputStream getUnderlyingOutputStream() throws IOException {
        return this.out;
    }

    protected void commitStatusAndHeaders() throws IOException {
        if (this.response != null) {
            this.response.setStatus(this.getStatus());
            MultivaluedMap<String, Object> headers = this.getHttpHeaders();
            for (Map.Entry e : headers.entrySet()) {
                for (Object v : (List)e.getValue()) {
                    this.response.addHeader((String)e.getKey(), this.getHeaderValue(v));
                }
            }
        } else {
            HashMap map = new HashMap();
            MultivaluedMap<String, Object> headers = this.getHttpHeaders();
            for (Map.Entry e : headers.entrySet()) {
                ArrayList<String> values = new ArrayList<String>();
                for (Object v : (List)e.getValue()) {
                    values.add(this.getHeaderValue(v));
                }
                map.put(e.getKey(), values);
            }
            this.context.put((Object)"javax.xml.ws.http.response.code", (Object)this.getStatus());
            this.context.put((Object)"javax.xml.ws.http.response.headers", map);
        }
    }

    private final class HttpResponseDataSource
    implements DataSource {
        private final String mediaType;

        public HttpResponseDataSource() {
            this.mediaType = MessageContextResponseAdaptor.this.getHeaderValue(MessageContextResponseAdaptor.this.getHttpHeaders().getFirst((Object)"Content-Type"));
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            return this.getClass().toString();
        }

        public InputStream getInputStream() throws IOException {
            MessageContextResponseAdaptor.this.writeEntity(MessageContextResponseAdaptor.this.out);
            return new ByteArrayInputStream(MessageContextResponseAdaptor.this.out.toByteArray());
        }

        public String getContentType() {
            return this.mediaType;
        }
    }
}

