/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css;

import org.apache.batik.css.AbstractStyleSheet;
import org.apache.batik.css.CSSDocumentHandler;
import org.apache.batik.css.CSSOMRuleList;
import org.apache.batik.css.CSSOMStyleRule;
import org.apache.batik.css.CSSRuleListOwner;
import org.apache.batik.css.event.CSSPropertyChangeEvent;
import org.apache.batik.css.event.CSSStyleDeclarationChangeEvent;
import org.apache.batik.css.event.CSSStyleRuleChangeEvent;
import org.apache.batik.css.event.CSSStyleRuleChangeListener;
import org.apache.batik.css.event.CSSStyleSheetChangeListener;
import org.apache.batik.css.event.CSSStyleSheetChangeSupport;
import org.apache.batik.css.event.SelectorListChangeEvent;
import org.apache.batik.css.value.ValueFactoryMap;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;
import org.w3c.dom.stylesheets.StyleSheet;

public class CSSOMStyleSheet
extends AbstractStyleSheet
implements CSSStyleSheet,
CSSRuleListOwner,
CSSStyleRuleChangeListener {
    protected CSSOMRuleList cssRules = new CSSOMRuleList();
    protected Parser parser;
    protected ValueFactoryMap factories;
    protected CSSRule ownerRule;
    protected CSSStyleSheetChangeSupport styleSheetChangeSupport;

    public CSSOMStyleSheet(Node node, StyleSheet styleSheet, String string, String string2, MediaList mediaList, CSSRule cSSRule, ValueFactoryMap valueFactoryMap, Parser parser) {
        super(node, styleSheet, string, string2, mediaList);
        this.ownerRule = cSSRule;
        this.factories = valueFactoryMap;
        this.parser = parser;
    }

    public Parser getParser() {
        return this.parser;
    }

    public ValueFactoryMap getValueFactoryMap() {
        return this.factories;
    }

    public String getType() {
        return "text/css";
    }

    public CSSRule getOwnerRule() {
        return this.ownerRule;
    }

    public CSSRuleList getCssRules() {
        return this.cssRules;
    }

    public void appendRules(String string) {
        CSSDocumentHandler.parseRules(this, string);
    }

    public int insertRule(String string, int n) throws DOMException {
        CSSRule cSSRule = CSSDocumentHandler.parseRule(this, string);
        if (cSSRule != null) {
            this.cssRules.insert(cSSRule, n);
            this.cssRuleAdded(cSSRule);
        }
        return n;
    }

    public void deleteRule(int n) throws DOMException {
        CSSRule cSSRule = this.cssRules.delete(n);
        switch (cSSRule.getType()) {
            case 1: {
                ((CSSOMStyleRule)cSSRule).removeCSSStyleRuleChangeListener(this);
            }
        }
        if (this.styleSheetChangeSupport != null) {
            this.styleSheetChangeSupport.fireCSSRuleRemoved(cSSRule);
        }
    }

    public void appendRule(CSSRule cSSRule) {
        this.cssRules.append(cSSRule);
        this.cssRuleAdded(cSSRule);
    }

    protected void cssRuleAdded(CSSRule cSSRule) {
        switch (cSSRule.getType()) {
            case 1: {
                ((CSSOMStyleRule)cSSRule).addCSSStyleRuleChangeListener(this);
            }
        }
        if (this.styleSheetChangeSupport != null) {
            this.styleSheetChangeSupport.fireCSSRuleAdded(cSSRule);
        }
    }

    public void addCSSStyleSheetChangeListener(CSSStyleSheetChangeListener cSSStyleSheetChangeListener) {
        if (this.styleSheetChangeSupport == null) {
            this.styleSheetChangeSupport = new CSSStyleSheetChangeSupport(this);
        }
        this.styleSheetChangeSupport.addCSSStyleSheetChangeListener(cSSStyleSheetChangeListener);
    }

    public void removeCSSStyleSheetChangeListener(CSSStyleSheetChangeListener cSSStyleSheetChangeListener) {
        if (this.styleSheetChangeSupport == null) {
            return;
        }
        this.styleSheetChangeSupport.removeCSSStyleSheetChangeListener(cSSStyleSheetChangeListener);
    }

    public void cssStyleRuleChangeStart(CSSStyleRuleChangeEvent cSSStyleRuleChangeEvent) {
        if (this.styleSheetChangeSupport != null) {
            this.styleSheetChangeSupport.fireCSSStyleRuleChangeStart(cSSStyleRuleChangeEvent);
        }
    }

    public void cssStyleRuleChangeCancel(CSSStyleRuleChangeEvent cSSStyleRuleChangeEvent) {
        if (this.styleSheetChangeSupport != null) {
            this.styleSheetChangeSupport.fireCSSStyleRuleChangeCancel(cSSStyleRuleChangeEvent);
        }
    }

    public void cssStyleRuleChangeEnd(CSSStyleRuleChangeEvent cSSStyleRuleChangeEvent) {
        if (this.styleSheetChangeSupport != null) {
            this.styleSheetChangeSupport.fireCSSStyleRuleChangeEnd(cSSStyleRuleChangeEvent);
        }
    }

    public void selectorListChange(SelectorListChangeEvent selectorListChangeEvent) {
        if (this.styleSheetChangeSupport != null) {
            this.styleSheetChangeSupport.fireSelectorListChange(selectorListChangeEvent);
        }
    }

    public void cssStyleDeclarationChangeStart(CSSStyleDeclarationChangeEvent cSSStyleDeclarationChangeEvent) {
        if (this.styleSheetChangeSupport != null) {
            this.styleSheetChangeSupport.fireCSSStyleDeclarationChangeStart(cSSStyleDeclarationChangeEvent);
        }
    }

    public void cssStyleDeclarationChangeCancel(CSSStyleDeclarationChangeEvent cSSStyleDeclarationChangeEvent) {
        if (this.styleSheetChangeSupport != null) {
            this.styleSheetChangeSupport.fireCSSStyleDeclarationChangeCancel(cSSStyleDeclarationChangeEvent);
        }
    }

    public void cssStyleDeclarationChangeEnd(CSSStyleDeclarationChangeEvent cSSStyleDeclarationChangeEvent) {
        if (this.styleSheetChangeSupport != null) {
            this.styleSheetChangeSupport.fireCSSStyleDeclarationChangeEnd(cSSStyleDeclarationChangeEvent);
        }
    }

    public void cssPropertyChange(CSSPropertyChangeEvent cSSPropertyChangeEvent) {
        if (this.styleSheetChangeSupport != null) {
            this.styleSheetChangeSupport.fireCSSPropertyChange(cSSPropertyChangeEvent);
        }
    }
}

