/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.faces.dt.binding;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignProject;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.faces.FacesDesignContext;
import com.sun.rave.designtime.faces.FacesDesignProject;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.faces.component.UIData;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.visualweb.faces.dt.binding.BindingCallback;
import org.netbeans.modules.visualweb.faces.dt.binding.BindingTargetNode;
import org.netbeans.modules.visualweb.faces.dt.binding.MapTargetNodeFactory;
import org.netbeans.modules.visualweb.faces.dt.binding.ResultSetTargetNodeFactory;
import org.netbeans.modules.visualweb.faces.dt.util.ComponentBundle;

public class TargetPanel
extends JPanel {
    JLabel targetLabel = new JLabel();
    JScrollPane targetScroll = new JScrollPane();
    JTree tree = new JTree();
    BindingTargetNode.RootTargetNode rootNode = new BindingTargetNode.RootTargetNode();
    DefaultTreeModel treeModel = new DefaultTreeModel(this.rootNode);
    DefaultTreeSelectionModel treeSelectionModel = new DefaultTreeSelectionModel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagConstraints customPanelConstraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(-4, 8, 8, 8), 0, 0);
    private static final ComponentBundle bundle = ComponentBundle.getBundle(TargetPanel.class);
    protected BindingCallback bindingCallback;
    protected DesignContext showingContext = null;
    protected BindingTargetNode.UIDataVarNode varNode = null;
    protected DesignBean showingBean = null;
    protected DesignProperty showingProp = null;
    ActionListener updateCallback = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            TargetPanel.this.refreshExpr();
        }
    };
    JComponent customPanel = null;
    boolean needsRefresh = false;
    protected static Icon BEAN_ICON = new ImageIcon(TargetPanel.class.getResource("property.gif"));
    protected static Icon TAG_ICON = new ImageIcon(TargetPanel.class.getResource("html_element.png"));

    public TargetPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public TargetPanel(BindingCallback bindingCallback) {
        this();
        this.bindingCallback = bindingCallback;
    }

    protected DesignContext[] sortContexts(DesignContext[] designContextArray) {
        DesignContext designContext;
        int n;
        ArrayList<DesignContext> arrayList = new ArrayList<DesignContext>();
        TreeMap<String, DesignContext> treeMap = new TreeMap<String, DesignContext>();
        for (int i = 0; i < designContextArray.length; ++i) {
            treeMap.put(designContextArray[i].getDisplayName(), designContextArray[i]);
        }
        String[] stringArray = treeMap.keySet().toArray(new String[treeMap.size()]);
        for (n = 0; n < stringArray.length; ++n) {
            designContext = (DesignContext)treeMap.get(stringArray[n]);
            if (!"request".equals(designContext.getContextData("scope"))) continue;
            arrayList.add(designContext);
        }
        for (n = 0; n < stringArray.length; ++n) {
            designContext = (DesignContext)treeMap.get(stringArray[n]);
            if (!"session".equals(designContext.getContextData("scope"))) continue;
            arrayList.add(designContext);
        }
        for (n = 0; n < stringArray.length; ++n) {
            designContext = (DesignContext)treeMap.get(stringArray[n]);
            if (!"application".equals(designContext.getContextData("scope"))) continue;
            arrayList.add(designContext);
        }
        for (n = 0; n < stringArray.length; ++n) {
            designContext = (DesignContext)treeMap.get(stringArray[n]);
            if (!"none".equals(designContext.getContextData("scope"))) continue;
            arrayList.add(designContext);
        }
        return arrayList.toArray(new DesignContext[arrayList.size()]);
    }

    protected DesignBean findUIDataParentWithVar(DesignBean designBean) {
        Object object;
        DesignProperty designProperty;
        DesignBean designBean2;
        for (designBean2 = designBean.getBeanParent(); designBean2 != null && !(designBean2.getInstance() instanceof UIData); designBean2 = designBean2.getBeanParent()) {
        }
        if (designBean2 != null && designBean2.getInstance() instanceof UIData && (designProperty = designBean2.getProperty("var")) != null && (object = designProperty.getValue()) != null) {
            return designBean2;
        }
        return null;
    }

    private DesignContext[] getDesignContexts(DesignContext designContext) {
        DesignProject designProject = designContext.getProject();
        DesignContext[] designContextArray = designProject instanceof FacesDesignProject ? ((FacesDesignProject)designProject).findDesignContexts(new String[]{"request", "session", "application"}) : new DesignContext[]{};
        DesignContext[] designContextArray2 = new DesignContext[designContextArray.length + 1];
        designContextArray2[0] = designContext;
        System.arraycopy(designContextArray, 0, designContextArray2, 1, designContextArray.length);
        return designContextArray2;
    }

    public void sourceContextChanged(DesignContext designContext) {
        if (this.showingContext != null && this.showingContext == designContext) {
            return;
        }
        this.showingContext = designContext;
        this.rootNode.removeAll();
        this.rootNode.add(new BindingTargetNode.NullTargetNode(this.treeModel));
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        if (designContext != null && designContext.getProject() != null) {
            DesignContext[] designContextArray = this.getDesignContexts(designContext);
            designContextArray = this.sortContexts(designContextArray);
            for (int i = 0; designContextArray != null && i < designContextArray.length; ++i) {
                BindingTargetNode.ContextTargetNode contextTargetNode = new BindingTargetNode.ContextTargetNode(this.treeModel, designContextArray[i]);
                arrayList.add(new TreePath(new Object[]{this.rootNode, contextTargetNode}));
                this.rootNode.add(contextTargetNode);
            }
        }
        this.treeModel.reload();
        this.tree.validate();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.tree.expandPath((TreePath)arrayList.get(i));
        }
        this.refreshTarget();
    }

    public void sourceBeanChanged(DesignBean designBean) {
        DesignBean designBean2;
        if (this.showingBean == designBean) {
            return;
        }
        this.showingBean = designBean;
        if (this.varNode != null) {
            this.rootNode.remove(this.varNode);
            this.treeModel.reload();
            this.tree.validate();
            this.varNode = null;
        }
        if (this.showingBean != null && (designBean2 = this.findUIDataParentWithVar(this.showingBean)) != null) {
            this.varNode = new BindingTargetNode.UIDataVarNode(this.treeModel, designBean2);
            this.rootNode.add(1, this.varNode);
            this.treeModel.reload();
            this.tree.validate();
        }
        this.refreshTarget();
    }

    public void sourcePropertyChanged(DesignProperty designProperty) {
        if (this.showingProp == designProperty) {
            return;
        }
        this.showingProp = designProperty;
        this.refreshTarget();
    }

    public void refreshTarget() {
        if (this.showingProp != null) {
            boolean bl;
            String string = this.showingProp.getValueSource();
            boolean bl2 = bl = string != null && string.startsWith("#{") && string.endsWith("}");
            if (bl) {
                this.selectNodeForExpression(string.substring(2, string.length() - 1));
            } else {
                this.tree.setSelectionRow(0);
            }
        } else {
            this.tree.setSelectionRow(0);
        }
        this.repaint(100L);
    }

    TreeNode findChildNodeForExprPart(TreeNode treeNode, String string) {
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            BindingTargetNode bindingTargetNode;
            TreeNode treeNode2 = enumeration.nextElement();
            if (!(treeNode2 instanceof BindingTargetNode) || !string.equals((bindingTargetNode = (BindingTargetNode)treeNode2).getBindingExpressionPart())) continue;
            return treeNode2;
        }
        return null;
    }

    void selectNodeForExpression(String string) {
        TreeNode treeNode;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (stringTokenizer.hasMoreElements()) {
            arrayList.add(stringTokenizer.nextElement());
        }
        BindingTargetNode.RootTargetNode rootTargetNode = treeNode = this.rootNode;
        while (arrayList.size() > 0 && (treeNode = this.findChildNodeForExprPart(rootTargetNode, (String)arrayList.get(0))) != null) {
            arrayList.remove(0);
            rootTargetNode = treeNode;
        }
        if (rootTargetNode != null && rootTargetNode != this.rootNode) {
            this.tree.setSelectionPath(this.createPath(rootTargetNode));
        } else {
            this.tree.setSelectionRow(0);
        }
    }

    TreePath createPath(TreeNode treeNode) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        while (treeNode != null) {
            arrayList.add(0, treeNode);
            treeNode = treeNode.getParent();
        }
        return new TreePath(arrayList.toArray(new TreeNode[arrayList.size()]));
    }

    String calcExpression(BindingTargetNode bindingTargetNode) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (TreeNode treeNode = bindingTargetNode; treeNode != null; treeNode = treeNode.getParent()) {
            String string;
            Object object2;
            if (treeNode instanceof BindingTargetNode.PropertyTargetNode) {
                object = (BindingTargetNode.PropertyTargetNode)treeNode;
                if (!((BindingTargetNode.PropertyTargetNode)object).isValidBindingTarget()) continue;
                object2 = ((BindingTargetNode.PropertyTargetNode)object).getPropPath();
                if (object2 != null) {
                    for (int i = ((PropertyDescriptor[])object2).length - 1; i >= 0; --i) {
                        arrayList.add(0, ((FeatureDescriptor)object2[i]).getName());
                    }
                }
                arrayList.add(0, ((BindingTargetNode.PropertyTargetNode)object).getBean().getInstanceName());
                string = ((BindingTargetNode.PropertyTargetNode)object).getBean().getDesignContext();
                if (string instanceof FacesDesignContext) {
                    arrayList.add(0, ((FacesDesignContext)string).getReferenceName());
                    break;
                }
                arrayList.add(0, string.getDisplayName());
                break;
            }
            if (!(treeNode instanceof BindingTargetNode) || !((BindingTargetNode)(object = treeNode)).isValidBindingTarget() || (object2 = ((BindingTargetNode)object).getBindingExpressionPart()) == null) continue;
            string = "selectItems['";
            String string2 = "']";
            if (((String)object2).startsWith(string) && ((String)object2).endsWith(string2) && ((String)object2).length() > string.length() + string2.length()) {
                String string3 = ((String)object2).substring(string.length(), ((String)object2).length() - string2.length());
                string3 = string3.replaceAll("\\'", "\\\\'");
                object2 = string + string3 + string2;
            }
            arrayList.add(0, object2);
        }
        if (arrayList.size() > 0) {
            object = new StringBuffer();
            ((StringBuffer)object).append("#{");
            for (int i = 0; i < arrayList.size(); ++i) {
                ((StringBuffer)object).append("" + arrayList.get(i));
                if (i >= arrayList.size() - 1) continue;
                ((StringBuffer)object).append(".");
            }
            ((StringBuffer)object).append("}");
            return ((StringBuffer)object).toString();
        }
        return "";
    }

    void refreshExpr() {
        TreePath treePath;
        if (this.customPanel != null) {
            this.remove(this.customPanel);
            this.customPanel = null;
            this.needsRefresh = true;
        }
        if ((treePath = this.tree.getSelectionPath()) != null) {
            Object object = treePath.getLastPathComponent();
            if (object instanceof BindingTargetNode) {
                BindingTargetNode bindingTargetNode = (BindingTargetNode)object;
                this.bindingCallback.setNewExpressionText(this.calcExpression(bindingTargetNode));
                this.customPanel = bindingTargetNode.getCustomDisplayPanel(this.updateCallback);
                if (this.customPanel != null) {
                    this.add((Component)this.customPanel, this.customPanelConstraints);
                    this.needsRefresh = true;
                }
            } else {
                this.bindingCallback.setNewExpressionText("");
            }
        } else {
            this.bindingCallback.setNewExpressionText("");
        }
        if (this.needsRefresh) {
            this.bindingCallback.refresh();
        }
    }

    void jbInit() throws Exception {
        BindingTargetNode._registerTargetNodeFactory(new ResultSetTargetNodeFactory());
        BindingTargetNode._registerTargetNodeFactory(new MapTargetNodeFactory());
        this.targetLabel.setText(bundle.getMessage("selectTarget"));
        this.tree.setModel(this.treeModel);
        this.tree.setEditable(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        this.tree.setCellRenderer(new TargetTreeRenderer());
        this.tree.setSelectionModel(this.treeSelectionModel);
        this.treeSelectionModel.setSelectionMode(1);
        this.treeSelectionModel.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TargetPanel.this.refreshExpr();
            }
        });
        this.treeModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                TargetPanel.this.updateTreePainting();
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                TargetPanel.this.updateTreePainting();
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                TargetPanel.this.updateTreePainting();
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                TargetPanel.this.updateTreePainting();
            }
        });
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.targetLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(8, 8, 2, 8), 0, 0));
        this.add((Component)this.targetScroll, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 8, 8, 8), 0, 0));
        this.targetScroll.getViewport().add((Component)this.tree, null);
    }

    private void updateTreePainting() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TargetPanel.this.tree.validate();
                TargetPanel.this.targetScroll.validate();
            }
        });
    }

    class TargetTreeRenderer
    extends DefaultTreeCellRenderer {
        TargetTreeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            boolean bl5 = true;
            if (object instanceof BindingTargetNode) {
                Object object2;
                Class clazz;
                BindingTargetNode bindingTargetNode = (BindingTargetNode)object;
                if (TargetPanel.this.showingProp != null && (clazz = TargetPanel.this.showingProp.getPropertyDescriptor().getPropertyType()) != null) {
                    if (clazz.isPrimitive()) {
                        if (clazz == Boolean.TYPE) {
                            clazz = Boolean.class;
                        } else if (clazz == Character.TYPE) {
                            clazz = Character.class;
                        } else if (clazz == Byte.TYPE) {
                            clazz = Byte.class;
                        } else if (clazz == Short.TYPE) {
                            clazz = Short.class;
                        } else if (clazz == Integer.TYPE) {
                            clazz = Integer.class;
                        } else if (clazz == Long.TYPE) {
                            clazz = Long.class;
                        } else if (clazz == Float.TYPE) {
                            clazz = Float.class;
                        } else if (clazz == Double.TYPE) {
                            clazz = Double.class;
                        }
                    }
                    if ((object2 = bindingTargetNode.getTargetTypeClass()) != null) {
                        bl5 = clazz.isAssignableFrom((Class<?>)object2);
                    }
                }
                if ((clazz = bindingTargetNode.getDisplayText(bl5)) != null) {
                    this.setText((String)((Object)clazz));
                }
                if (bindingTargetNode.hasDisplayIcon() && (object2 = bindingTargetNode.getDisplayIcon(bl5)) != null) {
                    this.setIcon((Icon)object2);
                }
            }
            return this;
        }
    }
}

