/*
 * Decompiled with CFR 0.152.
 */
package editor.ui;

import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSEFont;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.ui.TSEAnnotatedUI;
import editor.ui.ExRectNodeUI;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class ExCompositeNodeUI
extends ExRectNodeUI {
    public static final double WIDTH = 120.0;
    public static final double HEIGHT = 80.0;
    Vector strings = new Vector();
    int number;
    String title;

    public void drawText(TSEGraphics tSEGraphics) {
        TSTransform tSTransform = tSEGraphics.getTSTransform();
        tSEGraphics.setColor(this.getTextColor());
        Font font = tSTransform.getScaleX() != 1.0 ? this.getScaledFont(tSTransform) : this.getFont().getFont();
        tSEGraphics.setFont(font);
        int n = tSEGraphics.getFontMetrics().getHeight();
        int n2 = tSTransform.xToDevice(this.getTextOffsetX() + this.getOwner().getLocalLeft());
        int n3 = tSTransform.yToDevice(this.getOwner().getLocalTop() - this.getTextOffsetY()) + n;
        Shape shape = tSEGraphics.getClip();
        Rectangle rectangle = tSTransform.boundsToDevice(this.getOwner().getLocalBounds());
        tSEGraphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        tSEGraphics.drawString(Integer.toString(this.number), n2, n3);
        tSEGraphics.drawString(this.title, tSTransform.xToDevice(this.getOwnerNode().getLocalRight() - this.getTextOffsetX()) - tSEGraphics.getFontMetrics().stringWidth(this.title), n3);
        tSEGraphics.setColor(this.getFillColor().getColor().darker());
        tSEGraphics.drawLine(tSTransform.xToDevice(this.getOwner().getLocalLeft()), n3 += n / 2, tSTransform.xToDevice(this.getOwner().getLocalRight()), n3);
        tSEGraphics.setColor(this.getTextColor());
        n3 += n;
        for (int i = 0; i < this.strings.size(); ++i) {
            tSEGraphics.drawString((String)this.strings.elementAt(i), n2, n3);
            n3 += n;
        }
        tSEGraphics.setClip(shape);
    }

    public int getNumber() {
        return this.number;
    }

    public List getStrings() {
        return this.strings;
    }

    public String getTitle() {
        return this.title;
    }

    public double getTightWidth() {
        return 120.0;
    }

    public double getTightHeight() {
        return 80.0;
    }

    public void setOwner(TSENode tSENode) {
        super.setOwner(tSENode);
        if (tSENode != null) {
            tSENode.setLocalSize(this.getTightWidth(), this.getTightHeight());
            tSENode.setLocalOriginalSize(this.getTightWidth(), this.getTightHeight());
        }
    }

    public TSEColor getDefaultFillColor() {
        return TSEColor.white;
    }

    public String getDefaultText() {
        return "24601|John Q. Public|SSN: 555-55-5555\nCITY: New York, NY";
    }

    public TSEFont getDefaultFont() {
        return TSEFont.SANS_SERIF_10;
    }

    public double getTextOffsetX() {
        return 3.0;
    }

    public double getTextOffsetY() {
        return 2.0;
    }

    public void onTextChanged(String string) {
        if (string == null) {
            this.strings.removeAllElements();
            this.number = 999;
            this.title = "Unknown";
            this.strings.addElement("Line 1");
            this.strings.addElement("Line 2");
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|", true);
            String string2 = null;
            if (stringTokenizer.hasMoreTokens() && !(string2 = stringTokenizer.nextToken()).equals("|")) {
                this.number = Integer.parseInt(string2);
                string2 = stringTokenizer.nextToken();
            } else {
                this.number = 999;
            }
            if (stringTokenizer.hasMoreTokens() && !(string2 = stringTokenizer.nextToken()).equals("|")) {
                this.title = string2;
                string2 = stringTokenizer.nextToken();
            } else {
                this.title = "Unknown";
            }
            this.strings.removeAllElements();
            if (!stringTokenizer.hasMoreTokens()) {
                this.strings.addElement("Line 1");
                this.strings.addElement("Line 2");
            } else {
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "\n");
                while (stringTokenizer2.hasMoreElements()) {
                    this.strings.addElement(stringTokenizer2.nextToken());
                }
            }
        }
        super.onTextChanged(string);
    }

    public Object clone() {
        ExCompositeNodeUI exCompositeNodeUI = (ExCompositeNodeUI)((Object)super.clone());
        exCompositeNodeUI.strings = (Vector)this.strings.clone();
        return exCompositeNodeUI;
    }

    public void getInspectorPropertyIDs(List list) {
        super.getInspectorPropertyIDs(list);
        list.remove(TSENode.NAME_ID);
        list.remove(TSEAnnotatedUI.JUSTIFICATION_ID);
    }
}

