/*
 * Decompiled with CFR 0.152.
 */
package editor.ui;

import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.event.TSEAnyChangeAdapter;
import com.tomsawyer.editor.event.TSEEventManager;
import com.tomsawyer.editor.event.TSEViewportChangeEvent;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.ui.TSERectangularUI;
import com.tomsawyer.event.TSEvent;
import editor.ExGraphWindow;
import editor.ui.ExRectNodeUI;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.List;

public class ExAnimatedRectNodeUI
extends ExRectNodeUI
implements ActionListener,
MouseMotionListener {
    static final double SLOW_STEP = 0.01;
    static final double FAST_STEP = 0.2;
    float fillHue;
    float fillSaturation;
    float fillBrightness;
    double colorStep;
    int mouseX;
    int mouseY;
    boolean mouseIsIn;
    ExGraphWindow parentWindow;
    boolean listening;
    EventListener eventListener;

    public void reset() {
        super.reset();
        this.mouseIsIn = false;
        this.listening = false;
        this.colorStep = 0.01;
        float[] fArray = this.getFillColorHSB();
        this.fillHue = fArray[0];
        this.fillSaturation = fArray[1];
        this.fillBrightness = fArray[2];
        this.eventListener = new AnimatedRectEventListener();
        this.parentWindow = null;
    }

    public void draw(TSEGraphics tSEGraphics) {
        TSEGraphWindow tSEGraphWindow = tSEGraphics.getGraphWindow();
        if (this.parentWindow == null && !tSEGraphWindow.isOverview() && tSEGraphWindow instanceof ExGraphWindow) {
            this.parentWindow = (ExGraphWindow)tSEGraphWindow;
        }
        this.setListening(true);
        super.draw(tSEGraphics);
    }

    float[] getFillColorHSB() {
        if (this.getFillColor() != null && this.getFillColor().getColor() != null) {
            return Color.RGBtoHSB(this.getFillColor().getColor().getRed(), this.getFillColor().getColor().getGreen(), this.getFillColor().getColor().getBlue(), null);
        }
        return new float[3];
    }

    protected void setListening(boolean bl) {
        if (this.listening != bl && this.parentWindow != null) {
            this.listening = bl;
            if (bl) {
                this.parentWindow.addTimerListener(this);
                this.parentWindow.getCanvas().addMouseMotionListener(this);
                this.registerListeners();
            } else {
                this.parentWindow.removeTimerListener(this);
                this.parentWindow.getCanvas().removeMouseMotionListener(this);
                this.unregisterListeners();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.parentWindow != null && this.parentWindow.isTimerEvent(actionEvent) && !this.isTransparent()) {
            float[] fArray = this.getFillColorHSB();
            boolean bl = this.getOwnerNode().getOwnerGraph().isFiringEvents();
            this.getOwnerNode().getOwnerGraph().setFireEvents(false);
            if (this.mouseIsIn) {
                fArray[1] = (float)((double)fArray[1] + this.colorStep);
                if (fArray[1] > 1.0f) {
                    fArray[1] = 0.0f;
                }
                this.setFillColor(new TSEColor(Color.getHSBColor(this.fillHue, fArray[1], this.fillBrightness)));
            } else {
                fArray[0] = (float)((double)fArray[0] + this.colorStep);
                if (fArray[0] > 1.0f) {
                    fArray[0] = 0.0f;
                }
                this.setFillColor(new TSEColor(Color.getHSBColor(fArray[0], this.fillSaturation, this.fillBrightness)));
            }
            this.getOwnerNode().getOwnerGraph().setFireEvents(bl);
            this.invalidateWorldBounds();
        }
    }

    protected void updateMouse() {
        TSPoint tSPoint = new TSPoint(this.parentWindow.getWorldPoint(new Point(this.mouseX, this.mouseY)));
        TSEGraph tSEGraph = (TSEGraph)this.getOwnerNode().getTransformGraph();
        tSEGraph.inverseExpandedTransformPoint(tSPoint);
        if (!this.mouseIsIn && this.getBounds().contains((TSConstPoint)tSPoint)) {
            this.mouseIsIn = true;
            this.onMouseEnter();
        } else if (this.mouseIsIn && !this.getBounds().contains((TSConstPoint)tSPoint)) {
            this.mouseIsIn = false;
            this.onMouseExit();
        }
    }

    public void onMouseEnter() {
        this.colorStep = 0.2;
        float[] fArray = this.getFillColorHSB();
        this.fillHue = fArray[0];
    }

    public void onMouseExit() {
        this.colorStep = 0.01;
        boolean bl = this.getOwnerNode().getOwnerGraph().isFiringEvents();
        this.getOwnerNode().getOwnerGraph().setFireEvents(false);
        this.setFillColor(new TSEColor(Color.getHSBColor(this.fillHue, this.fillSaturation, this.fillBrightness)));
        this.getOwnerNode().getOwnerGraph().setFireEvents(bl);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.processMouseMotion(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.processMouseMotion(mouseEvent);
    }

    public void processMouseMotion(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        this.updateMouse();
        mouseEvent.consume();
    }

    public void invalidateWorldBounds() {
        this.parentWindow.addInvalidRegion(this.getOwner());
        this.parentWindow.requestUpdateOnTimer();
    }

    public void getInspectorPropertyIDs(List list) {
        super.getInspectorPropertyIDs(list);
        list.remove(TSERectangularUI.COLOR_ID);
        list.remove(TSERectangularUI.TRANSPARENT_ID);
    }

    public void registerListeners() {
        TSEGraphManager tSEGraphManager = this.parentWindow.getGraphManager();
        TSEEventManager tSEEventManager = (TSEEventManager)tSEGraphManager.getEventManager();
        tSEEventManager.addGraphChangeListener((Object)tSEGraphManager, this.eventListener);
        tSEEventManager.addDrawingChangeListener((Object)tSEGraphManager, this.eventListener, 1L);
        tSEEventManager.addViewportChangeListener((Object)this.parentWindow, this.eventListener);
    }

    public void unregisterListeners() {
        this.parentWindow.getGraphManager().getEventManager().removeListener(this.eventListener);
    }

    public class AnimatedRectEventListener
    extends TSEAnyChangeAdapter {
        AnimatedRectEventListener() {
        }

        public void drawingChanged(TSDrawingChangeEvent tSDrawingChangeEvent) {
            if (tSDrawingChangeEvent.getType() == 1L) {
                ExAnimatedRectNodeUI.this.setListening(false);
                ExAnimatedRectNodeUI.this.parentWindow = null;
            }
        }

        public void viewportChanged(TSEViewportChangeEvent tSEViewportChangeEvent) {
            ExAnimatedRectNodeUI.this.updateMouse();
        }

        public void anyChange(TSEvent tSEvent) {
            ExAnimatedRectNodeUI.this.updateMouse();
            TSENode tSENode = ExAnimatedRectNodeUI.this.getOwnerNode();
            boolean bl = tSENode != null && tSENode.isOwned() && tSENode.isViewable();
            ExAnimatedRectNodeUI.this.setListening(bl);
        }
    }
}

