/*
 * Decompiled with CFR 0.152.
 */
package editor.ui;

import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.event.TSEAnyChangeAdapter;
import com.tomsawyer.editor.event.TSEEventManager;
import com.tomsawyer.editor.event.TSEViewportChangeEvent;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.tool.TSEReconnectEdgeTool;
import com.tomsawyer.editorx.ui.TSEDashedEdgeUI;
import com.tomsawyer.event.TSEvent;
import editor.ExGraphWindow;
import java.awt.BasicStroke;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;

public class ExAnimatedEdgeUI
extends TSEDashedEdgeUI
implements ActionListener,
MouseMotionListener {
    static final float SLOW_STEP = -0.05f;
    static final float FAST_STEP = -0.1f;
    float phaseStep;
    int mouseX;
    int mouseY;
    boolean mouseIsIn;
    ExGraphWindow parentWindow;
    boolean listening;
    int widthMultiplier = 1;
    EventListener eventListener;

    public void reset() {
        super.reset();
        this.mouseIsIn = false;
        this.listening = false;
        this.phaseStep = -0.05f;
        this.eventListener = new AnimatedEdgeEventListener();
        this.parentWindow = null;
    }

    public void draw(TSEGraphics tSEGraphics) {
        TSEGraphWindow tSEGraphWindow = tSEGraphics.getGraphWindow();
        if (this.parentWindow == null && !tSEGraphWindow.isOverview() && tSEGraphWindow instanceof ExGraphWindow) {
            this.parentWindow = (ExGraphWindow)tSEGraphWindow;
        }
        this.setListening(true);
        super.draw(tSEGraphics);
    }

    public void drawSelected(TSEGraphics tSEGraphics) {
        TSEGraphWindow tSEGraphWindow = tSEGraphics.getGraphWindow();
        if (this.parentWindow == null && !tSEGraphWindow.isOverview() && tSEGraphWindow instanceof ExGraphWindow) {
            this.parentWindow = (ExGraphWindow)tSEGraphWindow;
        }
        this.setListening(true);
        super.drawSelected(tSEGraphics);
    }

    protected void setListening(boolean bl) {
        if (this.listening != bl && this.parentWindow != null) {
            this.listening = bl;
            if (bl) {
                this.parentWindow.addTimerListener(this);
                this.parentWindow.getCanvas().addMouseMotionListener(this);
                this.registerListeners();
            } else {
                this.parentWindow.removeTimerListener(this);
                this.parentWindow.getCanvas().removeMouseMotionListener(this);
                this.unregisterListeners();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!(this.parentWindow == null || !this.parentWindow.isTimerEvent(actionEvent) || this.parentWindow.getCurrentTool() instanceof TSEReconnectEdgeTool && ((TSEReconnectEdgeTool)this.parentWindow.getCurrentTool()).isBuildingEdge())) {
            float f = this.getDashPhase();
            if ((f += this.phaseStep) > 1.0f) {
                f -= 1.0f;
            } else if (f < 0.0f) {
                f += 1.0f;
            }
            this.setDashPhase(f);
            TSEGraph tSEGraph = (TSEGraph)this.getOwnerEdge().getOwnerGraph();
            if (tSEGraph.getGraphWindow() == this.parentWindow) {
                this.invalidateWorldBounds();
            }
        }
    }

    protected void updateMouse() {
        TSPoint tSPoint = new TSPoint(this.parentWindow.getWorldPoint(new Point(this.mouseX, this.mouseY)));
        TSENode tSENode = (TSENode)this.getOwnerEdge().getSourceNode();
        if (tSENode != null) {
            TSEGraph tSEGraph = (TSEGraph)tSENode.getTransformGraph();
            tSEGraph.inverseExpandedTransformPoint(tSPoint);
            boolean bl = tSENode.isExpanded() ? tSENode.locallyIntersectsNodeFrame(tSPoint) : tSENode.locallyContains((TSConstPoint)tSPoint);
            if (!this.mouseIsIn && bl) {
                this.mouseIsIn = true;
                this.onMouseEnter();
            } else if (this.mouseIsIn && !bl) {
                this.mouseIsIn = false;
                this.onMouseExit();
            }
        }
    }

    public void onMouseEnter() {
        this.widthMultiplier = 3;
        this.mouseIsIn = true;
        this.phaseStep = -0.1f;
    }

    public void onMouseExit() {
        this.widthMultiplier = 1;
        this.mouseIsIn = false;
        this.phaseStep = -0.05f;
        TSEGraph tSEGraph = (TSEGraph)this.getOwnerEdge().getOwnerGraph();
        if (tSEGraph.getGraphWindow() == this.parentWindow) {
            this.invalidateWorldBounds();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.processMouseMotion(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.processMouseMotion(mouseEvent);
    }

    public void processMouseMotion(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        this.updateMouse();
        mouseEvent.consume();
    }

    public TSEGraphics convertGraphics(TSEGraphics tSEGraphics) {
        TSEGraphics tSEGraphics2 = super.convertGraphics(tSEGraphics);
        if (this.mouseIsIn) {
            BasicStroke basicStroke = (BasicStroke)tSEGraphics.getStroke();
            BasicStroke basicStroke2 = new BasicStroke(basicStroke.getLineWidth() * (float)this.widthMultiplier, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase());
            tSEGraphics.setStroke((Stroke)basicStroke2);
        }
        return tSEGraphics2;
    }

    public void invalidateWorldBounds() {
        TSEEdge tSEEdge = this.getOwnerEdge();
        if (tSEEdge.isViewable()) {
            this.parentWindow.addInvalidRegion((TSEObject)tSEEdge);
            this.parentWindow.requestUpdateOnTimer();
        } else {
            this.setListening(false);
        }
    }

    public void registerListeners() {
        TSEGraphManager tSEGraphManager = this.parentWindow.getGraphManager();
        TSEEventManager tSEEventManager = (TSEEventManager)tSEGraphManager.getEventManager();
        tSEEventManager.addGraphChangeListener((Object)tSEGraphManager, this.eventListener);
        tSEEventManager.addDrawingChangeListener((Object)tSEGraphManager, this.eventListener, 1L);
        tSEEventManager.addViewportChangeListener((Object)this.parentWindow, this.eventListener);
    }

    public void unregisterListeners() {
        this.parentWindow.getGraphManager().getEventManager().removeListener(this.eventListener);
    }

    public class AnimatedEdgeEventListener
    extends TSEAnyChangeAdapter {
        AnimatedEdgeEventListener() {
        }

        public void drawingChanged(TSDrawingChangeEvent tSDrawingChangeEvent) {
            if (tSDrawingChangeEvent.getType() == 1L) {
                ExAnimatedEdgeUI.this.setListening(false);
                ExAnimatedEdgeUI.this.parentWindow = null;
            }
        }

        public void viewportChanged(TSEViewportChangeEvent tSEViewportChangeEvent) {
            ExAnimatedEdgeUI.this.updateMouse();
        }

        public void anyChange(TSEvent tSEvent) {
            ExAnimatedEdgeUI.this.updateMouse();
            TSEEdge tSEEdge = ExAnimatedEdgeUI.this.getOwnerEdge();
            boolean bl = tSEEdge != null && tSEEdge.isOwned() && tSEEdge.isVisible() && tSEEdge.isViewable();
            ExAnimatedEdgeUI.this.setListening(bl);
        }
    }
}

