/*
 * Decompiled with CFR 0.152.
 */
package editor;

import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDLicenseManager;
import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSEGrid;
import com.tomsawyer.editor.TSEWindowTool;
import com.tomsawyer.editor.TSVisualizationProduct;
import com.tomsawyer.editor.command.TSERandomLayoutCommand;
import com.tomsawyer.editor.command.TSEViewParentGraphCommand;
import com.tomsawyer.editor.complexity.command.TSECollapseCommand;
import com.tomsawyer.editor.complexity.command.TSEExpandCommand;
import com.tomsawyer.editor.complexity.command.TSEFoldCommand;
import com.tomsawyer.editor.complexity.command.TSEHideCommand;
import com.tomsawyer.editor.complexity.command.TSEUnfoldCommand;
import com.tomsawyer.editor.complexity.command.TSEUnhideCommand;
import com.tomsawyer.editor.event.TSEAnyChangeAdapter;
import com.tomsawyer.editor.event.TSEEventManager;
import com.tomsawyer.editor.event.TSESelectionChangeEvent;
import com.tomsawyer.editor.event.TSEViewportChangeEvent;
import com.tomsawyer.editor.service.TSEAllOptionsServiceInputData;
import com.tomsawyer.editor.tool.TSECreateEdgeTool;
import com.tomsawyer.editor.tool.TSECreateNodeTool;
import com.tomsawyer.editor.tool.TSEInteractiveZoomTool;
import com.tomsawyer.editor.tool.TSELinkNavigationTool;
import com.tomsawyer.editor.tool.TSEPanTool;
import com.tomsawyer.editor.tool.TSEPasteTool;
import com.tomsawyer.editor.tool.TSESelectTool;
import com.tomsawyer.editor.tool.TSEZoomTool;
import com.tomsawyer.event.TSEvent;
import com.tomsawyer.service.TSServiceInputData;
import com.tomsawyer.service.layout.jlayout.TSGeneralLayoutInputTailor;
import com.tomsawyer.util.TSOptionData;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.command.TSCommand;
import com.tomsawyer.util.command.TSCommandListener;
import editor.ExGraphWindow;
import editor.Tomahawk;
import editor.command.ExSnapToGridCommand;
import editor.tool.ExSelectTool;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class TomahawkActions
extends TSEAnyChangeAdapter
implements ActionListener,
TSCommandListener {
    static /* synthetic */ Class class$editor$Tomahawk;

    public void onNextState() {
        this.onNextTool();
    }

    public void onNextToolSet() {
        TSEWindowTool tSEWindowTool = Tomahawk.getInstance().getGraphWindow().getCurrentTool();
        if (tSEWindowTool instanceof TSECreateNodeTool || tSEWindowTool instanceof TSECreateEdgeTool) {
            this.onSwitchToSelect();
        } else {
            Tomahawk.getInstance().onSwitchToCreateNodes();
        }
    }

    public void onNextTool() {
        TSEWindowTool tSEWindowTool = Tomahawk.getInstance().getGraphWindow().getCurrentTool();
        if (tSEWindowTool instanceof TSESelectTool && !Tomahawk.getInstance().isAutoFitInWindow()) {
            this.onSwitchToPan();
        } else if (tSEWindowTool instanceof TSEPanTool && !Tomahawk.getInstance().isAutoFitInWindow()) {
            this.onSwitchToZoom();
        } else if (tSEWindowTool instanceof TSEZoomTool && !Tomahawk.getInstance().isAutoFitInWindow()) {
            this.onSwitchToInteractiveZoom();
        } else if (tSEWindowTool instanceof TSECreateNodeTool && Tomahawk.getInstance().getGraphManager().numberOfNodes() > 0) {
            Tomahawk.getInstance().onSwitchToCreateEdges();
        } else if (tSEWindowTool instanceof TSECreateEdgeTool) {
            Tomahawk.getInstance().onSwitchToCreateNodes();
        } else if (tSEWindowTool instanceof TSEInteractiveZoomTool && Tomahawk.getInstance().getGraphManager().numberOfViewableEdges() > 0 && !Tomahawk.getInstance().isAutoFitInWindow()) {
            this.onSwitchToLinkNavigation();
        } else {
            this.onSwitchToSelect();
        }
    }

    public void onSwitchToSelect() {
        Tomahawk.getInstance().getGraphWindow().switchTool(Tomahawk.getInstance().getGraphWindow().getDefaultTool());
        Tomahawk.getInstance().showWindowStatus(Tomahawk.getResources().getStringResource("tools.select.status"));
        Tomahawk.getInstance().correlateButtonSelection("SELECT_TOOL", true);
    }

    public void onSwitchToZoom() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.MARQUEE_ZOOM_TOOL)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            Tomahawk.getInstance().getGraphWindow().switchTool((TSEWindowTool)new TSEZoomTool());
            Tomahawk.getInstance().showWindowStatus(Tomahawk.getResources().getStringResource("tools.marqueeZoom.status"));
            Tomahawk.getInstance().correlateButtonSelection("ZOOM_TOOL", true);
            Tomahawk.getInstance().correlateButtonSelection("ZOOM_CUSTOM", true);
        }
    }

    public void onSwitchToInteractiveZoom() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.INTERACTIVE_ZOOM_TOOL)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            Tomahawk.getInstance().getGraphWindow().switchTool((TSEWindowTool)new TSEInteractiveZoomTool());
            Tomahawk.getInstance().showWindowStatus(Tomahawk.getResources().getStringResource("tools.interactiveZoom.status"));
            Tomahawk.getInstance().correlateButtonSelection("INTERACTIVE_ZOOM_TOOL", true);
            Tomahawk.getInstance().correlateButtonSelection("ZOOM_CUSTOM", true);
        }
    }

    public void onSwitchToPan() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.PAN_TOOL)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            Tomahawk.getInstance().getGraphWindow().switchTool((TSEWindowTool)new TSEPanTool());
            Tomahawk.getInstance().showWindowStatus(Tomahawk.getResources().getStringResource("tools.pan.status"));
            Tomahawk.getInstance().correlateButtonSelection("PAN_TOOL", true);
        }
    }

    public void onSwitchToLinkNavigation() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.LINK_NAVIGATOR_TOOL)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            Tomahawk.getInstance().getGraphWindow().switchTool((TSEWindowTool)new TSELinkNavigationTool());
            Tomahawk.getInstance().showWindowStatus(Tomahawk.getResources().getStringResource("tools.navigateEdges.status"));
            Tomahawk.getInstance().correlateButtonSelection("EDGE_NAVIGATION_TOOL", true);
        }
    }

    public void onAbortAction() {
        if (Tomahawk.getInstance().hasGraphWindow()) {
            Tomahawk.getInstance().getGraphWindow().cancelAction();
        }
    }

    public void onRefresh() {
        Tomahawk.getInstance().getGraphWindow().drawGraph();
        Tomahawk.getInstance().getGraphWindow().fastRepaint();
    }

    public void onCutGraph() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.EDIT_CUT)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            Tomahawk tomahawk = Tomahawk.getInstance();
            TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData = tomahawk.getServiceInputData(tomahawk.getGraphWindow());
            tomahawk.getGraphWindow().cut((TSOptionData)tSEAllOptionsServiceInputData);
            tomahawk.correlateButtonAbility("PASTE_GRAPH", true);
        }
    }

    public void onCopyGraph() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.EDIT_COPY)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            Tomahawk tomahawk = Tomahawk.getInstance();
            TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData = tomahawk.getServiceInputData(tomahawk.getGraphWindow());
            tomahawk.getGraphWindow().copy((TSOptionData)tSEAllOptionsServiceInputData);
            tomahawk.checkAllButtons();
            tomahawk.correlateButtonAbility("PASTE_GRAPH", true);
        }
    }

    public void onPasteGraph() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.EDIT_PASTE)) {
            Tomahawk.showLicenseErrorMessage();
        } else if (!(Tomahawk.getInstance().getGraphWindow().getCurrentTool() instanceof TSEPasteTool)) {
            Tomahawk tomahawk = Tomahawk.getInstance();
            TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData = tomahawk.getServiceInputData(tomahawk.getGraphWindow());
            tomahawk.getGraphWindow().switchTool((TSEWindowTool)new TSEPasteTool((TSOptionData)tSEAllOptionsServiceInputData));
            tomahawk.showWindowStatus("Pasting");
            tomahawk.correlateButtonSelection("PASTE_GRAPH", false);
        }
    }

    public void onDuplicateGraph() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.EDIT_PASTE)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            Tomahawk tomahawk = Tomahawk.getInstance();
            TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData = tomahawk.getServiceInputData(tomahawk.getGraphWindow());
            tomahawk.getGraphWindow().duplicate((TSOptionData)tSEAllOptionsServiceInputData);
        }
    }

    public void onClearAll() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.EDIT_DELETE)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            Tomahawk.getInstance().getGraphWindow().clearAll();
            this.onSwitchToSelect();
        }
    }

    public void onDeleteSelected() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.EDIT_DELETE)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            Tomahawk.getInstance().getGraphWindow().deleteSelected();
        }
    }

    public void onHideSelected() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.HIDING)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            this.hideSelected();
        }
    }

    public void onUnhideAll() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.HIDING)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            this.unhideAll();
        }
    }

    public void onFoldSelected() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.FOLDING)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            this.foldSelected();
        }
    }

    public void onUnfoldAll() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.FOLDING)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            this.unfoldAll();
        }
    }

    public void onUnfoldSelected() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.FOLDING)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            this.unfoldSelected();
        }
    }

    public void onCollapseSelected() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.NESTING)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            this.collapseSelected();
        }
    }

    public void onExpandSelected() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.NESTING)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            this.expandSelected();
        }
    }

    public void onScrollGraph(int n) {
        switch (n) {
            case 37: {
                Tomahawk.getInstance().getGraphWindow().scrollBy(-20, 0, true);
                break;
            }
            case 39: {
                Tomahawk.getInstance().getGraphWindow().scrollBy(20, 0, true);
                break;
            }
            case 38: {
                Tomahawk.getInstance().getGraphWindow().scrollBy(0, -20, true);
                break;
            }
            case 40: {
                Tomahawk.getInstance().getGraphWindow().scrollBy(0, 20, true);
            }
        }
    }

    public void onSelectAll() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.SELECT_TOOL)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            Tomahawk.getInstance().getGraphWindow().selectAll(true);
        }
    }

    public void onSelectNodes() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.SELECT_TOOL)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            Tomahawk.getInstance().getGraphWindow().deselectAll(false);
            Tomahawk.getInstance().getGraphWindow().selectAllNodes(true);
        }
    }

    public void onSelectEdges() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.SELECT_TOOL)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            Tomahawk.getInstance().getGraphWindow().deselectAll(false);
            Tomahawk.getInstance().getGraphWindow().selectAllEdges(true);
        }
    }

    public void onSelectLabels() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.SELECT_TOOL)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            Tomahawk.getInstance().getGraphWindow().deselectAll(false);
            Tomahawk.getInstance().getGraphWindow().selectAllEdgeLabels(true);
            Tomahawk.getInstance().getGraphWindow().selectAllNodeLabels(true);
            Tomahawk.getInstance().getGraphWindow().selectAllConnectorLabels(true);
        }
    }

    public void onZoomChange() {
        String string = Tomahawk.getInstance().getZoomComboBox().getSelectedItem().toString();
        if (string.equals("") || string.equals("Fit In Window")) {
            Tomahawk.getInstance().onFitInWindow();
        }
        if (string.endsWith("%")) {
            string = string.substring(0, string.length() - 1);
        }
        try {
            double d = Math.abs(Double.valueOf(string));
            double d2 = Tomahawk.getInstance().getGraphWindow().getZoomLevel() * 100.0;
            if (d2 != d) {
                this.onZoom("ZOOM." + d);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onZoom(String string) {
        double d = 1.0;
        int n = string.indexOf(46);
        if (n > 0) {
            try {
                d = Double.valueOf(string.substring(n + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Tomahawk.getInstance().getGraphWindow().setZoomLevel(d / 100.0, true);
        Tomahawk.getInstance().correlateButtonSelection(string, true);
    }

    public void onGridType(String string) {
        this.onGridType(string, true);
    }

    public void onGridType(String string, boolean bl) {
        int n = string.lastIndexOf(46);
        if (n > 0) {
            String string2 = string.substring(n + 1);
            if (string2.equals("none")) {
                Tomahawk.getInstance().getGraphWindow().setGrid(null);
            } else if (string2.equals("point")) {
                Tomahawk.getInstance().getGraphWindow().setGrid((TSEGrid)Tomahawk.getInstance().pointGrid);
            } else if (string2.equals("line")) {
                Tomahawk.getInstance().getGraphWindow().setGrid((TSEGrid)Tomahawk.getInstance().lineGrid);
            }
            if (bl) {
                Tomahawk.getInstance().getGraphWindow().drawGraph();
                Tomahawk.getInstance().getGraphWindow().fastRepaint();
            }
        }
        Tomahawk.getInstance().checkAllButtons();
    }

    public void onGridSize(String string) {
        this.onGridSize(string, true);
    }

    public void onGridSize(String string, boolean bl) {
        int n = -1;
        int n2 = string.lastIndexOf(46);
        if (n2 > 0) {
            try {
                n = Integer.parseInt(string.substring(n2 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n != -1) {
            Tomahawk.getInstance().lineGrid.setXSpacing((double)n);
            Tomahawk.getInstance().lineGrid.setYSpacing((double)n);
            Tomahawk.getInstance().pointGrid.setXSpacing((double)n);
            Tomahawk.getInstance().pointGrid.setYSpacing((double)n);
            if (bl) {
                Tomahawk.getInstance().getGraphWindow().drawGraph();
                Tomahawk.getInstance().getGraphWindow().fastRepaint();
            }
            Tomahawk.getInstance().correlateButtonSelection(string, true);
        }
    }

    public void onCustomGridSize() {
        double d = Tomahawk.getInstance().lineGrid.getXSpacing();
        String string = (String)JOptionPane.showInputDialog(Tomahawk.getInstance(), Tomahawk.getResources().getStringResource("dialog.gridSize.message"), Tomahawk.getResources().getStringResource("dialog.gridSize.title"), -1, null, null, Double.toString(d));
        if (string != null && string.length() > 0) {
            try {
                double d2 = Double.valueOf(string);
                if (d2 <= 0.0) {
                    JOptionPane.showMessageDialog(Tomahawk.getInstance(), Tomahawk.getResources().getStringResource("dialog.gridSizeError.message"), Tomahawk.getResources().getStringResource("dialog.gridSizeError.title"), 0);
                } else {
                    if (d2 != d) {
                        Tomahawk.getInstance().lineGrid.setXSpacing(d2);
                        Tomahawk.getInstance().lineGrid.setYSpacing(d2);
                        Tomahawk.getInstance().pointGrid.setXSpacing(d2);
                        Tomahawk.getInstance().pointGrid.setYSpacing(d2);
                    }
                    Tomahawk.getInstance().correlateButtonSelection("ZOOM_CUSTOM", true);
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(Tomahawk.getInstance(), Tomahawk.getResources().getStringResource("dialog.gridSizeError.message"), Tomahawk.getResources().getStringResource("dialog.gridSizeError.title"), 0);
            }
        }
        Tomahawk.getInstance().getGraphWindow().drawGraph();
        Tomahawk.getInstance().getGraphWindow().fastRepaint();
    }

    public void onSnapToGrid() {
        ExGraphWindow exGraphWindow = Tomahawk.getInstance().getGraphWindow();
        exGraphWindow.transmit(new ExSnapToGridCommand(exGraphWindow));
    }

    public void onExpandCollapseAll(boolean bl) {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.NESTING)) {
            Tomahawk.showLicenseErrorMessage();
        } else if (bl) {
            this.expandAll();
        } else {
            this.collapseAll();
        }
    }

    public void onCustomZoom() {
        String string;
        double d = 100.0 * Tomahawk.getInstance().getGraphWindow().getZoomLevel();
        String string2 = String.valueOf(d = (double)Math.round(d * 100.0) / 100.0);
        if (string2.endsWith(".0")) {
            string2 = string2.substring(0, string2.lastIndexOf(".0"));
        }
        if ((string = (String)JOptionPane.showInputDialog(Tomahawk.getInstance(), Tomahawk.getResources().getStringResource("dialog.zoom.message"), Tomahawk.getResources().getStringResource("dialog.zoom.title"), -1, null, null, string2)) != null && string.length() > 0) {
            try {
                double d2 = Double.valueOf(string);
                if (d2 < Tomahawk.getInstance().getGraphWindow().getMinZoomLevel() * 100.0 || d2 > Tomahawk.getInstance().getGraphWindow().getMaxZoomLevel() * 100.0) {
                    throw new Exception();
                }
                double d3 = d2 / 100.0;
                if (d3 != d) {
                    Tomahawk.getInstance().getGraphWindow().setZoomLevel(d3, true);
                }
                Tomahawk.getInstance().correlateButtonSelection("ZOOM_CUSTOM", true);
            }
            catch (Exception exception) {
                String string3 = TSSystem.replace((String)Tomahawk.getResources().getStringResource("dialog.zoomError.message"), (String)"%X%", (String)("" + Tomahawk.getInstance().getGraphWindow().getMinZoomLevel() * 100.0));
                string3 = TSSystem.replace((String)string3, (String)"%Y%", (String)("" + Tomahawk.getInstance().getGraphWindow().getMaxZoomLevel() * 100.0));
                JOptionPane.showMessageDialog(Tomahawk.getInstance(), string3, Tomahawk.getResources().getStringResource("dialog.zoomError.title"), 0);
            }
        }
        Tomahawk.getInstance().getGraphWindow().fastRepaint();
    }

    public void onZoomIn() {
        ExGraphWindow exGraphWindow = Tomahawk.getInstance().getGraphWindow();
        if (exGraphWindow.getZoomLevel() < exGraphWindow.getMaxZoomLevel() / 1.1) {
            exGraphWindow.zoom(0.1, true);
        } else {
            exGraphWindow.setZoomLevel(exGraphWindow.getMaxZoomLevel(), true);
        }
        Tomahawk.getInstance().correlateButtonSelection("ZOOM_CUSTOM", true);
    }

    public void onZoomOut() {
        ExGraphWindow exGraphWindow = Tomahawk.getInstance().getGraphWindow();
        if (exGraphWindow.getZoomLevel() > exGraphWindow.getMinZoomLevel() * 1.1) {
            exGraphWindow.zoom(-0.1, true);
        } else {
            exGraphWindow.setZoomLevel(exGraphWindow.getMinZoomLevel(), true);
        }
        Tomahawk.getInstance().correlateButtonSelection("ZOOM_CUSTOM", true);
    }

    public void onRunMode() {
        ExGraphWindow exGraphWindow;
        exGraphWindow.setInRunMode(!(exGraphWindow = Tomahawk.getInstance().getGraphWindow()).isInRunMode());
        Tomahawk.getInstance().correlateButtonSelection("RUN_MODE", exGraphWindow.isInRunMode());
    }

    public void onUndoAction() {
        try {
            Tomahawk.getInstance().getGraphWindow().undo();
            Tomahawk.getInstance().setChanged(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(Tomahawk.getInstance(), Tomahawk.getResources().getStringResource("dialog.undoError.message"), Tomahawk.getResources().getStringResource("dialog.undoError.title"), 1);
        }
        Tomahawk.getInstance().checkAllButtons();
    }

    public void onRedoAction() {
        try {
            Tomahawk.getInstance().getGraphWindow().redo();
            Tomahawk.getInstance().setChanged(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(Tomahawk.getInstance(), Tomahawk.getResources().getStringResource("dialog.redoError.message"), Tomahawk.getResources().getStringResource("dialog.redoError.title"), 1);
        }
        Tomahawk.getInstance().checkAllButtons();
    }

    public void onGoToParentGraph() {
        ExGraphWindow exGraphWindow;
        TSEGraph tSEGraph;
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.DRILL_DOWN)) {
            Tomahawk.getInstance();
            Tomahawk.showLicenseErrorMessage();
        } else if (Tomahawk.getInstance().hasGraphWindow() && (tSEGraph = (exGraphWindow = Tomahawk.getInstance().getGraphWindow()).getGraph()).isChildGraph()) {
            tSEGraph.deselectAll();
            TSEViewParentGraphCommand tSEViewParentGraphCommand = new TSEViewParentGraphCommand((TSEGraphWindow)exGraphWindow, tSEGraph);
            exGraphWindow.transmit((TSCommand)tSEViewParentGraphCommand);
        }
        Tomahawk.getInstance().correlateButtonSelection("GOTO_PARENT", false);
    }

    public void onClearHistory() {
        int n = JOptionPane.showConfirmDialog(Tomahawk.getInstance(), Tomahawk.getResources().getStringResource("dialog.clearHistory.message"), Tomahawk.getResources().getStringResource("dialog.clearHistory.title"), 0, 2);
        if (n == 0) {
            Tomahawk.getInstance().getGraphWindow().clearUndoStack();
            Tomahawk.getInstance().checkAllButtons();
        }
    }

    public void onHelpAbout() {
        String string = Tomahawk.getResources().getStringResource("dialog.about.message");
        string = TSSystem.replace((String)string, (String)"%TSVJ_MAJOR_VERSION%", (String)TSVisualizationProduct.getBuildString().substring(0, 3));
        string = TSSystem.replace((String)string, (String)"%TSVJ_VERSION%", (String)TSVisualizationProduct.getBuildString());
        string = TSSystem.replace((String)string, (String)"%TSVJ_TRACK%", (String)TSVisualizationProduct.getTrackString());
        string = TSSystem.replace((String)string, (String)"%TSVJ_TIER%", (String)TSVisualizationProduct.getTierString());
        string = TSSystem.replace((String)string, (String)"%LAYOUT_STYLES%", (String)Tomahawk.getInstance().getLayoutServerStyleHeadings());
        String string2 = Tomahawk.getInstance().getLayoutServerType();
        if (string2.equals("None")) {
            string2 = "";
        }
        string = TSSystem.replace((String)string, (String)"%LAYOUT_SERVER_TYPE%", (String)string2);
        string = TSSystem.replace((String)string, (String)"%JAVA_VERSION%", (String)System.getProperty("java.version"));
        final JDialog jDialog = new JDialog(Tomahawk.getInstance().getOwnerFrame(), Tomahawk.getResources().getStringResource("dialog.about.title"), true);
        JLabel jLabel = new JLabel(Tomahawk.getResources().getIconResource("dialog.about.icon", class$editor$Tomahawk == null ? (class$editor$Tomahawk = TomahawkActions.class$("editor.Tomahawk")) : class$editor$Tomahawk));
        jLabel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        int n = 0;
        int n2 = 0;
        Font font = new Font("Dialog", 0, 11);
        while (true) {
            String string3 = (n2 = string.indexOf("\n", n)) < 0 ? string.substring(n) : string.substring(n, n2);
            JLabel jLabel2 = new JLabel(string3);
            jLabel2.setFont(font);
            jLabel2.setForeground(Color.black);
            jLabel2.setAlignmentX(0.5f);
            jPanel.add(jLabel2);
            if (n2 < 0) break;
            n = n2 + 1;
        }
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(12, 20, 12, 20)));
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jPanel2.add((Component)jButton, "Center");
        JPanel jPanel3 = (JPanel)jDialog.getContentPane();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jLabel.setAlignmentX(0.5f);
        jPanel.setAlignmentX(0.5f);
        jPanel2.setAlignmentX(0.5f);
        jPanel3.add(jLabel);
        jPanel3.add(Box.createRigidArea(new Dimension(0, 6)));
        jPanel3.add(jPanel);
        jPanel3.add(Box.createRigidArea(new Dimension(0, 6)));
        jPanel3.add(jPanel2);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        jDialog.pack();
        jDialog.setLocationRelativeTo(SwingUtilities.getRootPane(Tomahawk.getInstance()));
        jDialog.setSize(310, jDialog.getHeight());
        jDialog.setResizable(false);
        jDialog.setVisible(true);
        Tomahawk.getInstance().repaint();
    }

    public void onHelpSupport() {
        try {
            URL uRL = new URL("http://www.tomsawyer.com/support");
            ((ExSelectTool)Tomahawk.getInstance().getGraphWindow().getDefaultTool()).onOpenURL(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (Tomahawk.getInstance().hasGraphWindow()) {
            Tomahawk.getInstance().getGraphWindow().getCanvas().requestFocus();
        }
        if (!"MOVE_DONE".equals(string)) {
            this.onAbortAction();
        }
        if (Tomahawk.getInstance().hasGraphWindow()) {
            if ("MOVE_LEFT".equals(string)) {
                Tomahawk.getInstance().getGraphWindow().move(3);
            } else if ("MOVE_RIGHT".equals(string)) {
                Tomahawk.getInstance().getGraphWindow().move(4);
            } else if ("MOVE_UP".equals(string)) {
                Tomahawk.getInstance().getGraphWindow().move(1);
            } else if ("MOVE_DOWN".equals(string)) {
                Tomahawk.getInstance().getGraphWindow().move(2);
            } else {
                Tomahawk.getInstance().getGraphWindow().finalizeMove();
            }
        }
        if ("ZOOM_CHANGE".equals(string) || "comboBoxEdited".equals(string)) {
            this.onZoomChange();
        } else if ("APP_SUPPORT".equals(string)) {
            this.onHelpSupport();
        } else if ("APP_ABOUT".equals(string)) {
            this.onHelpAbout();
        } else if ("APP_EXIT".equals(string)) {
            Tomahawk.getInstance().onAppExit();
        } else if ("CLEAR_ALL".equals(string)) {
            this.onClearAll();
        } else if ("CLEAR_HISTORY".equals(string)) {
            this.onClearHistory();
        } else if ("COPY_GRAPH".equals(string)) {
            this.onCopyGraph();
        } else if ("CUT_GRAPH".equals(string)) {
            this.onCutGraph();
        } else if ("HIDE_SELECTED".equals(string)) {
            this.onHideSelected();
        } else if ("FOLD_SELECTED".equals(string)) {
            this.onFoldSelected();
        } else if ("DELETE_SELECTED".equals(string)) {
            this.onDeleteSelected();
        } else if ("EXPAND_SELECTED".equals(string)) {
            this.onExpandSelected();
        } else if ("COLLAPSE_SELECTED".equals(string)) {
            this.onCollapseSelected();
        } else if ("DUPLICATE_GRAPH".equals(string)) {
            this.onDuplicateGraph();
        } else if ("LOAD_GRAPH".equals(string)) {
            Tomahawk.getInstance().onLoadGraph();
        } else if ("IMPORT_GRAPH".equals(string)) {
            Tomahawk.getInstance().onImportGraph();
        } else if ("EXPORT_GRAPH".equals(string)) {
            Tomahawk.getInstance().onExportGraph();
        } else if ("CLOSE_GRAPH".equals(string)) {
            Tomahawk.getInstance().onCloseGraph();
        } else if ("CLOSE_ALL_GRAPHS".equals(string)) {
            Tomahawk.getInstance().onCloseGraphs(null);
        } else if ("CLOSE_ALL_GRAPHS_BUT_THIS".equals(string)) {
            Tomahawk.getInstance().onCloseGraphs(Tomahawk.getInstance().getGraphWindow());
        } else if ("REVERT_GRAPH".equals(string)) {
            Tomahawk.getInstance().onRevertGraph();
        } else if ("SCROLL_LEFT".equals(string)) {
            this.onScrollGraph(37);
        } else if ("SCROLL_RIGHT".equals(string)) {
            this.onScrollGraph(39);
        } else if ("SCROLL_UP".equals(string)) {
            this.onScrollGraph(38);
        } else if ("SCROLL_DOWN".equals(string)) {
            this.onScrollGraph(40);
        } else if ("NEW_GRAPH".equals(string)) {
            Tomahawk.getInstance().onNewGraph();
        } else if ("OVERVIEW_WINDOW".equals(string)) {
            Tomahawk.getInstance().onShowOverviewWindow();
        } else if ("INSPECTOR_WINDOW".equals(string)) {
            Tomahawk.getInstance().onShowInspectorWindow();
        } else if ("CONSTRAINT_WINDOW".equals(string)) {
            Tomahawk.getInstance().onShowLayoutConstraintsDialog();
        } else if ("PALETTE_WINDOW".equals(string)) {
            Tomahawk.getInstance().onShowPalette();
        } else if ("PASTE_GRAPH".equals(string)) {
            this.onPasteGraph();
        } else if ("PRINT_SETUP".equals(string)) {
            Tomahawk.getInstance().onPrintSetup();
        } else if ("PRINT_PREVIEW".equals(string)) {
            Tomahawk.getInstance().onPrintPreview();
        } else if ("PRINT_GRAPH".equals(string)) {
            Tomahawk.getInstance().onPrintGraph();
        } else if ("REDO".equals(string)) {
            this.onRedoAction();
        } else if ("REFRESH_GRAPH".equals(string)) {
            this.onRefresh();
        } else if ("SAVE_GRAPH".equals(string)) {
            Tomahawk.getInstance().onSaveGraph();
        } else if ("SAVE_GRAPH_AS".equals(string)) {
            Tomahawk.getInstance().onSaveGraphAs(false);
        } else if ("SAVE_GRAPH_AS_IMAGE".equals(string)) {
            Tomahawk.getInstance().onSaveGraphAsImage();
        } else if ("SELECT_ALL".equals(string)) {
            this.onSelectAll();
        } else if ("SELECT_EDGES".equals(string)) {
            this.onSelectEdges();
        } else if ("SELECT_LABELS".equals(string)) {
            this.onSelectLabels();
        } else if ("SELECT_NODES".equals(string)) {
            this.onSelectNodes();
        } else if ("UNDO".equals(string)) {
            this.onUndoAction();
        } else if ("GOTO_PARENT".equals(string)) {
            this.onGoToParentGraph();
        } else if ("UNFOLD_ALL".equals(string)) {
            this.onUnfoldAll();
        } else if ("UNFOLD_SELECTED".equals(string)) {
            this.onUnfoldSelected();
        } else if ("UNHIDE_ALL".equals(string)) {
            this.onUnhideAll();
        } else if ("ZOOM_CUSTOM".equals(string)) {
            this.onCustomZoom();
        } else if ("ZOOM_FIT".equals(string)) {
            Tomahawk.getInstance().onFitInWindow();
        } else if ("AUTO_FIT".equals(string)) {
            Tomahawk.getInstance().onAutoFitInWindow();
        } else if ("RUN_MODE".equals(string)) {
            this.onRunMode();
        } else if ("ZOOM_IN".equals(string)) {
            this.onZoomIn();
        } else if ("ZOOM_OUT".equals(string)) {
            this.onZoomOut();
        } else if ("DOCKABLE_WINDOWS".equals(string)) {
            Tomahawk.getInstance().onDockableWindows();
        } else if ("TABBED_WINDOWS".equals(string)) {
            Tomahawk.getInstance().onSwitchMultipleWindowsStyle();
        } else if ("NEXT_WINDOW".equals(string)) {
            Tomahawk.getInstance().onNextWindow();
        } else if ("SELECT_TOOL".equals(string)) {
            this.onSwitchToSelect();
        } else if ("ZOOM_TOOL".equals(string)) {
            this.onSwitchToZoom();
        } else if ("INTERACTIVE_ZOOM_TOOL".equals(string)) {
            this.onSwitchToInteractiveZoom();
        } else if ("PAN_TOOL".equals(string)) {
            this.onSwitchToPan();
        } else if ("EDGE_NAVIGATION_TOOL".equals(string)) {
            this.onSwitchToLinkNavigation();
        } else if ("NEXT_TOOL".equals(string)) {
            this.onNextTool();
        } else if ("NEXT_TOOL_SET".equals(string)) {
            this.onNextToolSet();
        } else if (string.startsWith("CREATE_NODE_TOOL")) {
            Tomahawk.getInstance().onUseNewNodeUI(string);
        } else if (string.startsWith("CREATE_EDGE_TOOL")) {
            Tomahawk.getInstance().onUseNewEdgeUI(string);
        } else if (string.startsWith("APPLY_OPERATION")) {
            Tomahawk.getInstance().onApplyOperation(string, false);
        } else if (string.endsWith("INCREMENTAL_LAYOUT")) {
            this.onApplyIncrementalLayout();
        } else if (string.endsWith("RANDOM_LAYOUT")) {
            this.onApplyRandomLayout();
        } else if (string.startsWith("ZOOM")) {
            this.onZoom(string);
        } else if (string.startsWith("GRID_TYPE")) {
            this.onGridType(string);
        } else if ("GRID_SIZE_CUSTOM".equals(string)) {
            this.onCustomGridSize();
        } else if (string.startsWith("GRID_SIZE")) {
            this.onGridSize(string);
        } else if (string.startsWith("SNAP_TO_GRID")) {
            this.onSnapToGrid();
        } else if (string.startsWith("EXPAND_ALL")) {
            this.onExpandCollapseAll(true);
        } else if (string.startsWith("COLLAPSE_ALL")) {
            this.onExpandCollapseAll(false);
        } else if ("LAYOUT_PROPERTIES".equals(string)) {
            Tomahawk.getInstance().onLayoutProperties();
        } else if ("DRAWING_PREFERENCES".equals(string)) {
            Tomahawk.getInstance().onDrawingPreferences();
        } else if (!("MOVE_DONE".equals(string) || "MOVE_LEFT".equals(string) || "MOVE_RIGHT".equals(string) || "MOVE_UP".equals(string) || "MOVE_DOWN".equals(string) || "ACTION_ABORT".equals(string))) {
            System.out.println("Unhandled command: \"" + string + "\"");
        }
    }

    public void onDrawInvisibleOnDragging() {
        ExGraphWindow exGraphWindow;
        exGraphWindow.setDrawInvisibleOnDragging(!(exGraphWindow = Tomahawk.getInstance().getGraphWindow()).isDrawInvisibleOnDragging());
    }

    public void onApplyIncrementalLayout() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.INCREMENTAL_LAYOUT)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            Tomahawk tomahawk = Tomahawk.getInstance();
            TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData = tomahawk.getServiceInputData(tomahawk.getGraphWindow());
            TSGeneralLayoutInputTailor tSGeneralLayoutInputTailor = new TSGeneralLayoutInputTailor((TSServiceInputData)tSEAllOptionsServiceInputData, (TSDGraph)tomahawk.getGraph());
            String string = "APPLY_OPERATION.1000." + tSGeneralLayoutInputTailor.getLayoutStyle();
            Tomahawk.getInstance().setCursor(Cursor.getPredefinedCursor(3));
            Tomahawk.getInstance().getGraphWindow().setUserActionEnabled(false);
            Tomahawk.getInstance().onApplyLayout(string, true);
            Tomahawk.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            Tomahawk.getInstance().getGraphWindow().setUserActionEnabled(true);
        }
    }

    public void expandSelected() {
        Cursor cursor = Tomahawk.getInstance().getCursor();
        Tomahawk.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TSEExpandCommand tSEExpandCommand = new TSEExpandCommand((TSEGraph)Tomahawk.getInstance().getGraphManager().getMainDisplayGraph(), true);
        Tomahawk.getInstance().getGraphWindow().transmit((TSCommand)tSEExpandCommand);
        Tomahawk.getInstance().setCursor(cursor);
    }

    public void expandAll() {
        Cursor cursor = Tomahawk.getInstance().getCursor();
        Tomahawk.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TSEExpandCommand tSEExpandCommand = new TSEExpandCommand((TSEGraph)Tomahawk.getInstance().getGraphManager().getMainDisplayGraph(), true, true);
        Tomahawk.getInstance().getGraphWindow().transmit((TSCommand)tSEExpandCommand);
        Tomahawk.getInstance().setCursor(cursor);
    }

    public void collapseSelected() {
        Cursor cursor = Tomahawk.getInstance().getCursor();
        Tomahawk.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TSECollapseCommand tSECollapseCommand = new TSECollapseCommand((TSEGraph)Tomahawk.getInstance().getGraphManager().getMainDisplayGraph(), true);
        Tomahawk.getInstance().getGraphWindow().transmit((TSCommand)tSECollapseCommand);
        Tomahawk.getInstance().setCursor(cursor);
    }

    public void collapseAll() {
        Cursor cursor = Tomahawk.getInstance().getCursor();
        Tomahawk.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TSECollapseCommand tSECollapseCommand = new TSECollapseCommand((TSEGraph)Tomahawk.getInstance().getGraphManager().getMainDisplayGraph(), true, true);
        Tomahawk.getInstance().getGraphWindow().transmit((TSCommand)tSECollapseCommand);
        Tomahawk.getInstance().setCursor(cursor);
    }

    public void hideSelected() {
        JComponent jComponent = Tomahawk.getInstance().getGraphWindow().getCanvas();
        Cursor cursor = jComponent.getCursor();
        jComponent.setCursor(Cursor.getPredefinedCursor(3));
        TSEHideCommand tSEHideCommand = new TSEHideCommand((TSEGraph)Tomahawk.getInstance().getGraphManager().getMainDisplayGraph(), true);
        Tomahawk.getInstance().getGraphWindow().transmit((TSCommand)tSEHideCommand);
        jComponent.setCursor(cursor);
    }

    public void unhideAll() {
        JComponent jComponent = Tomahawk.getInstance().getGraphWindow().getCanvas();
        Cursor cursor = jComponent.getCursor();
        jComponent.setCursor(Cursor.getPredefinedCursor(3));
        TSEUnhideCommand tSEUnhideCommand = new TSEUnhideCommand((TSEGraph)Tomahawk.getInstance().getGraphManager().getMainDisplayGraph(), true);
        Tomahawk.getInstance().getGraphWindow().transmit((TSCommand)tSEUnhideCommand);
        jComponent.setCursor(cursor);
    }

    public void foldSelected() {
        JComponent jComponent = Tomahawk.getInstance().getGraphWindow().getCanvas();
        Cursor cursor = jComponent.getCursor();
        jComponent.setCursor(Cursor.getPredefinedCursor(3));
        TSEFoldCommand tSEFoldCommand = new TSEFoldCommand((TSEGraph)Tomahawk.getInstance().getGraphManager().getMainDisplayGraph(), true);
        Tomahawk.getInstance().getGraphWindow().transmit((TSCommand)tSEFoldCommand);
        jComponent.setCursor(cursor);
    }

    public void unfoldAll() {
        JComponent jComponent = Tomahawk.getInstance().getGraphWindow().getCanvas();
        Cursor cursor = jComponent.getCursor();
        jComponent.setCursor(Cursor.getPredefinedCursor(3));
        TSEUnfoldCommand tSEUnfoldCommand = new TSEUnfoldCommand((TSEGraph)Tomahawk.getInstance().getGraphManager().getMainDisplayGraph(), true, true);
        Tomahawk.getInstance().getGraphWindow().transmit((TSCommand)tSEUnfoldCommand);
        jComponent.setCursor(cursor);
    }

    public void unfoldSelected() {
        JComponent jComponent = Tomahawk.getInstance().getGraphWindow().getCanvas();
        Cursor cursor = jComponent.getCursor();
        jComponent.setCursor(Cursor.getPredefinedCursor(3));
        TSEUnfoldCommand tSEUnfoldCommand = new TSEUnfoldCommand((TSEGraph)Tomahawk.getInstance().getGraphManager().getMainDisplayGraph(), true);
        Tomahawk.getInstance().getGraphWindow().transmit((TSCommand)tSEUnfoldCommand);
        jComponent.setCursor(cursor);
    }

    public void onApplyRandomLayout() {
        ExGraphWindow exGraphWindow = Tomahawk.getInstance().getGraphWindow();
        Tomahawk.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        exGraphWindow.setUserActionEnabled(false);
        exGraphWindow.transmit((TSCommand)new TSERandomLayoutCommand(exGraphWindow.getGraphManager()));
        Tomahawk.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        exGraphWindow.setUserActionEnabled(true);
    }

    public void registerListeners() {
        ExGraphWindow exGraphWindow = Tomahawk.getInstance().getGraphWindow();
        TSEGraphManager tSEGraphManager = exGraphWindow.getGraphManager();
        TSEEventManager tSEEventManager = (TSEEventManager)tSEGraphManager.getEventManager();
        tSEEventManager.addGraphChangeListener((Object)tSEGraphManager, (EventListener)this);
        tSEEventManager.removeGraphChangeListener((Object)tSEGraphManager, (EventListener)this, 448L);
        tSEEventManager.addDrawingChangeListener((Object)tSEGraphManager, (EventListener)this);
        tSEEventManager.removeDrawingChangeListener((Object)tSEGraphManager, (EventListener)this, 896L);
        tSEEventManager.addComplexityChangeListener((Object)tSEGraphManager, (EventListener)this);
        tSEEventManager.addServiceInputChangeListener((Object)tSEGraphManager, (EventListener)this);
        tSEEventManager.addConstraintChangeListener((Object)tSEGraphManager, (EventListener)this);
        tSEEventManager.addSelectionChangeListener((Object)tSEGraphManager, (EventListener)this);
        tSEEventManager.addViewportChangeListener((Object)exGraphWindow, (EventListener)this, 1L);
        tSEEventManager.addPropertyChangeListener((Object)tSEGraphManager, (EventListener)this);
        tSEEventManager.addPreferenceChangeListener((Object)exGraphWindow, (EventListener)this);
        exGraphWindow.addCommandListener(this);
    }

    public void unregisterListeners() {
        ExGraphWindow exGraphWindow = Tomahawk.getInstance().getGraphWindow();
        exGraphWindow.getGraphManager().getEventManager().removeListener((EventListener)this);
        exGraphWindow.removeCommandListener(this);
    }

    public void drawingChanged(TSDrawingChangeEvent tSDrawingChangeEvent) {
        if (tSDrawingChangeEvent.getType() == 1L) {
            Tomahawk.getInstance().checkAllButtons();
        }
        super.drawingChanged(tSDrawingChangeEvent);
    }

    public void viewportChanged(TSEViewportChangeEvent tSEViewportChangeEvent) {
        if (tSEViewportChangeEvent.getType() == 1L) {
            Tomahawk.getInstance().updateZoomComboBox();
        }
    }

    public void selectionChanged(TSESelectionChangeEvent tSESelectionChangeEvent) {
        Tomahawk.getInstance().getGraphWindow().finalizeMove();
        Tomahawk.getInstance().checkAllButtons();
    }

    public void anyChange(TSEvent tSEvent) {
        Tomahawk.getInstance().setChanged(true);
    }

    public int listen(TSCommand tSCommand) {
        if (Tomahawk.getInstance().isAutoFitInWindow()) {
            Tomahawk.getInstance().getGraphWindow().fitInWindow(true);
        }
        return 1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

