/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby;

import java.awt.Dialog;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.derby.DerbyOptions;
import org.netbeans.modules.derby.RegisterDerby;
import org.netbeans.modules.derby.Util;
import org.netbeans.modules.derby.ui.CreateDatabasePanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public class CreateDatabaseAction
extends CallableSystemAction {
    public CreateDatabaseAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public void performAction() {
        if (!Util.checkInstallLocation()) {
            return;
        }
        if (!Util.ensureSystemHome()) {
            return;
        }
        String string = DerbyOptions.getDefault().getSystemHome();
        CreateDatabasePanel createDatabasePanel = new CreateDatabasePanel(string);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)createDatabasePanel, NbBundle.getMessage(CreateDatabaseAction.class, (String)"LBL_CreateDatabaseTitle"), true, null);
        createDatabasePanel.setDialogDescriptor(dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        String string2 = NbBundle.getMessage(CreateDatabaseAction.class, (String)"ACSD_CreateDatabaseAction");
        dialog.getAccessibleContext().setAccessibleDescription(string2);
        dialog.setVisible(true);
        dialog.dispose();
        if (!DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
            return;
        }
        String string3 = createDatabasePanel.getDatabaseName();
        String string4 = createDatabasePanel.getUser();
        String string5 = createDatabasePanel.getPassword();
        if (string4 == null || string5 == null) {
            string4 = null;
            string5 = null;
        }
        try {
            this.makeDatabase(string3, string4, string5);
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.WARNING, null, exception);
        }
    }

    void makeDatabase(String string, String string2, String string3) throws Exception {
        RegisterDerby.getDefault().postCreateNewDatabase(string, string2, string3);
    }

    protected boolean asynchronous() {
        return false;
    }

    public boolean isEnabled() {
        return Util.hasInstallLocation();
    }

    public String getName() {
        return NbBundle.getBundle(CreateDatabaseAction.class).getString("LBL_CreateDBAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CreateDatabaseAction.class);
    }
}

