/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.execution;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;

final class OutputStreamWriter
extends Writer {
    private PrintStream out;

    public OutputStreamWriter(PrintStream printStream) {
        super(printStream);
        if (printStream == null) {
            throw new NullPointerException();
        }
        this.out = printStream;
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException();
        }
    }

    public void write(int n) throws IOException {
        char[] cArray = new char[]{(char)n};
        this.write(cArray, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (n == 0 && n2 == cArray.length) {
                this.out.print(cArray);
            } else {
                char[] cArray2 = new char[n2];
                System.arraycopy(cArray, n, cArray2, 0, n2);
                this.out.print(cArray2);
            }
        }
    }

    public void write(String string, int n, int n2) throws IOException {
        char[] cArray = new char[n2];
        string.getChars(n, n + n2, cArray, 0);
        this.out.print(cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                return;
            }
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                return;
            }
            this.flush();
            this.out.close();
            this.out = null;
        }
    }
}

