/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sql.rowset.internal;

import com.sun.rowset.internal.BaseRow;
import com.sun.sql.rowset.CachedRowSetXImpl;
import com.sun.sql.rowset.RowSetMetaDataXImpl;
import com.sun.sql.rowset.SyncResolverX;
import com.sun.sql.rowset.internal.CachedRowSetXWriter;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetMetaData;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.spi.SyncProvider;
import javax.sql.rowset.spi.SyncProviderException;

public class SyncResolverXImpl
extends CachedRowSetXImpl
implements SyncResolverX {
    private static ResourceBundle rb = ResourceBundle.getBundle("com.sun.sql.rowset.internal.Bundle", Locale.getDefault());
    private CachedRowSetXImpl crsRes;
    private CachedRowSetXImpl crsSync = CachedRowSetXImpl.createInternalUseInstance();
    private ArrayList stats;
    private ArrayList exceptions;
    private CachedRowSetXWriter crw;
    private int rowStatus = 1;
    private int sz;
    private Connection con;
    private CachedRowSet row;

    public SyncResolverXImpl() {
        this.crsRes = CachedRowSetXImpl.createInternalUseInstance();
        this.crw = new CachedRowSetXWriter();
        this.row = CachedRowSetXImpl.createInternalUseInstance();
    }

    public int getStatus() {
        return (Integer)this.stats.get(this.rowStatus - 1);
    }

    public SQLException getSQLException() {
        return (SQLException)this.exceptions.get(this.rowStatus - 1);
    }

    public Object getConflictValue(int index) throws SQLException {
        try {
            return this.crsRes.getObject(index);
        }
        catch (SQLException sqle) {
            throw new SQLException(sqle.getMessage());
        }
    }

    public Object getConflictValue(String columnName) throws SQLException {
        try {
            return this.crsRes.getObject(columnName);
        }
        catch (SQLException sqle) {
            throw new SQLException(sqle.getMessage());
        }
    }

    public void setResolvedValue(int index, Object obj) throws SQLException {
        block11: {
            try {
                if (index <= 0 || index > this.crsSync.getMetaData().getColumnCount()) {
                    throw new SQLException(MessageFormat.format(rb.getString("INDEX_VALUE_OUT_OF_RANGE"), new Integer(index)));
                }
                if (this.crsRes.getObject(index) == null) {
                    throw new SQLException(MessageFormat.format(rb.getString("COLUMN_NOT_IN_CONFLICT"), new Integer(index)));
                }
            }
            catch (SQLException sqle) {
                throw new SQLException(sqle.getMessage());
            }
            try {
                boolean bool = true;
                if (this.crsSync.getObject(index).toString().equals(obj.toString()) || this.crsRes.getObject(index).toString().equals(obj.toString())) {
                    this.crsRes.updateNull(index);
                    this.crsRes.updateRow();
                    if (this.row.size() != 1) {
                        this.row = this.buildCachedRow();
                    }
                    this.row.updateObject(index, obj);
                    this.row.updateRow();
                    for (int j = 1; j < this.crsRes.getMetaData().getColumnCount(); ++j) {
                        if (this.crsRes.getObject(j) == null) continue;
                        bool = false;
                        break;
                    }
                    if (!bool) break block11;
                    try {
                        this.writeData(this.row);
                        break block11;
                    }
                    catch (SyncProviderException spe) {
                        throw new SQLException(rb.getString("SYNC_NOT_POSSIBLE"));
                    }
                }
                throw new SQLException(rb.getString("VALUE_TO_BE_RESOLVED_CAN_BE"));
            }
            catch (SQLException sqle) {
                throw new SQLException(sqle.getMessage());
            }
        }
    }

    private void writeData(CachedRowSet row) throws SQLException {
        this.crw.updateResolvedConflictToDB(row, this.crw.getReader().connect(this.crsSync));
    }

    private CachedRowSet buildCachedRow() throws SQLException {
        CachedRowSetXImpl crsRow = CachedRowSetXImpl.createInternalUseInstance();
        RowSetMetaDataXImpl rsmd = new RowSetMetaDataXImpl();
        RowSetMetaDataXImpl rsmdWrite = (RowSetMetaDataXImpl)this.crsSync.getMetaData();
        RowSetMetaDataXImpl rsmdRow = new RowSetMetaDataXImpl();
        int iColCount = rsmdWrite.getColumnCount();
        rsmdRow.setColumnCount(iColCount);
        for (int i = 1; i <= iColCount; ++i) {
            rsmdRow.setColumnType(i, rsmdWrite.getColumnType(i));
            rsmdRow.setColumnName(i, rsmdWrite.getColumnName(i));
            rsmdRow.setNullable(i, 2);
            try {
                rsmdRow.setCatalogName(i, rsmdWrite.getCatalogName(i));
                rsmdRow.setSchemaName(i, rsmdWrite.getSchemaName(i));
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        crsRow.setMetaData(rsmdRow);
        crsRow.moveToInsertRow();
        for (int col = 1; col <= this.crsSync.getMetaData().getColumnCount(); ++col) {
            crsRow.updateObject(col, this.crsSync.getObject(col));
        }
        crsRow.insertRow();
        crsRow.moveToCurrentRow();
        crsRow.absolute(1);
        crsRow.setOriginalRow();
        try {
            crsRow.setUrl(this.crsSync.getUrl());
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        try {
            crsRow.setDataSourceName(this.crsSync.getCommand());
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        try {
            if (this.crsSync.getTableName() != null) {
                crsRow.setTableName(this.crsSync.getTableName());
            }
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        try {
            crsRow.setCommand(this.crsSync.getCommand());
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        try {
            crsRow.setKeyColumns(this.crsSync.getKeyColumns());
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        return crsRow;
    }

    public void setResolvedValue(String columnName, Object obj) throws SQLException {
    }

    void setCachedRowSet(CachedRowSet crs) {
        this.crsSync = (CachedRowSetXImpl)crs;
    }

    void setCachedRowSetResolver(CachedRowSet crs) {
        try {
            this.crsRes = (CachedRowSetXImpl)crs;
            this.crsRes.afterLast();
            this.sz = this.crsRes.size();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    void setStatus(ArrayList status) {
        this.stats = status;
    }

    void setExceptions(ArrayList exceptions) {
        this.exceptions = exceptions;
    }

    void setCachedRowSetXWriter(CachedRowSetXWriter CRWriter) {
        this.crw = CRWriter;
    }

    public boolean nextConflict() throws SQLException {
        boolean bool = false;
        while (this.crsSync.next()) {
            this.crsRes.previous();
            ++this.rowStatus;
            if (this.rowStatus - 1 >= this.stats.size()) {
                bool = false;
                break;
            }
            if ((Integer)this.stats.get(this.rowStatus - 1) == 3) continue;
            bool = true;
            break;
        }
        return bool;
    }

    public boolean previousConflict() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setCommand(String cmd) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void populate(ResultSet data) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void execute(Connection conn) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void acceptChanges() throws SyncProviderException {
        throw new UnsupportedOperationException();
    }

    public void acceptChanges(Connection con) throws SyncProviderException {
        throw new UnsupportedOperationException();
    }

    public void restoreOriginal() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void release() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void undoDelete() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void undoInsert() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void undoUpdate() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public RowSet createShared() throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new UnsupportedOperationException();
    }

    public CachedRowSet createCopy() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public CachedRowSet createCopySchema() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public CachedRowSet createCopyNoConstraints() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Collection toCollection() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Collection toCollection(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Collection toCollection(String column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public SyncProvider getSyncProvider() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setSyncProvider(String providerStr) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void execute() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean next() throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected boolean internalNext() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void close() {
        throw new UnsupportedOperationException();
    }

    public boolean wasNull() throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected BaseRow getCurrentRow() {
        throw new UnsupportedOperationException();
    }

    protected void removeCurrentRow() {
        throw new UnsupportedOperationException();
    }

    public String getString(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public byte getByte(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public short getShort(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getInt(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public long getLong(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public float getFloat(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public double getDouble(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getString(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public byte getByte(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public short getShort(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getInt(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public long getLong(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public float getFloat(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public double getDouble(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public byte[] getBytes(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public SQLWarning getWarnings() {
        throw new UnsupportedOperationException();
    }

    public void clearWarnings() {
        throw new UnsupportedOperationException();
    }

    public String getCursorName() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int findColumn(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int size() {
        throw new UnsupportedOperationException();
    }

    public boolean isBeforeFirst() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isAfterLast() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isFirst() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isLast() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void beforeFirst() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void afterLast() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean first() throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected boolean internalFirst() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean last() throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected boolean internalLast() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getRow() throws SQLException {
        return this.crsSync.getRow();
    }

    public boolean absolute(int row) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean relative(int rows) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean previous() throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected boolean internalPrevious() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean rowUpdated() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean columnUpdated(int idx) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean columnUpdated(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean rowInserted() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean rowDeleted() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateNull(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateNull(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateShort(String columnName, short x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateInt(String columnName, int x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateLong(String columnName, long x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateString(String columnName, String x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void insertRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void refreshRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void moveToCurrentRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Statement getStatement() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(int columnIndex, Map map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Ref getRef(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Clob getClob(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Array getArray(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Ref getRef(String colName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Blob getBlob(String colName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Clob getClob(String colName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Array getArray(String colName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Connection getConnection() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setMetaData(RowSetMetaData md) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getOriginal() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getOriginalRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setOriginalRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setOriginal() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getTableName() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setTableName(String tabName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int[] getKeyColumns() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setKeyColumns(int[] keys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateRef(int columnIndex, Ref ref) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateRef(String columnName, Ref ref) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateClob(int columnIndex, Clob c) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateClob(String columnName, Clob c) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBlob(int columnIndex, Blob b) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBlob(String columnName, Blob b) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateArray(int columnIndex, Array a) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateArray(String columnName, Array a) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public URL getURL(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public URL getURL(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public RowSetWarning getRowSetWarnings() {
        throw new UnsupportedOperationException();
    }

    public void commit() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void rollback() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void rollback(Savepoint s) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void unsetMatchColumn(int[] columnIdxes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void unsetMatchColumn(String[] columnIdxes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String[] getMatchColumnNames() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int[] getMatchColumnIndexes() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setMatchColumn(int[] columnIdxes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setMatchColumn(String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setMatchColumn(int columnIdx) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setMatchColumn(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void unsetMatchColumn(int columnIdx) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void unsetMatchColumn(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void rowSetPopulated(RowSetEvent event, int numRows) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void populate(ResultSet data, int start) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean nextPage() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setPageSize(int size) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getPageSize() {
        throw new UnsupportedOperationException();
    }

    public boolean previousPage() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object unwrap(Class arg0) throws SQLException {
        return null;
    }
}

