/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs.statistics;

import java.io.PrintStream;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseStatistics<K extends Comparable> {
    protected int min = 0;
    protected int max = 0;
    protected int cnt = 0;
    protected int sum;
    protected String text;
    protected Map<K, Integer> values;
    protected int level;
    public static final int LEVEL_NONE = 0;
    public static final int LEVEL_MINUMUN = 1;
    public static final int LEVEL_MEDIUM = 2;
    public static final int LEVEL_MAXIMUM = 3;

    public BaseStatistics(String string, int n) {
        this.text = string;
        this.level = n;
        if (n > 1) {
            this.values = new TreeMap<K, Integer>();
        }
    }

    public void consume(K k, int n) {
        if (n > this.max) {
            this.max = n;
        }
        if (n < this.min) {
            this.min = n;
        }
        ++this.cnt;
        this.sum += n;
        if (this.values != null) {
            Integer n2 = this.values.get(k);
            this.values.put(k, n2 == null ? 1 : n2 + 1);
        }
    }

    public void print(PrintStream printStream) {
        int n = this.cnt == 0 ? 0 : this.sum / this.cnt;
        printStream.printf("%s %8d min    %8d max    %8d avg    %8d cnt    %8d sum\n", this.text, this.min, this.max, n, this.cnt, this.sum);
        if (this.values != null) {
            this.printDistribution(printStream);
        }
    }

    protected void printDistributionDetailed(PrintStream printStream) {
        int n = 0;
        String string = "-";
        for (Map.Entry<K, Integer> entry : this.values.entrySet()) {
            int n2;
            Comparable object = (Comparable)entry.getKey();
            if (object == null) {
                n2 = 4;
            } else {
                if (object instanceof Number) {
                    n = 8;
                    string = "";
                    break;
                }
                n2 = object.toString().length();
            }
            if (n2 <= n) continue;
            n = n2;
        }
        String string2 = "\t%" + string + n + "s %8d\n";
        for (Map.Entry entry : this.values.entrySet()) {
            printStream.printf(string2, entry.getKey(), entry.getValue());
        }
    }

    protected void printDistribution(PrintStream printStream) {
        printStream.printf("\tDistribution:\n", new Object[0]);
        this.printDistributionDetailed(printStream);
    }
}

