/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.netbeans.modules.cnd.repository.disk.MemoryCache;
import org.netbeans.modules.cnd.repository.disk.MultyFileStorage;
import org.netbeans.modules.cnd.repository.disk.Storage;
import org.netbeans.modules.cnd.repository.disk.StorageAllocator;
import org.netbeans.modules.cnd.repository.disk.Unit;
import org.netbeans.modules.cnd.repository.sfs.FileStorage;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.util.Pair;

public class UnitImpl
implements Unit {
    private Storage singleFileStorage;
    private Storage multyFileStorage;
    private String unitName;
    MemoryCache cache;

    public UnitImpl(String string) throws IOException {
        assert (string != null);
        this.unitName = string;
        this.singleFileStorage = FileStorage.create(new File(StorageAllocator.getInstance().getUnitStorageName(string)));
        this.multyFileStorage = new MultyFileStorage(this.getName());
        this.cache = new MemoryCache();
    }

    private Storage getStorage(Key key) {
        assert (key != null);
        assert (this.getName().equals(((Object)key.getUnit()).toString()));
        if (key.getBehavior() == Key.Behavior.Default) {
            return this.singleFileStorage;
        }
        return this.multyFileStorage;
    }

    public Persistent get(Key key) throws IOException {
        assert (key != null);
        assert (this.getName().equals(((Object)key.getUnit()).toString()));
        Persistent persistent = this.cache.get(key);
        if (persistent == null && (persistent = this.getStorage(key).read(key)) != null) {
            this.cache.put(key, persistent, false);
        }
        return persistent;
    }

    public void putToCache(Key key, Persistent persistent) {
        assert (key != null);
        assert (this.getName().equals(((Object)key.getUnit()).toString()));
        this.cache.put(key, persistent, true);
    }

    public void hang(Key key, Persistent persistent) {
        assert (key != null);
        assert (this.getName().equals(((Object)key.getUnit()).toString()));
        this.cache.hang(key, persistent);
    }

    public Persistent tryGet(Key key) {
        assert (key != null);
        assert (this.getName().equals(((Object)key.getUnit()).toString()));
        return this.cache.get(key);
    }

    public void removePhysically(Key key) throws IOException {
        assert (key != null);
        assert (this.getName().equals(((Object)key.getUnit()).toString()));
        this.getStorage(key).remove(key);
    }

    public void removeFromCache(Key key) {
        assert (key != null);
        assert (this.getName().equals(((Object)key.getUnit()).toString()));
        this.cache.remove(key);
    }

    public void close() throws IOException {
        Collection<Pair<Key, Persistent>> collection = this.cache.clearHungObjects();
        for (Pair<Key, Persistent> pair : collection) {
            this.putPhysically((Key)pair.first, (Persistent)pair.second);
        }
        this.singleFileStorage.close();
        this.multyFileStorage.close();
    }

    public void putPhysically(Key key, Persistent persistent) throws IOException {
        assert (key != null);
        assert (this.getName().equals(((Object)key.getUnit()).toString()));
        assert (persistent != null);
        this.getStorage(key).write(key, persistent);
    }

    public boolean maintenance(long l) throws IOException {
        return this.singleFileStorage.defragment(l);
    }

    public int getMaintenanceWeight() throws IOException {
        return this.singleFileStorage.getFragmentationPercentage();
    }

    public String getName() {
        return this.unitName;
    }

    public void debugClear() {
        this.cache.clearSoftRefs();
    }
}

