/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Color;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.KeyStroke;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.modules.editor.FormatterIndentEngine;
import org.netbeans.modules.editor.IndentEngineFormatter;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.SimpleIndentEngine;
import org.netbeans.modules.editor.lib.ColoringMap;
import org.netbeans.modules.editor.lib.KitsTracker;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.MIMEOptionFolder;
import org.netbeans.modules.editor.options.MIMEOptionNode;
import org.netbeans.modules.editor.options.OptionSupport;
import org.netbeans.modules.editor.options.OptionUtilities;
import org.openide.ServiceType;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.IndentEngine;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseOptions
extends OptionSupport {
    private static final Logger LOG = Logger.getLogger(BaseOptions.class.getName());
    protected static final int LATEST_OPTIONS_VERSION = 21;
    protected static final String OPTIONS_VERSION_PROP = "optionsVersion";
    public static final String ABBREV_MAP_PROP = "abbrevMap";
    public static final String BASE = "base";
    public static final String CARET_BLINK_RATE_PROP = "caretBlinkRate";
    public static final String CARET_COLOR_INSERT_MODE_PROP = "caretColorInsertMode";
    public static final String CARET_COLOR_OVERWRITE_MODE_PROP = "caretColorOverwriteMode";
    public static final String CARET_ITALIC_INSERT_MODE_PROP = "caretItalicInsertMode";
    public static final String CARET_ITALIC_OVERWRITE_MODE_PROP = "caretItalicOverwriteMode";
    public static final String CARET_TYPE_INSERT_MODE_PROP = "caretTypeInsertMode";
    public static final String CARET_TYPE_OVERWRITE_MODE_PROP = "caretTypeOverwriteMode";
    public static final String COLORING_MAP_PROP = "coloringMap";
    public static final String EXPAND_TABS_PROP = "expandTabs";
    public static final String FIND_HIGHLIGHT_SEARCH_PROP = "findHighlightSearch";
    public static final String FIND_HISTORY_PROP = "findHistory";
    public static final String FIND_HISTORY_SIZE_PROP = "findHistorySize";
    public static final String FIND_INC_SEARCH_DELAY_PROP = "findIncSearchDelay";
    public static final String FIND_INC_SEARCH_PROP = "findIncSearch";
    public static final String FIND_MATCH_CASE_PROP = "findMatchCase";
    public static final String FIND_REG_EXP_PROP = "findRegExp";
    public static final String FIND_SMART_CASE_PROP = "findSmartCase";
    public static final String FIND_WHOLE_WORDS_PROP = "findWholeWords";
    public static final String FIND_WRAP_SEARCH_PROP = "findWrapSearch";
    public static final String FIND_BLOCK_SEARCH_PROP = "findBlockSearch";
    public static final String FONT_SIZE_PROP = "fontSize";
    public static final String HIGHLIGHT_CARET_ROW_PROP = "highlightCaretRow";
    public static final String HIGHLIGHT_MATCHING_BRACKET_PROP = "highlightMatchingBracket";
    public static final String INDENT_ENGINE_PROP = "indentEngine";
    public static final String KEY_BINDING_LIST_PROP = "keyBindingList";
    public static final String LINE_HEIGHT_CORRECTION_PROP = "lineHeightCorrection";
    public static final String LINE_NUMBER_VISIBLE_PROP = "lineNumberVisible";
    public static final String MACRO_MAP_PROP = "macroMap";
    public static final String MARGIN_PROP = "margin";
    public static final String PAIR_CHARACTERS_COMPLETION = "pairCharactersCompletion";
    public static final String SCROLL_FIND_INSETS_PROP = "scrollFindInsets";
    public static final String SCROLL_JUMP_INSETS_PROP = "scrollJumpInsets";
    public static final String SPACES_PER_TAB_PROP = "spacesPerTab";
    public static final String STATUS_BAR_CARET_DELAY_PROP = "statusBarCaretDelay";
    public static final String STATUS_BAR_VISIBLE_PROP = "statusBarVisible";
    public static final String TAB_SIZE_PROP = "tabSize";
    public static final String TEXT_LIMIT_LINE_COLOR_PROP = "textLimitLineColor";
    public static final String TEXT_LIMIT_LINE_VISIBLE_PROP = "textLimitLineVisible";
    public static final String TEXT_LIMIT_WIDTH_PROP = "textLimitWidth";
    public static final String TOOLBAR_VISIBLE_PROP = "toolbarVisible";
    public static final String TEXT_ANTIALIASING_PROP = "textAntialiasing";
    public static final String CODE_FOLDING_PROPS_PROP = "codeFoldingProps";
    protected static final String[] BASE_PROP_NAMES = new String[]{"abbrevMap", "caretBlinkRate", "caretColorInsertMode", "caretColorOverwriteMode", "caretItalicInsertMode", "caretItalicOverwriteMode", "caretTypeInsertMode", "caretTypeOverwriteMode", "coloringMap", "expandTabs", "fontSize", "highlightCaretRow", "highlightMatchingBracket", "indentEngine", "keyBindingList", "lineHeightCorrection", "macroMap", "margin", "pairCharactersCompletion", "scrollFindInsets", "scrollJumpInsets", "spacesPerTab", "statusBarCaretDelay", "statusBarVisible", "tabSize", "textLimitLineColor", "textLimitLineVisible", "textLimitWidth", "optionsVersion"};
    static final long serialVersionUID = -5469192431366914841L;
    private static final String NO_INDENT_ENGINE = "NO_INDENT_ENGINE";
    private transient int optionsVersion = 21;
    private transient MIMEOptionNode mimeNode;
    private transient MIMEOptionFolder settingsFolder;
    private transient boolean settingsFolderInitialization;
    private static final HashMap kitClass2Options = new HashMap();
    public static final String CODE_TEMPLATE_EXPAND_KEY = "code-template-expand-key";
    private static Object gaspConst = RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;

    public BaseOptions() {
        this(BaseKit.class, BASE);
    }

    public BaseOptions(Class clazz, String string) {
        super(clazz, string);
        kitClass2Options.put(clazz, this);
    }

    public static BaseOptions getOptions(Class clazz) {
        Class clazz2;
        BaseOptions baseOptions = null;
        if (clazz != BaseKit.class && clazz != NbEditorKit.class && (clazz2 = KitsTracker.getInstance().findMimeType(clazz)) != null) {
            Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.parse((String)((Object)clazz2)));
            baseOptions = (BaseOptions)((Object)lookup.lookup(BaseOptions.class));
        }
        if (baseOptions == null) {
            for (clazz2 = clazz; clazz2 != null && (baseOptions = (BaseOptions)((Object)kitClass2Options.get(clazz2))) == null; clazz2 = clazz2.getSuperclass()) {
                AllOptionsFolder.getDefault().loadMIMEOption(clazz2, false);
                baseOptions = (BaseOptions)((Object)kitClass2Options.get(clazz2));
                if (baseOptions != null) break;
            }
        }
        return baseOptions;
    }

    private String getCTImpl() {
        String string = this.getContentType();
        if (string == null) {
            String string2 = "Can't determine mime type for " + BaseOptions.simpleToString((Object)this) + "; kitClass = " + this.getKitClass();
            LOG.log(Level.WARNING, null, new Throwable(string2));
            string = "text/plain";
        }
        return string;
    }

    private static String simpleToString(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(object));
    }

    @Override
    protected void updateSettingsMap(Class clazz, Map map) {
        this.loadXMLSettings();
        super.updateSettingsMap(clazz, map);
        if (clazz == this.getKitClass()) {
            map.put(INDENT_ENGINE_PROP, new Settings.Evaluator(){

                public Object getValue(Class clazz, String string) {
                    return BaseOptions.this.getIndentEngine();
                }
            });
            map.put("formatter", new Settings.Evaluator(){

                public Object getValue(Class clazz, String string) {
                    IndentEngine indentEngine = BaseOptions.this.getIndentEngine();
                    return indentEngine != null ? (indentEngine instanceof FormatterIndentEngine ? ((FormatterIndentEngine)indentEngine).getFormatter() : new IndentEngineFormatter(BaseOptions.this.getKitClass(), indentEngine)) : null;
                }
            });
            map.put("rendering-hints", new Settings.Evaluator(){

                public Object getValue(Class clazz, String string) {
                    return BaseOptions.this.computeTextAntialiasingMap(BaseOptions.this.isTextAntialiasing());
                }
            });
        }
    }

    public boolean isTextAntialiasing() {
        Boolean bl = (Boolean)this.getSettingValue(TEXT_ANTIALIASING_PROP);
        if (bl != null) {
            return bl;
        }
        if (Boolean.getBoolean("javax.aatext")) {
            return true;
        }
        if (Utilities.isMac()) {
            return true;
        }
        return BaseOptions.isSystemAntialias();
    }

    private static boolean isSystemAntialias() {
        Map map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (map != null) {
            Object v = map.get(RenderingHints.KEY_TEXT_ANTIALIASING);
            boolean bl = v != null && v != RenderingHints.VALUE_TEXT_ANTIALIAS_OFF && v != RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
            return bl;
        }
        return false;
    }

    public void setTextAntialiasing(boolean bl) {
        this.setSettingBoolean(TEXT_ANTIALIASING_PROP, bl, TEXT_ANTIALIASING_PROP);
        Settings.touchValue((Class)this.getKitClass(), (String)"rendering-hints");
    }

    private Map computeTextAntialiasingMap(boolean bl) {
        Map map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (map != null) {
            return map;
        }
        if (!bl) {
            return Collections.EMPTY_MAP;
        }
        HashMap<RenderingHints.Key, Object> hashMap = new HashMap<RenderingHints.Key, Object>();
        hashMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return hashMap;
    }

    private boolean isGasp(Object object) {
        if (gaspConst == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF) {
            try {
                Field field = RenderingHints.class.getField("VALUE_TEXT_ANTIALIAS_GASP");
                gaspConst = field.get(null);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                gaspConst = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                gaspConst = null;
            }
        }
        return object == gaspConst;
    }

    public static void setCodeTemplateExpandKey(KeyStroke keyStroke) {
        Settings.setValue(BaseKit.class, (String)CODE_TEMPLATE_EXPAND_KEY, (Object)Utilities.keyToString((KeyStroke)keyStroke));
    }

    public static KeyStroke getCodeTemplateExpandKey() {
        KeyStroke keyStroke;
        String string = (String)Settings.getValue(BaseKit.class, (String)CODE_TEMPLATE_EXPAND_KEY);
        if (string != null && (keyStroke = Utilities.stringToKey((String)string)) != null) {
            return keyStroke;
        }
        return KeyStroke.getKeyStroke(9, 0);
    }

    public Map<String, String> getDefaultAbbrevMap() {
        return this.getAbbrevMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getAbbrevMap() {
        boolean bl = this.setContextMimeType();
        try {
            Map map;
            Map map2 = map = (Map)Settings.getValue((Class)this.getKitClass(), (String)"abbrev-map", (boolean)true);
            return map2;
        }
        finally {
            if (bl) {
                this.resetContextMimeType();
            }
        }
    }

    public void setAbbrevMap(Map<String, String> map, boolean bl) {
    }

    public void setAbbrevMap(Map map) {
        this.setAbbrevMap(map, true);
    }

    public Map<String, MultiKeyBinding> getDefaultKeyBindingsMap() {
        return OptionUtilities.makeKeyBindingsMap(this.getKBList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<? extends MultiKeyBinding> getKBList() {
        boolean bl = this.setContextMimeType();
        try {
            List list;
            List list2 = list = (List)Settings.getValue((Class)this.getKitClass(), (String)"key-bindings", (boolean)true);
            return list2;
        }
        finally {
            if (bl) {
                this.resetContextMimeType();
            }
        }
    }

    public List getKeyBindingList() {
        ArrayList<? extends MultiKeyBinding> arrayList = new ArrayList<MultiKeyBinding>(this.getKBList());
        arrayList.add(0, (MultiKeyBinding)this.getKitClass().getName());
        return arrayList;
    }

    public void setKeyBindingList(List list) {
        this.setKeyBindingList(list, true);
    }

    public void setKeyBindingsDiffMap(Map<String, MultiKeyBinding> map) {
    }

    public void setKeyBindingList(List list, boolean bl) {
    }

    public Map<String, Coloring> getColoringMap() {
        return new HashMap<String, Coloring>(ColoringMap.get((String)this.getContentType()).getMap());
    }

    public void setColoringMap(Map map) {
        this.setColoringMap(map, true);
    }

    public void setColoringMap(final Map<String, Coloring> map, boolean bl) {
        if (map != null) {
            Settings.update((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    boolean bl = BaseOptions.this.setContextMimeType();
                    try {
                        SettingsUtil.setColoringMap((Class)BaseOptions.this.getKitClass(), (Map)map, (boolean)false);
                    }
                    finally {
                        if (bl) {
                            BaseOptions.this.resetContextMimeType();
                        }
                    }
                }
            });
        }
    }

    public int getFontSize() {
        Coloring coloring = SettingsUtil.getColoring((Class)this.getKitClass(), (String)"default", (boolean)false);
        return coloring != null ? coloring.getFont().getSize() : SettingsDefaults.defaultFont.getSize();
    }

    public void setFontSize(int n) {
    }

    public float getLineHeightCorrection() {
        return ((Float)this.getSettingValue("line-height-correction")).floatValue();
    }

    public void setLineHeightCorrection(float f) {
        if (f <= 0.0f) {
            NbEditorUtilities.invalidArgument("MSG_OutOfRange");
            return;
        }
        this.setSettingValue("line-height-correction", new Float(f), LINE_HEIGHT_CORRECTION_PROP);
    }

    public Map getDefaultMacrosMap() {
        return this.getMacroMap();
    }

    public Map getMacroMap() {
        Map map = (Map)super.getSettingValue("macro-map");
        HashMap<Object, List<? extends MultiKeyBinding>> hashMap = map == null ? new HashMap<Object, List<? extends MultiKeyBinding>>() : new HashMap(map);
        hashMap.put(null, this.getKBList());
        return hashMap;
    }

    public void setMacroDiffMap(Map map) {
    }

    public void setMacroMap(final Map map, boolean bl) {
        if (map != null) {
            Settings.update((Runnable)new Runnable(){

                public void run() {
                    BaseOptions.super.setSettingValue("macro-map", map);
                }
            });
        }
    }

    public void setMacroMap(Map map) {
        this.setMacroMap(map, true);
    }

    public int getTabSize() {
        return this.getSettingInteger("tab-size");
    }

    public void setTabSize(int n) {
        if (n < 0) {
            NbEditorUtilities.invalidArgument("MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("tab-size", n, TAB_SIZE_PROP);
    }

    public void setExpandTabs(boolean bl) {
        this.setSettingBoolean("expand-tabs", bl, EXPAND_TABS_PROP);
    }

    public void setSpacesPerTab(int n) {
        if (n > 0) {
            this.setSettingInteger("spaces-per-tab", n, SPACES_PER_TAB_PROP);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public String getCaretTypeInsertMode() {
        return (String)this.getSettingValue("caret-type-insert-mode");
    }

    public void setCaretTypeInsertMode(String string) {
        this.setSettingValue("caret-type-insert-mode", string, CARET_TYPE_INSERT_MODE_PROP);
    }

    public String getCaretTypeOverwriteMode() {
        return (String)this.getSettingValue("caret-type-overwrite-mode");
    }

    public void setCaretTypeOverwriteMode(String string) {
        this.setSettingValue("caret-type-overwrite-mode", string, CARET_TYPE_OVERWRITE_MODE_PROP);
    }

    public boolean getCaretItalicInsertMode() {
        return false;
    }

    public void setCaretItalicInsertMode(boolean bl) {
        this.setSettingBoolean("caret-italic-insert-mode", bl, CARET_ITALIC_INSERT_MODE_PROP);
    }

    public boolean getCaretItalicOverwriteMode() {
        return false;
    }

    public void setCaretItalicOverwriteMode(boolean bl) {
        this.setSettingBoolean("caret-italic-overwrite-mode", bl, CARET_ITALIC_OVERWRITE_MODE_PROP);
    }

    public Color getCaretColorInsertMode() {
        return (Color)super.getSettingValue("caret-color-insert-mode");
    }

    public void setCaretColorInsertMode(Color color) {
        this.setCaretColorInsertMode(color, true);
    }

    public void setCaretColorInsertMode(Color color, boolean bl) {
        super.setSettingValue("caret-color-insert-mode", color, CARET_COLOR_INSERT_MODE_PROP);
    }

    public Color getCaretColorOverwriteMode() {
        return (Color)super.getSettingValue("caret-color-overwrite-mode");
    }

    public void setCaretColorOverwriteMode(Color color) {
        this.setCaretColorOverwriteMode(color, true);
    }

    public void setCaretColorOverwriteMode(Color color, boolean bl) {
        super.setSettingValue("caret-color-overwrite-mode", color, CARET_COLOR_OVERWRITE_MODE_PROP);
    }

    public int getCaretBlinkRate() {
        return this.getSettingInteger("caret-blink-rate");
    }

    public void setCaretBlinkRate(int n) {
        if (n < 0) {
            NbEditorUtilities.invalidArgument("MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("caret-blink-rate", n, CARET_BLINK_RATE_PROP);
    }

    public boolean getLineNumberVisible() {
        return this.getSettingBoolean("line-number-visible");
    }

    public void setLineNumberVisible(boolean bl) {
        this.setSettingBoolean("line-number-visible", bl, LINE_NUMBER_VISIBLE_PROP);
    }

    public Insets getScrollJumpInsets() {
        return (Insets)this.getSettingValue("scroll-jump-insets");
    }

    public void setScrollJumpInsets(Insets insets) {
        this.setSettingValue("scroll-jump-insets", insets, SCROLL_JUMP_INSETS_PROP);
    }

    public Insets getScrollFindInsets() {
        return (Insets)this.getSettingValue("scroll-find-insets");
    }

    public void setScrollFindInsets(Insets insets) {
        this.setSettingValue("scroll-find-insets", insets, SCROLL_FIND_INSETS_PROP);
    }

    public Insets getMargin() {
        return (Insets)this.getSettingValue(MARGIN_PROP);
    }

    public void setMargin(Insets insets) {
        this.setSettingValue(MARGIN_PROP, insets, MARGIN_PROP);
    }

    public boolean getStatusBarVisible() {
        return this.getSettingBoolean("status-bar-visible");
    }

    public void setStatusBarVisible(boolean bl) {
        this.setSettingBoolean("status-bar-visible", bl, STATUS_BAR_VISIBLE_PROP);
    }

    public int getStatusBarCaretDelay() {
        return this.getSettingInteger("status-bar-caret-delay");
    }

    public void setStatusBarCaretDelay(int n) {
        if (n < 0) {
            NbEditorUtilities.invalidArgument("MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("status-bar-caret-delay", n, STATUS_BAR_CARET_DELAY_PROP);
    }

    public boolean getFindHighlightSearch() {
        return this.getSettingBoolean("find-highlight-search");
    }

    public void setFindHighlightSearch(boolean bl) {
        this.setSettingBoolean("find-highlight-search", bl, FIND_HIGHLIGHT_SEARCH_PROP);
    }

    public boolean getFindBlockSearch() {
        return this.getSettingBoolean("find-block-search");
    }

    public void setFindBlockSearch(boolean bl) {
        this.setSettingBoolean("find-block-search", bl, FIND_BLOCK_SEARCH_PROP);
    }

    public boolean getFindIncSearch() {
        return this.getSettingBoolean("find-inc-search");
    }

    public void setFindIncSearch(boolean bl) {
        this.setSettingBoolean("find-inc-search", bl, FIND_INC_SEARCH_PROP);
    }

    public int getFindIncSearchDelay() {
        return this.getSettingInteger("find-inc-search-delay");
    }

    public void setFindIncSearchDelay(int n) {
        if (n < 0) {
            NbEditorUtilities.invalidArgument("MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("find-inc-search-delay", n, FIND_INC_SEARCH_DELAY_PROP);
    }

    public boolean getFindWrapSearch() {
        return this.getSettingBoolean("find-wrap-search");
    }

    public void setFindWrapSearch(boolean bl) {
        this.setSettingBoolean("find-wrap-search", bl, FIND_WRAP_SEARCH_PROP);
    }

    public boolean getFindSmartCase() {
        return this.getSettingBoolean("find-smart-case");
    }

    public void setFindSmartCase(boolean bl) {
        this.setSettingBoolean("find-smart-case", bl, FIND_SMART_CASE_PROP);
    }

    public Map getFindHistory() {
        return new HashMap((Map)this.getSettingValue("find-history"));
    }

    public void setFindHistory(Map map) {
        this.setSettingValue("find-history", map, FIND_HISTORY_PROP);
    }

    public int getFindHistorySize() {
        return this.getSettingInteger("find-history-size");
    }

    public void setFindHistorySize(int n) {
        this.setSettingInteger("find-history-size", n, FIND_HISTORY_SIZE_PROP);
    }

    public boolean getPairCharactersCompletion() {
        return this.getSettingBoolean("pair-characters-completion");
    }

    public void setPairCharactersCompletion(boolean bl) {
        this.setSettingBoolean("pair-characters-completion", bl, PAIR_CHARACTERS_COMPLETION);
    }

    public Color getTextLimitLineColor() {
        return (Color)super.getSettingValue("text-limit-line-color");
    }

    public void setTextLimitLineColor(Color color) {
        this.setTextLimitLineColor(color, true);
    }

    public void setTextLimitLineColor(Color color, boolean bl) {
        super.setSettingValue("text-limit-line-color", color, TEXT_LIMIT_LINE_COLOR_PROP);
    }

    public int getTextLimitWidth() {
        return this.getSettingInteger("text-limit-width");
    }

    public void setTextLimitWidth(int n) {
        if (n <= 0) {
            NbEditorUtilities.invalidArgument("MSG_OutOfRange");
            return;
        }
        this.setSettingInteger("text-limit-width", n, TEXT_LIMIT_WIDTH_PROP);
    }

    public boolean getTextLimitLineVisible() {
        return this.getSettingBoolean("text-limit-line-visible");
    }

    public void setTextLimitLineVisible(boolean bl) {
        this.setSettingBoolean("text-limit-line-visible", bl, TEXT_LIMIT_LINE_VISIBLE_PROP);
    }

    public boolean getHighlightMatchingBracket() {
        return this.getSettingBoolean("highlight-match-brace");
    }

    public void setHighlightMatchingBracket(boolean bl) {
        this.setSettingBoolean("highlight-match-brace", bl, HIGHLIGHT_MATCHING_BRACKET_PROP);
    }

    public boolean getHighlightCaretRow() {
        return this.getSettingBoolean("highlight-caret-row");
    }

    public void setHighlightCaretRow(boolean bl) {
        this.setSettingBoolean("highlight-caret-row", bl, HIGHLIGHT_CARET_ROW_PROP);
    }

    public boolean isToolbarVisible() {
        return this.getSettingBoolean(TOOLBAR_VISIBLE_PROP);
    }

    public void setToolbarVisible(boolean bl) {
        this.setSettingBoolean(TOOLBAR_VISIBLE_PROP, bl, TOOLBAR_VISIBLE_PROP);
    }

    public Map<String, Boolean> getCodeFoldingProps() {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        Boolean bl = (Boolean)this.getSettingValue("code-folding-enable");
        hashMap.put("code-folding-enable", bl);
        return hashMap;
    }

    public void setCodeFoldingProps(Map map) {
        String string = "code-folding-enable";
        this.setSettingValue(string, map.get(string));
    }

    public void initPopupMenuItems() {
    }

    public IndentEngine getIndentEngine() {
        IndentEngine indentEngine;
        Object object;
        if (!BASE.equals(this.getTypeName())) {
            object = (Preferences)MimeLookup.getLookup((MimePath)MimePath.parse((String)this.getContentType())).lookup(Preferences.class);
            Object object2 = indentEngine = object != null ? ((Preferences)object).get(INDENT_ENGINE_PROP, null) : null;
            if (indentEngine != null) {
                Object object3 = null;
                IndentEngine indentEngine2 = indentEngine;
                if (indentEngine2.equals(NO_INDENT_ENGINE)) {
                    return IndentEngine.getDefault();
                }
                Lookup.Template template = new Lookup.Template(null, (String)indentEngine2, null);
                Lookup.Item item = Lookup.getDefault().lookupItem(template);
                if (item != null && (object3 = item.getInstance()) instanceof IndentEngine) {
                    return (IndentEngine)object3;
                }
            }
        }
        if ((object = this.getProperty(INDENT_ENGINE_PROP)) instanceof ServiceType.Handle) {
            indentEngine = (IndentEngine)((ServiceType.Handle)object).getServiceType();
            if (indentEngine != null) {
                this.setIndentEngine(indentEngine);
                return indentEngine;
            }
        } else if (object instanceof IndentEngine) {
            this.setIndentEngine((IndentEngine)object);
            return (IndentEngine)object;
        }
        if ((indentEngine = this.findDefaultIndentEngine()) != null) {
            this.setIndentEngine(indentEngine);
        }
        return indentEngine;
    }

    public void setIndentEngine(IndentEngine indentEngine) {
        Object object;
        String string = null;
        if (indentEngine != null) {
            object = new Lookup.Template(null, null, (Object)indentEngine);
            Lookup.Item item = Lookup.getDefault().lookupItem((Lookup.Template)object);
            if (item != null) {
                string = item.getId();
            }
        }
        if (!BASE.equals(this.getTypeName())) {
            object = (Preferences)MimeLookup.getLookup((MimePath)MimePath.parse((String)this.getContentType())).lookup(Preferences.class);
            if (string == null) {
                string = NO_INDENT_ENGINE;
            }
            if (object != null) {
                ((Preferences)object).put(INDENT_ENGINE_PROP, string);
            } else {
                LOG.warning("Could not find Preferences instance for " + this.getContentType());
            }
            this.refreshIndentEngineSettings();
        }
    }

    private void refreshIndentEngineSettings() {
        Settings.update((Runnable)new Runnable(){

            public void run() {
                Settings.touchValue((Class)BaseOptions.this.getKitClass(), (String)BaseOptions.INDENT_ENGINE_PROP);
                Settings.touchValue((Class)BaseOptions.this.getKitClass(), (String)"formatter");
            }

            public boolean asynchronous() {
                return true;
            }
        });
    }

    protected Class getDefaultIndentEngineClass() {
        return SimpleIndentEngine.class;
    }

    private IndentEngine findDefaultIndentEngine() {
        if (this.getDefaultIndentEngineClass() != null) {
            return (IndentEngine)Lookup.getDefault().lookup(this.getDefaultIndentEngineClass());
        }
        return null;
    }

    public void setOptionsVersion(int n) {
        int n2 = this.optionsVersion;
        this.optionsVersion = n;
        if (n != n2) {
            this.firePropertyChange(OPTIONS_VERSION_PROP, new Integer(n2), new Integer(n));
        }
    }

    public int getOptionsVersion() {
        return this.optionsVersion;
    }

    protected void upgradeOptions(int n, int n2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected MIMEOptionFolder getMIMEFolder() {
        String string = this.getCTImpl();
        if (string == null) {
            return null;
        }
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            if (this.settingsFolderInitialization) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            this.settingsFolderInitialization = true;
            try {
                FileObject fileObject;
                block16: {
                    if (this.settingsFolder != null) {
                        MIMEOptionFolder mIMEOptionFolder = this.settingsFolder;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return mIMEOptionFolder;
                    }
                    FileObject fileObject2 = Repository.getDefault().getDefaultFileSystem().findResource("Editors/" + string);
                    if (fileObject2 == null && (fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Editors")) != null) {
                        try {
                            FileUtil.createFolder((FileObject)fileObject, (String)string);
                        }
                        catch (IOException iOException) {
                            LOG.log(Level.WARNING, null, iOException);
                        }
                        fileObject2 = Repository.getDefault().getDefaultFileSystem().findResource("Editors/" + string);
                    }
                    if (fileObject2 != null) {
                        MIMEOptionFolder mIMEOptionFolder;
                        try {
                            fileObject = DataObject.find((FileObject)fileObject2);
                            DataFolder dataFolder = (DataFolder)fileObject.getCookie(DataFolder.class);
                            if (dataFolder == null) break block16;
                            mIMEOptionFolder = this.settingsFolder = new MIMEOptionFolder(dataFolder, this);
                        }
                        catch (DataObjectNotFoundException dataObjectNotFoundException) {
                            LOG.log(Level.WARNING, null, dataObjectNotFoundException);
                            break block16;
                        }
                        return mIMEOptionFolder;
                    }
                }
                fileObject = null;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return fileObject;
            }
            finally {
                this.settingsFolderInitialization = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MIMEOptionNode getMimeNode() {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            if (this.mimeNode == null) {
                this.createMIMENode(this.getTypeName());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mimeNode;
        }
    }

    private void createMIMENode(String string) {
        if (string.equals(BASE)) {
            return;
        }
        try {
            this.mimeNode = new MIMEOptionNode(this);
        }
        catch (IntrospectionException introspectionException) {
            LOG.log(Level.WARNING, null, introspectionException);
        }
    }

    protected void loadXMLSettings() {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
    }

    public void writeExternal() throws IOException {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
    }
}

