/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.classpath.j2ee;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathItem;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.classpath.ProjectClassPathModifierSupport;
import org.netbeans.modules.java.api.common.classpath.j2ee.BaseClassPathSupport;
import org.netbeans.modules.java.api.common.classpath.j2ee.WebClassPathSupport;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.java.project.classpath.ProjectClassPathModifierImplementation;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebProjectClassPathModifier
extends ProjectClassPathModifierImplementation
implements PropertyChangeListener {
    private static final String JAVAC_CLASSPATH = "javac.classpath";
    private static final String WAR_CONTENT_ADDITIONAL = "war.content.additional";
    private static final String TAG_WEB_MODULE_LIBRARIES = "web-module-libraries";
    private static final String TAG_WEB_MODULE_ADDITIONAL_LIBRARIES = "web-module-additional-libraries";
    private static final String DEFAULT_WEB_MODULE_ELEMENT_NAME = "web-module-libraries";
    private final Project project;
    private final UpdateHelper helper;
    private final PropertyEvaluator eval;
    private final WebClassPathSupport classPathSupport;
    private final ProjectClassPathModifierSupport<WebClassPathSupport.Item> classPathModifierSupport;
    private volatile boolean projectDeleted;
    private boolean dontFireChange = false;
    private final PropertyChangeListener listener = WeakListeners.propertyChange((PropertyChangeListener)this, null);

    public static WebProjectClassPathModifier create(Project project, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, WebClassPathSupport webClassPathSupport, SourceRoots sourceRoots, SourceRoots sourceRoots2, ProjectClassPathModifierSupport.Properties properties) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"helper", (Object)updateHelper);
        Parameters.notNull((CharSequence)"eval", (Object)propertyEvaluator);
        Parameters.notNull((CharSequence)"classPathSupport", (Object)webClassPathSupport);
        return new WebProjectClassPathModifier(project, updateHelper, propertyEvaluator, referenceHelper, webClassPathSupport, sourceRoots, sourceRoots2, properties);
    }

    WebProjectClassPathModifier(Project project, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, WebClassPathSupport webClassPathSupport, SourceRoots sourceRoots, SourceRoots sourceRoots2, ProjectClassPathModifierSupport.Properties properties) {
        assert (project != null);
        assert (updateHelper != null);
        assert (propertyEvaluator != null);
        assert (webClassPathSupport != null);
        this.project = project;
        this.helper = updateHelper;
        this.eval = propertyEvaluator;
        this.classPathSupport = webClassPathSupport;
        this.classPathModifierSupport = ProjectClassPathModifierSupport.create(project, updateHelper, propertyEvaluator, referenceHelper, sourceRoots, sourceRoots2, properties);
        propertyEvaluator.addPropertyChangeListener(this.listener);
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                WebProjectClassPathModifier.this.registerLibraryListeners();
            }
        });
    }

    protected SourceGroup[] getExtensibleSourceGroups() {
        return this.classPathModifierSupport.getExtensibleSourceGroups();
    }

    protected String[] getExtensibleClassPathTypes(SourceGroup sourceGroup) {
        return this.classPathModifierSupport.getExtensibleClassPathTypes(sourceGroup);
    }

    protected boolean removeRoots(URL[] uRLArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        String string2 = this.classPathModifierSupport.getClassPathProperty(sourceGroup, string);
        return this.classPathModifierSupport.handleRoots(uRLArray, string2, ProjectClassPathModifierSupport.Operation.REMOVE, new WebClassPathItemProvider(this.getElementName(string2)));
    }

    protected boolean addRoots(URL[] uRLArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        String string2 = this.classPathModifierSupport.getClassPathProperty(sourceGroup, string);
        return this.classPathModifierSupport.handleRoots(uRLArray, string2, ProjectClassPathModifierSupport.Operation.ADD, new WebClassPathItemProvider(this.getElementName(string2)));
    }

    protected boolean handleRoots(URL[] uRLArray, String string, String string2, ProjectClassPathModifierSupport.Operation operation) throws IOException, UnsupportedOperationException {
        return this.classPathModifierSupport.handleRoots(uRLArray, string, operation, new WebClassPathItemProvider(string2));
    }

    protected boolean removeAntArtifacts(AntArtifact[] antArtifactArray, URI[] uRIArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        String string2 = this.classPathModifierSupport.getClassPathProperty(sourceGroup, string);
        return this.classPathModifierSupport.handleAntArtifacts(antArtifactArray, uRIArray, string2, ProjectClassPathModifierSupport.Operation.REMOVE, new WebClassPathItemProvider(this.getElementName(string2)));
    }

    protected boolean addAntArtifacts(AntArtifact[] antArtifactArray, URI[] uRIArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        String string2 = this.classPathModifierSupport.getClassPathProperty(sourceGroup, string);
        return this.classPathModifierSupport.handleAntArtifacts(antArtifactArray, uRIArray, string2, ProjectClassPathModifierSupport.Operation.ADD, new WebClassPathItemProvider(this.getElementName(string2)));
    }

    protected boolean removeLibraries(Library[] libraryArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        String string2 = this.classPathModifierSupport.getClassPathProperty(sourceGroup, string);
        return this.handleLibraries(libraryArray, string2, this.getElementName(string2), ProjectClassPathModifierSupport.Operation.REMOVE);
    }

    protected boolean addLibraries(Library[] libraryArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        String string2 = this.classPathModifierSupport.getClassPathProperty(sourceGroup, string);
        return this.handleLibraries(libraryArray, string2, this.getElementName(string2), ProjectClassPathModifierSupport.Operation.ADD);
    }

    protected boolean handleLibraries(Library[] libraryArray, String string, String string2, ProjectClassPathModifierSupport.Operation operation) throws IOException, UnsupportedOperationException {
        ArrayList<WebClassPathSupport.Item> arrayList = new ArrayList<WebClassPathSupport.Item>(libraryArray.length);
        for (Library library : libraryArray) {
            arrayList.add(WebClassPathSupport.Item.create(library, null, "WEB-INF/lib"));
        }
        return this.handleLibraryClassPathItems(arrayList, string, string2, operation, true);
    }

    public boolean handleLibraryClassPathItems(final List<WebClassPathSupport.Item> list, final String string, final String string2, final ProjectClassPathModifierSupport.Operation operation, final boolean bl) throws IOException {
        assert (list != null) : "Libraries cannot be null";
        assert (string != null);
        assert (bl || ProjectManager.mutex().isWriteAccess());
        try {
            this.dontFireChange = true;
            this.unregisterLibraryListeners();
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws IOException {
                    EditableProperties editableProperties = WebProjectClassPathModifier.this.helper.getProperties("nbproject/project.properties");
                    String string3 = editableProperties.getProperty(string);
                    List<WebClassPathSupport.Item> list2 = WebProjectClassPathModifier.this.classPathSupport.itemsList(string3, string2);
                    ArrayList<WebClassPathSupport.Item> arrayList = new ArrayList<WebClassPathSupport.Item>(list.size());
                    for (Object object2 : list) {
                        assert (object2 != null);
                        assert (((BaseClassPathSupport.Item)object2).getType() == ClassPathItem.Type.LIBRARY);
                        if (operation == ProjectClassPathModifierSupport.Operation.ADD && !list2.contains(object2)) {
                            list2.add((WebClassPathSupport.Item)object2);
                            arrayList.add((WebClassPathSupport.Item)object2);
                            continue;
                        }
                        if (operation != ProjectClassPathModifierSupport.Operation.REMOVE || !list2.contains(object2)) continue;
                        list2.remove(object2);
                        arrayList.add((WebClassPathSupport.Item)object2);
                    }
                    if (!arrayList.isEmpty()) {
                        Object object2;
                        String[] stringArray = WebProjectClassPathModifier.this.classPathSupport.encodeToStrings(list2, string2);
                        editableProperties = WebProjectClassPathModifier.this.helper.getProperties("nbproject/project.properties");
                        editableProperties.setProperty(string, stringArray);
                        if (operation == ProjectClassPathModifierSupport.Operation.ADD) {
                            for (WebClassPathSupport.Item object3 : arrayList) {
                                String string22 = WebProjectClassPathModifier.this.classPathSupport.getLibraryReference(object3);
                                string22 = string22.substring(2, string22.length() - 1);
                                ClassPathSupport.relativizeLibraryClassPath(editableProperties, WebProjectClassPathModifier.this.helper.getAntProjectHelper(), string22);
                            }
                        }
                        WebProjectClassPathModifier.this.helper.putProperties("nbproject/project.properties", editableProperties);
                        object2 = WebProjectClassPathModifier.this.helper.getProperties("nbproject/private/private.properties");
                        ArrayList<WebClassPathSupport.Item> arrayList2 = new ArrayList<WebClassPathSupport.Item>();
                        arrayList2.addAll(list2);
                        arrayList2.addAll(WebProjectClassPathModifier.this.classPathSupport.itemsList(editableProperties.getProperty(WebProjectClassPathModifier.WAR_CONTENT_ADDITIONAL), WebProjectClassPathModifier.TAG_WEB_MODULE_ADDITIONAL_LIBRARIES));
                        WebProjectClassPathModifier.storeLibrariesLocations(arrayList2.iterator(), (EditableProperties)object2);
                        WebProjectClassPathModifier.this.helper.putProperties("nbproject/private/private.properties", (EditableProperties)object2);
                        if (bl) {
                            ProjectManager.getDefault().saveProject(WebProjectClassPathModifier.this.project);
                        }
                        WebProjectClassPathModifier.this.registerLibraryListeners(editableProperties);
                        WebProjectClassPathModifier.this.dontFireChange = false;
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    private void unregisterLibraryListeners() {
        Library[] libraryArray;
        for (Library library : libraryArray = LibraryManager.getDefault().getLibraries()) {
            library.removePropertyChangeListener(this.listener);
        }
    }

    private void registerLibraryListeners() {
        EditableProperties editableProperties = this.helper.getProperties("nbproject/project.properties");
        this.registerLibraryListeners(editableProperties);
    }

    private void registerLibraryListeners(EditableProperties editableProperties) {
        this.unregisterLibraryListeners();
        HashSet<WebClassPathSupport.Item> hashSet = new HashSet<WebClassPathSupport.Item>();
        hashSet.addAll(this.classPathSupport.itemsList(editableProperties.getProperty(JAVAC_CLASSPATH), "web-module-libraries"));
        hashSet.addAll(this.classPathSupport.itemsList(editableProperties.getProperty(WAR_CONTENT_ADDITIONAL), TAG_WEB_MODULE_ADDITIONAL_LIBRARIES));
        for (WebClassPathSupport.Item item : hashSet) {
            if (item.getType() != ClassPathItem.Type.LIBRARY || item.isBroken()) continue;
            item.getLibrary().addPropertyChangeListener(this.listener);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.projectDeleted) {
            return;
        }
        if (this.dontFireChange) {
            return;
        }
        if (propertyChangeEvent.getSource().equals(this.eval) && (propertyChangeEvent.getPropertyName().equals(JAVAC_CLASSPATH) || propertyChangeEvent.getPropertyName().equals(WAR_CONTENT_ADDITIONAL))) {
            EditableProperties editableProperties = this.helper.getProperties("nbproject/project.properties");
            String string = editableProperties.getProperty(JAVAC_CLASSPATH);
            if (string != null) {
                this.registerLibraryListeners(editableProperties);
                if (ProjectManager.getDefault().isValid(this.project)) {
                    this.storeLibLocations();
                }
            }
        } else if (propertyChangeEvent.getPropertyName().equals("content")) {
            this.storeLibLocations();
        }
    }

    private void storeLibLocations() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                ProjectManager.mutex().writeAccess(new Runnable(){

                    public void run() {
                        EditableProperties editableProperties = WebProjectClassPathModifier.this.helper.getProperties("nbproject/project.properties");
                        EditableProperties editableProperties2 = WebProjectClassPathModifier.this.helper.getProperties("nbproject/private/private.properties");
                        List<WebClassPathSupport.Item> list = WebProjectClassPathModifier.this.classPathSupport.itemsList(editableProperties.getProperty(WebProjectClassPathModifier.JAVAC_CLASSPATH), "web-module-libraries");
                        List<WebClassPathSupport.Item> list2 = WebProjectClassPathModifier.this.classPathSupport.itemsList(editableProperties.getProperty(WebProjectClassPathModifier.WAR_CONTENT_ADDITIONAL), WebProjectClassPathModifier.TAG_WEB_MODULE_ADDITIONAL_LIBRARIES);
                        WebProjectClassPathModifier.this.classPathSupport.encodeToStrings(list, "web-module-libraries");
                        WebProjectClassPathModifier.this.classPathSupport.encodeToStrings(list2, WebProjectClassPathModifier.TAG_WEB_MODULE_ADDITIONAL_LIBRARIES);
                        HashSet<WebClassPathSupport.Item> hashSet = new HashSet<WebClassPathSupport.Item>();
                        hashSet.addAll(list);
                        hashSet.addAll(list2);
                        WebProjectClassPathModifier.storeLibrariesLocations(hashSet.iterator(), editableProperties2);
                        WebProjectClassPathModifier.this.helper.putProperties("nbproject/private/private.properties", editableProperties2);
                        try {
                            ProjectManager.getDefault().saveProject(WebProjectClassPathModifier.this.project);
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                    }
                });
            }
        });
    }

    public void notifyDeleting() {
        this.projectDeleted = true;
        this.eval.removePropertyChangeListener(this.listener);
    }

    private String getElementName(String string) {
        if (JAVAC_CLASSPATH.equals(string)) {
            return "web-module-libraries";
        }
        return null;
    }

    public static void storeLibrariesLocations(Iterator<WebClassPathSupport.Item> iterator, EditableProperties editableProperties) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object2 : editableProperties.keySet()) {
            if (!((String)object2).endsWith(".libdirs") && !((String)object2).endsWith(".libfiles") && ((String)object2).indexOf(".libdir.") <= 0 && ((String)object2).indexOf(".libfile.") <= 0) continue;
            arrayList.add((String)object2);
        }
        while (iterator.hasNext()) {
            String string;
            File file;
            int n;
            String string2;
            Object object2;
            object = iterator.next();
            object2 = new ArrayList();
            ArrayList<File> arrayList2 = new ArrayList<File>();
            WebClassPathSupport.getFilesForItem((BaseClassPathSupport.Item)object, (List<File>)object2, arrayList2);
            if (object2.size() > 1 || object2.size() > 0 && arrayList2.size() > 0) {
                string2 = ((BaseClassPathSupport.Item)object).getType() == ClassPathItem.Type.LIBRARY ? ((BaseClassPathSupport.Item)object).getRaw() : ((BaseClassPathSupport.Item)object).getReference();
                for (n = 0; n < object2.size(); ++n) {
                    file = (File)object2.get(n);
                    string = CommonProjectUtils.getAntPropertyName(string2) + ".libfile." + (n + 1);
                    editableProperties.setProperty(string, "" + file.getAbsolutePath());
                    arrayList.remove(string);
                }
            }
            if (arrayList2.size() <= 1 && (object2.size() <= 0 || arrayList2.size() <= 0)) continue;
            string2 = ((BaseClassPathSupport.Item)object).getType() == ClassPathItem.Type.LIBRARY ? ((BaseClassPathSupport.Item)object).getRaw() : ((BaseClassPathSupport.Item)object).getReference();
            for (n = 0; n < arrayList2.size(); ++n) {
                file = (File)arrayList2.get(n);
                string = CommonProjectUtils.getAntPropertyName(string2) + ".libdir." + (n + 1);
                editableProperties.setProperty(string, "" + file.getAbsolutePath());
                arrayList.remove(string);
            }
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            editableProperties.remove(object.next());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class WebClassPathItemProvider
    implements ProjectClassPathModifierSupport.ClassPathItemProvider<WebClassPathSupport.Item> {
        private final String elementName;

        public WebClassPathItemProvider(String string) {
            this.elementName = string;
        }

        @Override
        public WebClassPathSupport.Item createClassPathItem(File file, String string) {
            String string2 = null;
            string2 = file.isDirectory() ? "WEB-INF/classes" : "WEB-INF/lib";
            return WebClassPathSupport.Item.create(file, string, string2);
        }

        @Override
        public WebClassPathSupport.Item createClassPathItem(AntArtifact antArtifact, URI uRI, String string) {
            return WebClassPathSupport.Item.create(antArtifact, uRI, string, "WEB-INF/lib");
        }

        @Override
        public WebClassPathSupport.Item createClassPathItem(Library library, String string) {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public List<WebClassPathSupport.Item> getClassPathItems(String string) {
            return WebProjectClassPathModifier.this.classPathSupport.itemsList(string, this.elementName);
        }

        @Override
        public String[] encodeToStrings(List<WebClassPathSupport.Item> list) {
            return WebProjectClassPathModifier.this.classPathSupport.encodeToStrings(list, this.elementName);
        }

        @Override
        public String getLibraryReference(WebClassPathSupport.Item item) {
            return WebProjectClassPathModifier.this.classPathSupport.getLibraryReference(item);
        }
    }
}

