/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.classpath.j2ee;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathItem;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.classpath.ProjectClassPathModifierSupport;
import org.netbeans.modules.java.api.common.classpath.j2ee.BaseClassPathSupport;
import org.netbeans.modules.java.api.common.classpath.j2ee.J2EEClassPathSupport;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.java.project.classpath.ProjectClassPathModifierImplementation;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2EEProjectClassPathModifier
extends ProjectClassPathModifierImplementation
implements PropertyChangeListener {
    private static final String JAVAC_CLASSPATH = "javac.classpath";
    private static final String ELEMENT_INCLUDED_LIBRARIES = "included-library";
    private final Project project;
    private final UpdateHelper helper;
    private final PropertyEvaluator eval;
    private final J2EEClassPathSupport classPathSupport;
    private final ProjectClassPathModifierSupport<J2EEClassPathSupport.Item> classPathModifierSupport;
    private final ProjectClassPathModifierSupport.ClassPathItemProvider<J2EEClassPathSupport.Item> provider;
    private volatile boolean projectDeleted;
    private final PropertyChangeListener listener = WeakListeners.propertyChange((PropertyChangeListener)this, null);

    public static J2EEProjectClassPathModifier create(Project project, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, J2EEClassPathSupport j2EEClassPathSupport, SourceRoots sourceRoots, SourceRoots sourceRoots2, ProjectClassPathModifierSupport.Properties properties) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"helper", (Object)updateHelper);
        Parameters.notNull((CharSequence)"eval", (Object)propertyEvaluator);
        Parameters.notNull((CharSequence)"classPathSupport", (Object)j2EEClassPathSupport);
        return new J2EEProjectClassPathModifier(project, updateHelper, propertyEvaluator, referenceHelper, j2EEClassPathSupport, sourceRoots, sourceRoots2, properties);
    }

    J2EEProjectClassPathModifier(Project project, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, J2EEClassPathSupport j2EEClassPathSupport, SourceRoots sourceRoots, SourceRoots sourceRoots2, ProjectClassPathModifierSupport.Properties properties) {
        assert (project != null);
        assert (updateHelper != null);
        assert (propertyEvaluator != null);
        assert (j2EEClassPathSupport != null);
        this.project = project;
        this.helper = updateHelper;
        this.eval = propertyEvaluator;
        this.classPathSupport = j2EEClassPathSupport;
        this.classPathModifierSupport = ProjectClassPathModifierSupport.create(project, updateHelper, propertyEvaluator, referenceHelper, sourceRoots, sourceRoots2, properties);
        this.provider = new J2EEClassPathItemProvider(ELEMENT_INCLUDED_LIBRARIES);
        propertyEvaluator.addPropertyChangeListener(this.listener);
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                J2EEProjectClassPathModifier.this.registerLibraryListeners();
            }
        });
    }

    protected SourceGroup[] getExtensibleSourceGroups() {
        return this.classPathModifierSupport.getExtensibleSourceGroups();
    }

    protected String[] getExtensibleClassPathTypes(SourceGroup sourceGroup) {
        return this.classPathModifierSupport.getExtensibleClassPathTypes(sourceGroup);
    }

    protected boolean removeRoots(URL[] uRLArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        String string2 = this.classPathModifierSupport.getClassPathProperty(sourceGroup, string);
        return this.classPathModifierSupport.handleRoots(uRLArray, string2, ProjectClassPathModifierSupport.Operation.ADD, this.provider);
    }

    protected boolean addRoots(URL[] uRLArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        String string2 = this.classPathModifierSupport.getClassPathProperty(sourceGroup, string);
        return this.classPathModifierSupport.handleRoots(uRLArray, string2, ProjectClassPathModifierSupport.Operation.ADD, this.provider);
    }

    protected boolean handleRoots(URL[] uRLArray, String string, String string2, ProjectClassPathModifierSupport.Operation operation) throws IOException, UnsupportedOperationException {
        return this.classPathModifierSupport.handleRoots(uRLArray, string, operation, this.provider);
    }

    protected boolean removeAntArtifacts(AntArtifact[] antArtifactArray, URI[] uRIArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        String string2 = this.classPathModifierSupport.getClassPathProperty(sourceGroup, string);
        return this.classPathModifierSupport.handleAntArtifacts(antArtifactArray, uRIArray, string2, ProjectClassPathModifierSupport.Operation.REMOVE, this.provider);
    }

    protected boolean addAntArtifacts(AntArtifact[] antArtifactArray, URI[] uRIArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        String string2 = this.classPathModifierSupport.getClassPathProperty(sourceGroup, string);
        return this.classPathModifierSupport.handleAntArtifacts(antArtifactArray, uRIArray, string2, ProjectClassPathModifierSupport.Operation.ADD, this.provider);
    }

    protected boolean removeLibraries(Library[] libraryArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        String string2 = this.classPathModifierSupport.getClassPathProperty(sourceGroup, string);
        return this.handleLibraries(libraryArray, string2, ProjectClassPathModifierSupport.Operation.REMOVE, this.provider);
    }

    protected boolean addLibraries(Library[] libraryArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        String string2 = this.classPathModifierSupport.getClassPathProperty(sourceGroup, string);
        return this.handleLibraries(libraryArray, string2, ProjectClassPathModifierSupport.Operation.ADD, this.provider);
    }

    protected boolean handleLibraries(Library[] libraryArray, String string, String string2, ProjectClassPathModifierSupport.Operation operation) throws IOException, UnsupportedOperationException {
        return this.handleLibraries(libraryArray, string, operation, new J2EEClassPathItemProvider(string2));
    }

    public boolean handleLibraries(final Library[] libraryArray, final String string, final ProjectClassPathModifierSupport.Operation operation, final ProjectClassPathModifierSupport.ClassPathItemProvider<J2EEClassPathSupport.Item> classPathItemProvider) throws IOException, UnsupportedOperationException {
        assert (libraryArray != null) : "Libraries cannot be null";
        assert (string != null);
        try {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws IOException {
                    EditableProperties editableProperties = J2EEProjectClassPathModifier.this.helper.getProperties("nbproject/project.properties");
                    String string2 = editableProperties.getProperty(string);
                    List list = classPathItemProvider.getClassPathItems(string2);
                    ArrayList<J2EEClassPathSupport.Item> arrayList = new ArrayList<J2EEClassPathSupport.Item>(libraryArray.length);
                    for (Library library : libraryArray) {
                        assert (library != null);
                        J2EEClassPathSupport.Item item = (J2EEClassPathSupport.Item)classPathItemProvider.createClassPathItem(library, null);
                        if (operation == ProjectClassPathModifierSupport.Operation.ADD && !list.contains(item)) {
                            list.add(item);
                            arrayList.add(item);
                            continue;
                        }
                        if (operation != ProjectClassPathModifierSupport.Operation.REMOVE || !list.contains(item)) continue;
                        list.remove(item);
                        arrayList.add(item);
                    }
                    if (!arrayList.isEmpty()) {
                        String[] stringArray = classPathItemProvider.encodeToStrings(list);
                        editableProperties = J2EEProjectClassPathModifier.this.helper.getProperties("nbproject/project.properties");
                        editableProperties.setProperty(string, stringArray);
                        if (operation == ProjectClassPathModifierSupport.Operation.ADD) {
                            for (J2EEClassPathSupport.Item arrayList2 : arrayList) {
                                String string3 = classPathItemProvider.getLibraryReference(arrayList2);
                                string3 = string3.substring(2, string3.length() - 1);
                                ClassPathSupport.relativizeLibraryClassPath(editableProperties, J2EEProjectClassPathModifier.this.helper.getAntProjectHelper(), string3);
                            }
                        }
                        J2EEProjectClassPathModifier.this.helper.putProperties("nbproject/project.properties", editableProperties);
                        EditableProperties editableProperties2 = J2EEProjectClassPathModifier.this.helper.getProperties("nbproject/private/private.properties");
                        ArrayList arrayList2 = new ArrayList();
                        arrayList2.addAll(list);
                        J2EEProjectClassPathModifier.storeLibrariesLocations(arrayList2.iterator(), editableProperties2);
                        J2EEProjectClassPathModifier.this.helper.putProperties("nbproject/private/private.properties", editableProperties2);
                        ProjectManager.getDefault().saveProject(J2EEProjectClassPathModifier.this.project);
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    private void registerLibraryListeners() {
        EditableProperties editableProperties = this.helper.getProperties("nbproject/project.properties");
        Library[] libraryArray = LibraryManager.getDefault().getLibraries();
        for (Library library : libraryArray) {
            library.removePropertyChangeListener((PropertyChangeListener)this);
        }
        Iterator iterator = this.classPathSupport.itemsIterator(editableProperties.getProperty(JAVAC_CLASSPATH), ELEMENT_INCLUDED_LIBRARIES);
        while (iterator.hasNext()) {
            J2EEClassPathSupport.Item item = (J2EEClassPathSupport.Item)iterator.next();
            if (item.getType() != ClassPathItem.Type.LIBRARY || item.isBroken()) continue;
            item.getLibrary().addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.projectDeleted) {
            return;
        }
        if (propertyChangeEvent.getSource().equals(this.eval) && propertyChangeEvent.getPropertyName().equals(JAVAC_CLASSPATH)) {
            EditableProperties editableProperties = this.helper.getProperties("nbproject/project.properties");
            String string = editableProperties.getProperty(JAVAC_CLASSPATH);
            if (string != null) {
                this.registerLibraryListeners();
                this.storeLibLocations();
            }
        } else if (propertyChangeEvent.getPropertyName().equals("content")) {
            this.storeLibLocations();
        }
    }

    private void storeLibLocations() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                ProjectManager.mutex().writeAccess(new Runnable(){

                    public void run() {
                        EditableProperties editableProperties = J2EEProjectClassPathModifier.this.helper.getProperties("nbproject/project.properties");
                        EditableProperties editableProperties2 = J2EEProjectClassPathModifier.this.helper.getProperties("nbproject/private/private.properties");
                        List<J2EEClassPathSupport.Item> list = J2EEProjectClassPathModifier.this.classPathSupport.itemsList(editableProperties.getProperty(J2EEProjectClassPathModifier.JAVAC_CLASSPATH), J2EEProjectClassPathModifier.ELEMENT_INCLUDED_LIBRARIES);
                        J2EEProjectClassPathModifier.this.classPathSupport.encodeToStrings(list, J2EEProjectClassPathModifier.ELEMENT_INCLUDED_LIBRARIES);
                        J2EEProjectClassPathModifier.storeLibrariesLocations(list.iterator(), editableProperties2);
                        J2EEProjectClassPathModifier.this.helper.putProperties("nbproject/private/private.properties", editableProperties2);
                        try {
                            ProjectManager.getDefault().saveProject(J2EEProjectClassPathModifier.this.project);
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                    }
                });
            }
        });
    }

    public void notifyDeleting() {
        this.projectDeleted = true;
        this.eval.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public static void storeLibrariesLocations(Iterator<J2EEClassPathSupport.Item> iterator, EditableProperties editableProperties) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object2 : editableProperties.keySet()) {
            if (!((String)object2).endsWith(".libdirs") && !((String)object2).endsWith(".libfiles") && ((String)object2).indexOf(".libdir.") <= 0 && ((String)object2).indexOf(".libfile.") <= 0) continue;
            arrayList.add((String)object2);
        }
        while (iterator.hasNext()) {
            String string;
            File file;
            int n;
            String string2;
            Object object2;
            object = iterator.next();
            object2 = new ArrayList();
            ArrayList<File> arrayList2 = new ArrayList<File>();
            J2EEClassPathSupport.getFilesForItem((BaseClassPathSupport.Item)object, (List<File>)object2, arrayList2);
            if (object2.size() > 1 || object2.size() > 0 && arrayList2.size() > 0) {
                string2 = ((BaseClassPathSupport.Item)object).getType() == ClassPathItem.Type.LIBRARY ? ((BaseClassPathSupport.Item)object).getRaw() : ((BaseClassPathSupport.Item)object).getReference();
                for (n = 0; n < object2.size(); ++n) {
                    file = (File)object2.get(n);
                    string = CommonProjectUtils.getAntPropertyName(string2) + ".libfile." + (n + 1);
                    editableProperties.setProperty(string, "" + file.getAbsolutePath());
                    arrayList.remove(string);
                }
            }
            if (arrayList2.size() <= 1 && (object2.size() <= 0 || arrayList2.size() <= 0)) continue;
            string2 = ((BaseClassPathSupport.Item)object).getType() == ClassPathItem.Type.LIBRARY ? ((BaseClassPathSupport.Item)object).getRaw() : ((BaseClassPathSupport.Item)object).getReference();
            for (n = 0; n < arrayList2.size(); ++n) {
                file = (File)arrayList2.get(n);
                string = CommonProjectUtils.getAntPropertyName(string2) + ".libdir." + (n + 1);
                editableProperties.setProperty(string, "" + file.getAbsolutePath());
                arrayList.remove(string);
            }
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            editableProperties.remove(object.next());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class J2EEClassPathItemProvider
    implements ProjectClassPathModifierSupport.ClassPathItemProvider<J2EEClassPathSupport.Item> {
        private final String elementName;

        public J2EEClassPathItemProvider(String string) {
            this.elementName = string;
        }

        @Override
        public J2EEClassPathSupport.Item createClassPathItem(File file, String string) {
            return J2EEClassPathSupport.Item.create(file, null, string != null);
        }

        @Override
        public J2EEClassPathSupport.Item createClassPathItem(AntArtifact antArtifact, URI uRI, String string) {
            return J2EEClassPathSupport.Item.create(antArtifact, uRI, null, string != null);
        }

        @Override
        public J2EEClassPathSupport.Item createClassPathItem(Library library, String string) {
            return J2EEClassPathSupport.Item.create(library, null, string != null);
        }

        @Override
        public List<J2EEClassPathSupport.Item> getClassPathItems(String string) {
            return J2EEProjectClassPathModifier.this.classPathSupport.itemsList(string, this.elementName);
        }

        @Override
        public String[] encodeToStrings(List<J2EEClassPathSupport.Item> list) {
            return J2EEProjectClassPathModifier.this.classPathSupport.encodeToStrings(list, this.elementName);
        }

        @Override
        public String getLibraryReference(J2EEClassPathSupport.Item item) {
            return J2EEProjectClassPathModifier.this.classPathSupport.getLibraryReference(item);
        }
    }
}

