/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.classpath.j2ee;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.classpath.DefaultClassPathProviderImpl;
import org.netbeans.modules.java.api.common.classpath.SourcePathImplementation;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public final class ClassPathProviderImpl
implements ClassPathProvider,
PropertyChangeListener {
    private final DefaultClassPathProviderImpl delegate;
    private final AntProjectHelper helper;
    private final File projectDirectory;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testSourceRoots;
    private final Properties properties;
    private final Map<ClassPathCache, ClassPath> cache = new HashMap<ClassPathCache, ClassPath>();
    private final Map<String, FileObject> dirCache = new HashMap<String, FileObject>();

    public ClassPathProviderImpl(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, SourceRoots sourceRoots, SourceRoots sourceRoots2, Properties properties) {
        this.delegate = new DefaultClassPathProviderImpl(antProjectHelper, propertyEvaluator, sourceRoots, sourceRoots2, properties.delegate);
        this.helper = antProjectHelper;
        this.projectDirectory = FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory());
        this.evaluator = propertyEvaluator;
        this.sourceRoots = sourceRoots;
        this.testSourceRoots = sourceRoots2;
        propertyEvaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
        this.properties = properties;
    }

    private synchronized FileObject getDir(String string) {
        String string2;
        FileObject fileObject = this.dirCache.get(string);
        if (!(fileObject != null && fileObject.isValid() || (string2 = this.evaluator.getProperty(string)) == null)) {
            fileObject = this.helper.resolveFileObject(string2);
            this.dirCache.put(string, fileObject);
        }
        return fileObject;
    }

    private FileObject getDocumentBaseDir() {
        if (this.properties.webDocBaseDir == null) {
            return null;
        }
        return this.getDir(this.properties.webDocBaseDir);
    }

    private FileType getType(FileObject fileObject) {
        FileObject fileObject2 = this.getDocumentBaseDir();
        if (fileObject2 != null && (fileObject2.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject))) {
            return FileType.WEB_SOURCE;
        }
        return FileType.UNKNOWN;
    }

    private synchronized ClassPath getCompileTimeClasspath(FileType fileType) {
        ClassPath classPath = null;
        switch (fileType) {
            case WEB_SOURCE: {
                classPath = this.cache.get((Object)ClassPathCache.SOURCE_COMPILATION);
                if (classPath != null) break;
                classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])this.properties.sourceCompileTimeClassPath));
                this.cache.put(ClassPathCache.SOURCE_COMPILATION, classPath);
                break;
            }
        }
        return classPath;
    }

    private synchronized ClassPath getRunTimeClasspath(FileType fileType) {
        ClassPath classPath = null;
        switch (fileType) {
            case WEB_SOURCE: {
                classPath = this.cache.get((Object)ClassPathCache.SOURCE_RUNTIME);
                if (classPath != null) break;
                classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])this.properties.sourceRunTimeClassPath));
                this.cache.put(ClassPathCache.SOURCE_RUNTIME, classPath);
                break;
            }
        }
        return classPath;
    }

    private synchronized ClassPath getSourcePath(FileType fileType) {
        ClassPath classPath = null;
        switch (fileType) {
            case WEB_SOURCE: {
                classPath = this.cache.get((Object)ClassPathCache.WEB_SOURCE);
                if (classPath != null) break;
                List<ClassPath> list = this.properties.additionalSourcePaths != null ? Arrays.asList(this.properties.additionalSourcePaths) : new ArrayList<ClassPath>(1);
                list.add(ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.sourceRoots, this.helper, this.evaluator)));
                classPath = ClassPathSupport.createProxyClassPath((ClassPath[])list.toArray(new ClassPath[list.size()]));
                this.cache.put(ClassPathCache.WEB_SOURCE, classPath);
                break;
            }
        }
        return classPath;
    }

    public synchronized ClassPath getJ2eePlatformClassPath() {
        ClassPath classPath = this.cache.get((Object)ClassPathCache.PLATFORM);
        if (classPath == null) {
            classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])this.properties.javaEEPlatformClasspath));
            this.cache.put(ClassPathCache.PLATFORM, classPath);
        }
        return classPath;
    }

    public ClassPath findClassPath(FileObject fileObject, String string) {
        ClassPath classPath = null;
        FileType fileType = this.getType(fileObject);
        switch (fileType) {
            case WEB_SOURCE: {
                if (string.equals("classpath/compile")) {
                    classPath = this.getCompileTimeClasspath(fileType);
                    break;
                }
                if (string.equals("classpath/execute")) {
                    classPath = this.getRunTimeClasspath(fileType);
                    break;
                }
                if (!string.equals("classpath/source")) break;
                classPath = this.getSourcePath(fileType);
                break;
            }
            default: {
                classPath = this.delegate.findClassPath(fileObject, string);
            }
        }
        return classPath;
    }

    public ClassPath[] getProjectClassPaths(String string) {
        if ("classpath/source".equals(string)) {
            List<ClassPath> list = Arrays.asList(this.delegate.getProjectClassPaths(string));
            list.add(1, this.getSourcePath(FileType.WEB_SOURCE));
            return list.toArray(new ClassPath[list.size()]);
        }
        return this.delegate.getProjectClassPaths(string);
    }

    public ClassPath getProjectSourcesClassPath(String string) {
        return this.delegate.getProjectSourcesClassPath(string);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.properties.webDocBaseDir.equals(propertyChangeEvent.getPropertyName())) {
            this.dirCache.remove(propertyChangeEvent.getPropertyName());
        } else {
            this.delegate.propertyChange(propertyChangeEvent);
        }
    }

    public synchronized void clearDirectoryCache() {
        this.delegate.clearDirectoryCache();
        this.dirCache.clear();
    }

    public static final class Properties {
        final DefaultClassPathProviderImpl.Properties delegate;
        final String webDocBaseDir;
        final String[] sourceCompileTimeClassPath;
        final String[] sourceRunTimeClassPath;
        final String[] javaEEPlatformClasspath;
        final ClassPath[] additionalSourcePaths;

        public Properties(String string, String string2, String string3, String string4, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, ClassPath[] classPathArray) {
            Parameters.notNull((CharSequence)"javaEEPlatformClasspath", (Object)stringArray5);
            this.delegate = new DefaultClassPathProviderImpl.Properties(string, string2, string3, stringArray, stringArray2, stringArray3, stringArray4);
            this.webDocBaseDir = string4;
            this.sourceCompileTimeClassPath = stringArray;
            this.sourceRunTimeClassPath = stringArray3;
            this.javaEEPlatformClasspath = stringArray5;
            this.additionalSourcePaths = classPathArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ClassPathCache {
        SOURCE_COMPILATION,
        SOURCE_RUNTIME,
        WEB_SOURCE,
        PLATFORM;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FileType {
        UNKNOWN,
        WEB_SOURCE;

    }
}

