/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.classpath.j2ee;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.java.api.common.classpath.ClassPathItem;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseClassPathSupport<T extends Item> {
    static final String ATTR_FILES = "files";
    static final String ATTR_DIRS = "dirs";
    final AntProjectHelper antProjectHelper;
    final ClassPathSupport delegate;
    final String projectConfigurationNameSpace;

    BaseClassPathSupport(PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, AntProjectHelper antProjectHelper, String[] stringArray, String string, String string2, String string3, String string4) {
        assert (string4 != null);
        this.antProjectHelper = antProjectHelper;
        this.projectConfigurationNameSpace = string4;
        this.delegate = ClassPathSupport.create(propertyEvaluator, referenceHelper, antProjectHelper, stringArray, string, string2, string3);
    }

    public Iterator<T> itemsIterator(String string, String string2) {
        return this.itemsList(string, string2).iterator();
    }

    public abstract List<T> itemsList(String var1, String var2);

    public abstract String[] encodeToStrings(List<T> var1, String var2);

    public static void getFilesForItem(Item item, List<File> list, List<File> list2) {
        if (item.isBroken()) {
            return;
        }
        switch (item.getType()) {
            case LIBRARY: {
                List list3 = item.getLibrary().getContent("classpath");
                for (URL uRL : list3) {
                    File file = FileUtil.archiveOrDirForURL((URL)uRL);
                    if (file == null) continue;
                    if (file.isFile()) {
                        list.add(file);
                        continue;
                    }
                    list2.add(file);
                }
                break;
            }
            case JAR: {
                File file = item.getFile();
                if (file == null) break;
                if (file.isFile()) {
                    list.add(file);
                    break;
                }
                list2.add(file);
                break;
            }
            case ARTIFACT: {
                URI[] uRIArray;
                String string = item.getArtifact().getScriptLocation().getParent();
                for (URI uRI : uRIArray = item.getArtifact().getArtifactLocations()) {
                    String string2 = string + File.separator + uRI;
                    if (string2.endsWith(File.separator)) {
                        list2.add(new File(string2));
                        continue;
                    }
                    list.add(new File(string2));
                }
                break;
            }
        }
    }

    public String getLibraryReference(T t) {
        return this.delegate.getLibraryReference(((Item)t).delegate);
    }

    public static boolean relativizeLibraryClassPath(EditableProperties editableProperties, AntProjectHelper antProjectHelper, String string) {
        return ClassPathSupport.relativizeLibraryClassPath(editableProperties, antProjectHelper, string);
    }

    static String findText(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            Text text = (Text)nodeList.item(i);
            return text.getNodeValue();
        }
        return null;
    }

    static abstract class Item
    implements ClassPathItem {
        final ClassPathSupport.Item delegate;
        private String property;
        private String raw;

        Item(ClassPathSupport.Item item, String string, String string2) {
            this.delegate = item;
            this.property = string;
            this.raw = string2;
        }

        void setReference(String string) {
            this.property = string;
        }

        public ClassPathItem.Type getType() {
            return this.delegate.getType();
        }

        public Library getLibrary() {
            return this.delegate.getLibrary();
        }

        public File getFile() {
            return this.delegate.getFile();
        }

        public AntArtifact getArtifact() {
            return this.delegate.getArtifact();
        }

        public URI getArtifactURI() {
            return this.delegate.getArtifactURI();
        }

        public String getReference() {
            return this.delegate.getReference();
        }

        public boolean isBroken() {
            return this.delegate.isBroken();
        }

        public String getRaw() {
            return this.raw;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Item) {
                Item item = (Item)object;
                return this.delegate.equals(item);
            }
            return false;
        }
    }
}

