/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore.model;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.CanvasRendererContext;
import org.netbeans.modules.soa.mappercore.MapperStyle;
import org.netbeans.modules.soa.mappercore.model.GraphItem;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.TargetPin;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.utils.Utils;

public class VertexItem
implements TargetPin,
GraphItem {
    private Vertex vertex;
    private Link ingoingLink;
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean hairline;
    private Object dataObject;
    private Object value;
    private Class valueType;
    private String shortDescription;

    public VertexItem(Vertex vertex) {
        this(vertex, null);
    }

    public VertexItem(Vertex vertex, Object object) {
        this(vertex, object, null, null, null, true);
    }

    public VertexItem(Vertex vertex, String string) {
        this(vertex, null, string, String.class, null, false);
    }

    public VertexItem(Vertex vertex, Object object, Class clazz) {
        this(vertex, null, object, clazz);
    }

    public VertexItem(Vertex vertex, Object object, Object object2, Class clazz) {
        this(vertex, object, object2, clazz, null, false);
    }

    public VertexItem(Vertex vertex, Object object, Object object2, Class clazz, String string, boolean bl) {
        if (vertex == null) {
            throw new IllegalArgumentException();
        }
        this.vertex = vertex;
        this.hairline = bl;
        this.value = object2;
        this.valueType = clazz;
        this.shortDescription = string;
        this.dataObject = object;
    }

    public Object getDataObject() {
        return this.dataObject;
    }

    public void setDataObject(Object object) {
        this.dataObject = object;
    }

    public Object getValue() {
        return this.value;
    }

    public String getText() {
        return this.value == null ? null : this.value.toString();
    }

    public void setText(String string) {
        this.setValue(string);
    }

    public Class getValueType() {
        return this.valueType;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setValue(Object object) {
        this.setValueAndType(object, this.getValueType());
    }

    public void setValueType(Class clazz) {
        this.setValueAndType(this.getValue(), clazz);
    }

    public void setValueAndType(Object object, Class clazz) {
        boolean bl = false;
        if (this.value != object) {
            this.value = object;
            bl = true;
        }
        if (!Utils.equal(this.valueType, clazz)) {
            this.valueType = clazz;
            bl = true;
        }
        if (bl) {
            this.getVertex().fireGraphContentChanged();
        }
    }

    public boolean isHairline() {
        return this.hairline;
    }

    public Link getIngoingLink() {
        return this.ingoingLink;
    }

    public void setIngoingLink(Link link) {
        if (this.ingoingLink != link) {
            this.ingoingLink = link;
        }
    }

    public Vertex getVertex() {
        return this.vertex;
    }

    public void moveOnTop() {
        this.getVertex().moveOnTop();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getAnchorX() {
        return this.vertex.getWidth();
    }

    public int getAnchorY() {
        return this.y + this.height / 2;
    }

    public int getGlobalX() {
        return this.vertex.getX() + this.x;
    }

    public int getGlobalY() {
        return this.vertex.getY() + this.y;
    }

    public int getPinX() {
        return 0;
    }

    public int getPinY() {
        return this.y + this.height / 2;
    }

    public int getPinGlobalX() {
        return this.vertex.getX() + this.getPinX();
    }

    public int getPinGlobalY() {
        return this.vertex.getY() + this.getPinY();
    }

    public boolean contains(int n, int n2, int n3) {
        int n4 = n - this.getGlobalX() * n3;
        int n5 = n2 - this.getGlobalY() * n3;
        return 0 <= n4 && 0 <= n5 && n4 <= this.width * n3 && n5 <= this.height * n3;
    }

    public boolean targetPinContains(int n, int n2, int n3) {
        int n4 = n - (this.getPinGlobalX() - 1) * n3;
        int n5 = n2 - (this.getPinGlobalY() * n3 - n3 / 2);
        return 0 <= n4 && 0 <= n5 && n4 <= n3 && n5 <= n3;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle getBounds(int n) {
        return new Rectangle(this.x * n, this.y * n, this.width * n, this.height * n);
    }

    public void paint(Graphics2D graphics2D, TreePath treePath, CanvasRendererContext canvasRendererContext, int n) {
        int n2 = canvasRendererContext.getStep();
        int n3 = canvasRendererContext.getGraphX() + this.getGlobalX() * n2;
        int n4 = n + this.getGlobalY() * n2;
        int n5 = this.getWidth() * n2;
        int n6 = this.getHeight() * n2;
        int n7 = n3 + 3;
        int n8 = n4 + 1;
        int n9 = n6 - 1;
        int n10 = n5 - 5;
        if (n10 > 0) {
            canvasRendererContext.getCanvas().paintVertexItemText(treePath, this, graphics2D, n7, n8, n10, n9);
        }
        if (canvasRendererContext.isSelected(treePath, this)) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setPaint(MapperStyle.SELECTION_COLOR);
            graphics2D.setStroke(MapperStyle.FOCUS_STROKE);
            graphics2D.drawRect(n3, n4, n5, n6);
            graphics2D.setStroke(stroke);
        }
    }

    public void paintTargetPin(Graphics2D graphics2D, TreePath treePath, CanvasRendererContext canvasRendererContext, int n) {
        int n2 = canvasRendererContext.getStep();
        int n3 = canvasRendererContext.getGraphX() + this.getPinGlobalX() * n2;
        int n4 = n + this.getPinGlobalY() * n2;
        Link link = this.getIngoingLink();
        boolean bl = canvasRendererContext.isSelected(treePath, this);
        if (canvasRendererContext.paintVertexItemPin(treePath, this)) {
            int n5 = n3 - n2;
            int n6 = n3 - 1;
            int n7 = n2 - 1;
            int n8 = n4 - n7 / 2;
            int n9 = n8 + n7;
            int n10 = (n6 - n5) / 3;
            int n11 = Math.min(n10, 2) * 2;
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            graphics2D.setPaint(bl ? MapperStyle.SELECTION_COLOR : MapperStyle.PIN_BACKGROUND_COLOR);
            graphics2D.fillRoundRect(n5, n8, n6 - n5, n9 - n8, n11, n11);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(n5 + n10, (float)n8 + 0.5f);
            generalPath.lineTo(n6 - n10, 0.5f * (float)(n8 + n9));
            generalPath.lineTo(n5 + n10, (float)n9 - 0.5f);
            graphics2D.setPaint(MapperStyle.PIN_FOREGROUND_COLOR);
            graphics2D.draw(generalPath);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        } else if (link != null && canvasRendererContext.paintLink(treePath, link)) {
            Color color = MapperStyle.LINK_COLOR_UNSELECTED_NODE;
            if (canvasRendererContext.isSelected(treePath)) {
                color = canvasRendererContext.isSelected(treePath, link) ? MapperStyle.SELECTION_COLOR : MapperStyle.LINK_COLOR_SELECTED_NODE;
            }
            Link.paintTargetDecoration(graphics2D, new Point(n3, n4), color, n2);
        }
    }

    public Point getTargetPinPoint(int n, int n2, int n3) {
        return new Point(n + this.getPinGlobalX() * n3, n2 + this.getPinGlobalY() * n3);
    }

    void setBounds(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }
}

